/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.items.ticker;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.button.ButtonScriptEngine;
import de.keksuccino.fancymenu.menu.fancy.item.items.IActionExecutorItem;
import de.keksuccino.fancymenu.menu.fancy.item.items.ticker.TickerCustomizationItemContainer;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class TickerCustomizationItem
extends CustomizationItem
implements IActionExecutorItem {
    public volatile List<ButtonScriptEngine.ActionContainer> actions = new ArrayList<ButtonScriptEngine.ActionContainer>();
    public volatile long tickDelayMs = 0L;
    public volatile boolean isAsync = false;
    public volatile TickMode tickMode = TickMode.NORMAL;
    protected volatile boolean ready = false;
    protected volatile boolean ticked = false;
    protected volatile long lastTick = -1L;
    protected volatile TickerItemThreadController asyncThreadController = null;

    public TickerCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        TickMode t;
        String tickModeString;
        String isAsyncString;
        Map.Entry m2;
        HashMap<Integer, ButtonScriptEngine.ActionContainer> tempActions = new HashMap<Integer, ButtonScriptEngine.ActionContainer>();
        for (Map.Entry m2 : item.getEntries().entrySet()) {
            if (!((String)m2.getKey()).startsWith("tickeraction_")) continue;
            String index = ((String)m2.getKey()).split("_", 3)[1];
            String tickerAction = ((String)m2.getKey()).split("_", 3)[2];
            String actionValue = (String)m2.getValue();
            if (!MathUtils.isInteger((String)index)) continue;
            tempActions.put(Integer.parseInt(index), new ButtonScriptEngine.ActionContainer(tickerAction, actionValue));
        }
        ArrayList indexes = new ArrayList();
        indexes.addAll(tempActions.keySet());
        Collections.sort(indexes);
        this.actions.clear();
        m2 = indexes.iterator();
        while (m2.hasNext()) {
            int i = (Integer)m2.next();
            this.actions.add((ButtonScriptEngine.ActionContainer)tempActions.get(i));
        }
        String tickDelayMsString = item.getEntryValue("tick_delay");
        if (tickDelayMsString != null && MathUtils.isLong((String)tickDelayMsString)) {
            this.tickDelayMs = Long.parseLong(tickDelayMsString);
        }
        if ((isAsyncString = item.getEntryValue("is_async")) != null && isAsyncString.equalsIgnoreCase("true")) {
            this.isAsync = true;
        }
        if ((tickModeString = item.getEntryValue("tick_mode")) != null && (t = TickMode.getByName(tickModeString)) != null) {
            this.tickMode = t;
        }
    }

    public void tick() {
        if (this.ready && this.shouldRender()) {
            if (this.ticked && this.tickMode == TickMode.ON_MENU_LOAD) {
                return;
            }
            if (this.tickMode == TickMode.ONCE_PER_SESSION && TickerCustomizationItemContainer.cachedOncePerSessionItems.contains(this.actionId)) {
                return;
            }
            if (this.tickMode == TickMode.ONCE_PER_SESSION) {
                TickerCustomizationItemContainer.cachedOncePerSessionItems.add(this.actionId);
            } else {
                TickerCustomizationItemContainer.cachedOncePerSessionItems.remove(this.actionId);
            }
            long now = System.currentTimeMillis();
            if (this.tickDelayMs <= 0L || this.lastTick + this.tickDelayMs <= now) {
                this.lastTick = now;
                this.ticked = true;
                for (ButtonScriptEngine.ActionContainer a : this.actions) {
                    a.execute();
                }
            }
        }
    }

    @Override
    public void render(PoseStack matrix, Screen menu) throws IOException {
        this.ready = true;
        if (TickerCustomizationItem.isEditorActive()) {
            RenderSystem.m_69478_();
            TickerCustomizationItem.m_93172_((PoseStack)matrix, (int)this.getPosX(menu), (int)this.getPosY(menu), (int)(this.getPosX(menu) + this.getWidth()), (int)(this.getPosY(menu) + this.getHeight()), (int)Color.ORANGE.getRGB());
            Font font = Minecraft.m_91087_().f_91062_;
            String string = "\u00a7l" + Locals.localize((String)"fancymenu.customization.items.ticker", (String[])new String[0]);
            int n = this.getPosX(menu) + this.getWidth() / 2;
            int n2 = this.getPosY(menu) + this.getHeight() / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            TickerCustomizationItem.m_93208_((PoseStack)matrix, (Font)font, (String)string, (int)n, (int)(n2 - 9 / 2), (int)-1);
        } else if (!this.isAsync) {
            this.tick();
        }
        if (!(!this.isAsync || this.asyncThreadController != null && this.asyncThreadController.running || TickerCustomizationItem.isEditorActive())) {
            this.asyncThreadController = new TickerItemThreadController();
            TickerCustomizationItemContainer.cachedThreadControllers.add(this.asyncThreadController);
            new Thread(() -> {
                while (this.asyncThreadController != null && this.asyncThreadController.running && this.isAsync) {
                    this.tick();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        if (!this.isAsync && this.asyncThreadController != null) {
            this.asyncThreadController.running = false;
        }
    }

    @Override
    public List<ButtonScriptEngine.ActionContainer> getActionList() {
        return this.actions;
    }

    public static enum TickMode {
        NORMAL("normal"),
        ONCE_PER_SESSION("once_per_session"),
        ON_MENU_LOAD("on_menu_load");

        public final String name;

        private TickMode(String name) {
            this.name = name;
        }

        @Nullable
        public static TickMode getByName(String name) {
            for (TickMode t : TickMode.values()) {
                if (!t.name.equals(name)) continue;
                return t;
            }
            return null;
        }
    }

    public static class TickerItemThreadController {
        public volatile boolean running = true;
    }
}

