/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import com.google.common.collect.ImmutableList;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import de.keksuccino.fancymenu.api.buttonaction.ButtonActionRegistry;
import de.keksuccino.fancymenu.compatibility.MinecraftCompatibilityUtils;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.button.ButtonMimeHandler;
import de.keksuccino.fancymenu.menu.button.buttonactions.LegacyButtonActions;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.fancy.helper.CustomizationHelper;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMNotificationPopup;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.guiconstruction.GuiConstructor;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.fancymenu.menu.world.LastWorldHandler;
import de.keksuccino.fancymenu.mixin.client.IMixinServerList;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.Pack;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonScriptEngine {
    private static final List<String> LEGACY_IDENTIFIERS = LegacyButtonActions.getLegacyIdentifiers();
    private static Map<String, ButtonScript> scripts = new HashMap<String, ButtonScript>();
    private static boolean init = false;

    public static void init() {
        if (!init) {
            init = true;
            MinecraftForge.EVENT_BUS.register((Object)new ButtonScriptEngine());
            ButtonScriptEngine.updateButtonScripts();
        }
    }

    public static void updateButtonScripts() {
        scripts.clear();
        if (!FancyMenu.getButtonScriptPath().exists()) {
            FancyMenu.getButtonScriptPath().mkdirs();
        }
        for (File f : FancyMenu.getButtonScriptPath().listFiles()) {
            if (!f.isFile() || !f.getPath().toLowerCase().endsWith(".txt")) continue;
            scripts.put(com.google.common.io.Files.getNameWithoutExtension((String)f.getPath()), new ButtonScript(f));
        }
    }

    public static void runButtonScript(String name) {
        if (scripts.containsKey(name)) {
            scripts.get(name).runScript();
        }
    }

    public static Map<String, ButtonScript> getButtonScripts() {
        return scripts;
    }

    public static void runButtonAction(String action, String value) {
        try {
            File f;
            File fromFile;
            File toFile;
            String from;
            int cur;
            MenuHandlerBase handler;
            File f2;
            if (value != null) {
                value = PlaceholderParser.replacePlaceholders(value);
            }
            if (action.equalsIgnoreCase("openlink")) {
                ButtonScriptEngine.openWebLink(StringUtils.convertFormatCodes((String)value, (String)"\u00a7", (String)"&"));
            }
            if (action.equalsIgnoreCase("sendmessage") && Minecraft.m_91087_().f_91073_ != null && !MinecraftForge.EVENT_BUS.post((Event)new ClientChatEvent(value))) {
                if (value != null && value.startsWith("/")) {
                    value = value.substring(1);
                    MinecraftCompatibilityUtils.sendPlayerCommand(Minecraft.m_91087_().f_91074_, value);
                } else {
                    MinecraftCompatibilityUtils.sendPlayerChatMessage(Minecraft.m_91087_().f_91074_, value);
                }
            }
            if (action.equalsIgnoreCase("quitgame")) {
                Minecraft.m_91087_().m_91395_();
            }
            if (action.equalsIgnoreCase("joinserver") && value != null) {
                String ip = value.replace(" ", "");
                int port = 25565;
                if (ip.contains(":")) {
                    String portString = ip.split("[:]", 2)[1];
                    ip = ip.split("[:]", 2)[0];
                    if (MathUtils.isInteger((String)portString)) {
                        port = Integer.parseInt(portString);
                    }
                }
                ServerData d = null;
                ServerList l = new ServerList(Minecraft.m_91087_());
                l.m_105431_();
                for (ServerData data : ((IMixinServerList)l).getServerListFancyMenu()) {
                    if (!data.f_105363_.equals(value.replace(" ", ""))) continue;
                    d = data;
                    break;
                }
                if (d == null) {
                    d = new ServerData(value.replace(" ", ""), value.replace(" ", ""), false);
                    l.m_233842_(d, false);
                    l.m_105442_();
                }
                ConnectScreen.m_169267_((Screen)Minecraft.m_91087_().f_91080_, (Minecraft)Minecraft.m_91087_(), (ServerAddress)new ServerAddress(ip, port), d);
            }
            if (action.equalsIgnoreCase("loadworld") && Minecraft.m_91087_().m_91392_().m_78255_(value)) {
                Minecraft.m_91087_().m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"selectWorld.data_read")));
                Minecraft.m_91087_().m_231466_().m_233133_(Minecraft.m_91087_().f_91080_, value);
            }
            if (action.equalsIgnoreCase("openfile") && (f2 = new File(value.replace("\\", "/"))).exists()) {
                ButtonScriptEngine.openFile(f2);
            }
            if (action.equalsIgnoreCase("prevbackground") && (handler = MenuHandlerRegistry.getLastActiveHandler()) != null && (cur = handler.getCurrentBackgroundAnimationId()) > 0) {
                for (IAnimationRenderer an : handler.backgroundAnimations()) {
                    if (!(an instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)an).stopAudio();
                }
                handler.setBackgroundAnimation(cur - 1);
            }
            if (action.equalsIgnoreCase("nextbackground") && (handler = MenuHandlerRegistry.getLastActiveHandler()) != null && (cur = handler.getCurrentBackgroundAnimationId()) < handler.backgroundAnimations().size() - 1) {
                for (IAnimationRenderer an : handler.backgroundAnimations()) {
                    if (!(an instanceof AdvancedAnimation)) continue;
                    ((AdvancedAnimation)an).stopAudio();
                }
                handler.setBackgroundAnimation(cur + 1);
            }
            if (action.equalsIgnoreCase("opencustomgui") && CustomGuiLoader.guiExists(value)) {
                Minecraft.m_91087_().m_91152_((Screen)CustomGuiLoader.getGui(value, Minecraft.m_91087_().f_91080_, null));
            }
            if (action.equalsIgnoreCase("opengui") && value != null) {
                if (MenuCustomization.getValidMenuIdentifierFor(value).equals(PackSelectionScreen.class.getName())) {
                    Screen parent = Minecraft.m_91087_().f_91080_;
                    PackSelectionScreen s = new PackSelectionScreen(parent, Minecraft.m_91087_().m_91099_(), repo -> {
                        ImmutableList list = ImmutableList.copyOf((Collection)Minecraft.m_91087_().f_91066_.f_92117_);
                        Minecraft.m_91087_().f_91066_.f_92117_.clear();
                        Minecraft.m_91087_().f_91066_.f_92118_.clear();
                        for (Pack pack : repo.m_10524_()) {
                            if (pack.m_10450_()) continue;
                            Minecraft.m_91087_().f_91066_.f_92117_.add(pack.m_10446_());
                            if (pack.m_10443_().m_10489_()) continue;
                            Minecraft.m_91087_().f_91066_.f_92118_.add(pack.m_10446_());
                        }
                        Minecraft.m_91087_().f_91066_.m_92169_();
                        ImmutableList list1 = ImmutableList.copyOf((Collection)Minecraft.m_91087_().f_91066_.f_92117_);
                        if (!list1.equals(list)) {
                            Minecraft.m_91087_().m_91391_();
                        }
                    }, Minecraft.m_91087_().m_91101_(), (Component)Component.m_237115_((String)"resourcePack.title"));
                    Minecraft.m_91087_().m_91152_((Screen)s);
                } else if (value.equals(CreateWorldScreen.class.getName())) {
                    CreateWorldScreen.m_232896_((Minecraft)Minecraft.m_91087_(), (Screen)Minecraft.m_91087_().f_91080_);
                } else {
                    try {
                        if (CustomGuiLoader.guiExists(value)) {
                            Minecraft.m_91087_().m_91152_((Screen)CustomGuiLoader.getGui(value, Minecraft.m_91087_().f_91080_, null));
                        } else {
                            Screen s = GuiConstructor.tryToConstruct(MenuCustomization.getValidMenuIdentifierFor(value));
                            if (s != null) {
                                Minecraft.m_91087_().m_91152_(s);
                            } else {
                                PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"custombuttons.action.opengui.cannotopengui", (String[])new String[0])));
                            }
                        }
                    }
                    catch (Exception e) {
                        PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"custombuttons.action.opengui.cannotopengui", (String[])new String[0])));
                        e.printStackTrace();
                    }
                }
            }
            if (action.equalsIgnoreCase("movefile") && value.contains(";")) {
                from = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String to = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[1]);
                toFile = new File(to);
                fromFile = new File(from);
                FileUtils.moveFile((File)fromFile, (File)toFile);
            }
            if (action.equalsIgnoreCase("copyfile") && value.contains(";")) {
                from = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String to = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[1]);
                toFile = new File(to);
                fromFile = new File(from);
                FileUtils.copyFile((File)fromFile, (File)toFile);
            }
            if (action.equalsIgnoreCase("deletefile") && (f2 = new File(ButtonScriptEngine.cleanPath(value))).exists() && f2.delete()) {
                for (int i = 0; f2.exists() && i < 100; ++i) {
                    Thread.sleep(100L);
                }
            }
            if (action.equalsIgnoreCase("renamefile") && value.contains(";")) {
                String path = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String name = value.split("[;]", 2)[1];
                f = new File(path);
                if (f.exists()) {
                    String parent = f.getParent();
                    if (parent != null) {
                        f.renameTo(new File(parent + "/" + name));
                    } else {
                        f.renameTo(new File(name));
                    }
                }
            }
            if (action.equalsIgnoreCase("downloadfile") && value.contains(";")) {
                String url = StringUtils.convertFormatCodes((String)ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]), (String)"\u00a7", (String)"&");
                String path = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[1]);
                f = new File(path);
                if (!f.exists()) {
                    f.mkdirs();
                }
                InputStream in = new URL(url).openStream();
                Files.copy(in, Paths.get(new File(path).toURI()), StandardCopyOption.REPLACE_EXISTING);
            }
            if (action.equalsIgnoreCase("unpackzip") && value.contains(";")) {
                String zipPath = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[0]);
                String outputDir = ButtonScriptEngine.cleanPath(value.split("[;]", 2)[1]);
                FileUtils.unpackZip((String)zipPath, (String)outputDir);
            }
            if (action.equalsIgnoreCase("reloadmenu")) {
                CustomizationHelper.reloadSystemAndMenu();
            }
            if (action.equalsIgnoreCase("runscript") && scripts.containsKey(value)) {
                ButtonScriptEngine.runButtonScript(value);
            }
            if (action.equalsIgnoreCase("mutebackgroundsounds") && value != null) {
                if (value.equalsIgnoreCase("true")) {
                    FancyMenu.config.setValue("playbackgroundsounds", Boolean.valueOf(false));
                    MenuCustomization.stopSounds();
                }
                if (value.equalsIgnoreCase("false")) {
                    FancyMenu.config.setValue("playbackgroundsounds", Boolean.valueOf(true));
                    CustomizationHelper.reloadSystemAndMenu();
                }
            }
            if (action.equalsIgnoreCase("runcmd")) {
                ButtonScriptEngine.runCMD(value);
            }
            if (action.equalsIgnoreCase("closegui")) {
                Minecraft.m_91087_().m_91152_(null);
            }
            if (action.equalsIgnoreCase("copytoclipboard")) {
                Minecraft.m_91087_().f_91068_.m_90911_(value);
            }
            if (action.equalsIgnoreCase("mimicbutton")) {
                if (value != null && value.contains(":")) {
                    if (!ButtonMimeHandler.executeButtonAction(value)) {
                        PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"fancymenu.custombutton.action.mimicbutton.unabletoexecute", (String[])new String[0])));
                    }
                } else {
                    PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"fancymenu.custombutton.action.mimicbutton.unabletoexecute", (String[])new String[0])));
                }
            }
            if (action.equalsIgnoreCase("join_last_world") && !LastWorldHandler.getLastWorld().equals("")) {
                if (!LastWorldHandler.isLastWorldServer()) {
                    f2 = new File(LastWorldHandler.getLastWorld());
                    if (Minecraft.m_91087_().m_91392_().m_78255_(f2.getName())) {
                        Minecraft.m_91087_().m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"selectWorld.data_read")));
                        Minecraft.m_91087_().m_231466_().m_233133_(Minecraft.m_91087_().f_91080_, f2.getName());
                    }
                } else {
                    String ipRaw;
                    String ip = ipRaw = LastWorldHandler.getLastWorld().replace(" ", "");
                    int port = 25565;
                    if (ip.contains(":")) {
                        String portString = ip.split("[:]", 2)[1];
                        ip = ip.split("[:]", 2)[0];
                        if (MathUtils.isInteger((String)portString)) {
                            port = Integer.parseInt(portString);
                        }
                    }
                    ServerData d = null;
                    ServerList l = new ServerList(Minecraft.m_91087_());
                    l.m_105431_();
                    for (ServerData data : ((IMixinServerList)l).getServerListFancyMenu()) {
                        if (!data.f_105363_.equals(ipRaw)) continue;
                        d = data;
                        break;
                    }
                    if (d == null) {
                        d = new ServerData(ipRaw, ipRaw, false);
                        l.m_233842_(d, false);
                        l.m_105442_();
                    }
                    ConnectScreen.m_169267_((Screen)Minecraft.m_91087_().f_91080_, (Minecraft)Minecraft.m_91087_(), (ServerAddress)new ServerAddress(ip, port), (ServerData)d);
                }
            }
            if (LEGACY_IDENTIFIERS.contains(action)) {
                return;
            }
            ButtonActionContainer c = ButtonActionRegistry.getActionByName(action);
            if (c != null) {
                if (c.hasValue()) {
                    c.execute(value);
                } else {
                    c.execute(null);
                }
            }
        }
        catch (Exception e) {
            System.out.println("################ ERROR [FANCYMENU] ################");
            System.out.println("An error happened while trying to execute a button action!");
            System.out.println("Action: " + action);
            System.out.println("Value: " + value);
            System.out.println("###################################################");
            e.printStackTrace();
        }
    }

    public static void openWebLink(String url) {
        try {
            String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            URL u = new URL(url);
            if (!Minecraft.f_91002_) {
                if (s.contains("win")) {
                    Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
                } else {
                    if (u.getProtocol().equals("file")) {
                        url = url.replace("file:", "file://");
                    }
                    Runtime.getRuntime().exec(new String[]{"xdg-open", url});
                }
            } else {
                Runtime.getRuntime().exec(new String[]{"open", url});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void openFile(File f) {
        try {
            ButtonScriptEngine.openWebLink(f.toURI().toURL().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isMacOS() {
        return Minecraft.f_91002_;
    }

    private static boolean isWindows() {
        String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        return s.contains("win");
    }

    private static void runCMD(String cmd) {
        try {
            if (cmd != null) {
                cmd = cmd.replace("];", "%e%;");
                cmd = cmd.replace("[windows:", "%s%windows:");
                cmd = cmd.replace("[macos:", "%s%macos:");
                if ((cmd = cmd.replace("[linux:", "%s%linux:")).contains("%s%") && cmd.contains("%e%;")) {
                    String s = null;
                    if (ButtonScriptEngine.isMacOS()) {
                        if (cmd.contains("%s%macos:")) {
                            s = cmd.split("%s%macos:", 2)[1];
                        }
                    } else if (ButtonScriptEngine.isWindows()) {
                        if (cmd.contains("%s%windows:")) {
                            s = cmd.split("%s%windows:", 2)[1];
                        }
                    } else if (cmd.contains("%s%linux:")) {
                        s = cmd.split("%s%linux:", 2)[1];
                    }
                    if (s != null) {
                        if (s.contains("%e%;")) {
                            s = s.split("%e%;", 2)[0];
                            Runtime.getRuntime().exec(s);
                        }
                    } else {
                        System.out.println("############## ERROR [FANCYMENU] ##############");
                        System.out.println("Invalid value for 'runcmd' button action!");
                        System.out.println("Missing OS name in '" + cmd.replace("%s%", "[").replace("%e%", "]") + "'!");
                        System.out.println("###############################################");
                    }
                } else {
                    Runtime.getRuntime().exec(cmd);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String cleanPath(String path) {
        int i = 0;
        for (char c : path.toCharArray()) {
            if (c != " ".charAt(0)) break;
            ++i;
        }
        if (i <= path.length()) {
            return path.substring(i).replace("\\", "/");
        }
        return "";
    }

    @SubscribeEvent
    public void onMenuReload(MenuReloadedEvent e) {
        ButtonScriptEngine.updateButtonScripts();
    }

    public static class ButtonScript {
        public final File script;
        public final List<String> actions = new ArrayList<String>();
        public final List<String> values = new ArrayList<String>();

        public ButtonScript(File script) {
            this.script = script;
            for (String s : FileUtils.getFileLines((File)script)) {
                String action = "";
                String value = "";
                if (s.contains(":")) {
                    action = s.split("[:]", 2)[0].replace(" ", "");
                    value = s.split("[:]", 2)[1];
                } else {
                    action = s.replace(" ", "");
                }
                this.actions.add(action);
                this.values.add(value);
            }
        }

        public void runScript() {
            if (!this.actions.isEmpty()) {
                for (int i = 0; i <= this.actions.size() - 1; ++i) {
                    ButtonScriptEngine.runButtonAction(this.actions.get(i), this.values.get(i));
                }
            }
        }
    }

    public static class ActionContainer {
        public volatile String action;
        public volatile String value;

        public ActionContainer(@NotNull String action, @Nullable String value) {
            this.action = action;
            this.value = value;
        }

        public void execute() {
            try {
                ButtonScriptEngine.runButtonAction(this.action, this.value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

