/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.api;

import java.util.LinkedList;
import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ApiList {
    private final List<DynamicCrosshairApi> apis = new LinkedList<DynamicCrosshairApi>();
    boolean finalized = false;

    ApiList() {
    }

    public ApiList add(ItemStack itemStack) {
        if (itemStack != null) {
            this.add(ApiList.getNamespace(itemStack));
        }
        return this;
    }

    public ApiList add(BlockState blockState) {
        if (blockState != null) {
            this.add(ApiList.getNamespace(blockState));
        }
        return this;
    }

    public ApiList add(Entity entity) {
        if (entity != null) {
            this.add(ApiList.getNamespace(entity));
        }
        return this;
    }

    public ApiList add(String namespace) {
        if (!"minecraft".equals(namespace) && DynamicCrosshair.apis.containsKey(namespace)) {
            this.apis.add(DynamicCrosshair.apis.get(namespace));
        }
        return this;
    }

    public List<DynamicCrosshairApi> get() {
        if (!this.finalized) {
            for (String namespace : DynamicCrosshair.alwaysCheckedApis) {
                this.apis.add(DynamicCrosshair.apis.get(namespace));
            }
            this.apis.add(DynamicCrosshair.vanillaApi);
            this.finalized = true;
        }
        return this.apis;
    }

    private static String getNamespace(ItemStack itemStack) {
        return Registry.f_122827_.m_7981_((Object)itemStack.m_41720_()).m_135827_();
    }

    private static String getNamespace(BlockState blockState) {
        return Registry.f_122824_.m_7981_((Object)blockState.m_60734_()).m_135827_();
    }

    private static String getNamespace(Entity entity) {
        return Registry.f_122826_.m_7981_((Object)entity.m_6095_()).m_135827_();
    }
}

