/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.mixin.mixins.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayMenuHandler;
import de.keksuccino.drippyloadingscreen.customization.DrippyOverlayScreen;
import de.keksuccino.drippyloadingscreen.customization.deepcustomization.DeepCustomizationLayers;
import de.keksuccino.drippyloadingscreen.customization.items.Items;
import de.keksuccino.drippyloadingscreen.customization.placeholders.Placeholders;
import de.keksuccino.drippyloadingscreen.mixin.MixinCache;
import de.keksuccino.drippyloadingscreen.mixin.mixins.client.IMixinFontManager;
import de.keksuccino.drippyloadingscreen.mixin.mixins.client.IMixinLoadingOverlay;
import de.keksuccino.drippyloadingscreen.mixin.mixins.client.IMixinMinecraft;
import de.keksuccino.drippyloadingscreen.mixin.mixins.client.IMixinSimplePreparableReloadListener;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.api.item.CustomizationItemRegistry;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.button.ButtonCachedEvent;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.gameintro.GameIntroHandler;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMNotificationPopup;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.items.ticker.TickerCustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.StringUtils;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LoadingOverlay.class})
public class MixinLoadingOverlay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final File CHECKED_FOR_OLD_LAYOUTS_FILE = new File(DrippyLoadingScreen.MOD_DIR.getPath(), "/.checked_for_old_layouts");
    private static final File LEGACY_LAYOUT_DIR = new File(DrippyLoadingScreen.MOD_DIR.getPath(), "/customization");
    @Shadow
    private float f_96167_;
    private static boolean initialized = false;
    private static DrippyOverlayScreen drippyOverlayScreen = null;
    private static DrippyOverlayMenuHandler drippyOverlayHandler = null;
    private int lastScreenWidth = 0;
    private int lastScreenHeight = 0;
    private double renderScale = 0.0;
    private boolean overlayScaled = false;
    private static final IntSupplier BACKGROUND_COLOR = () -> {
        if (drippyOverlayHandler != null && MixinLoadingOverlay.drippyOverlayHandler.customBackgroundColor != null) {
            return MixinLoadingOverlay.drippyOverlayHandler.customBackgroundColor.getRGB();
        }
        return IMixinLoadingOverlay.getBrandBackgroundDrippy().getAsInt();
    };

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(Minecraft mc, ReloadInstance reload, Consumer consumer, boolean b, CallbackInfo info) {
        if (!initialized) {
            DrippyLoadingScreen.initConfig();
            LOGGER.info("[DRIPPY LOADING SCREEN] Initializing fonts for text rendering..");
            this.loadFonts();
            Placeholders.registerAll();
            Items.registerAll();
            DeepCustomizationLayers.registerAll();
            LOGGER.info("[DRIPPY LOADING SCREEN] Calculating animation sizes for FancyMenu..");
            AnimationHandler.setupAnimationSizes();
            initialized = true;
        }
        this.handleInitOverlay();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRenderPre(PoseStack matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
        MixinCache.cachedCurrentLoadingScreenProgress = this.f_96167_;
        this.handleInitOverlay();
        this.scaleOverlayStart(matrix);
        if (drippyOverlayScreen != null) {
            this.runMenuHandlerTask(() -> drippyOverlayHandler.onRenderPre(new ScreenEvent.Render.Pre((Screen)drippyOverlayScreen, matrix, mouseX, mouseY, partial)));
        }
        this.scaleOverlayEnd(matrix);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRenderPost(PoseStack matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
        this.scaleOverlayStart(matrix);
        if (drippyOverlayScreen != null) {
            this.runMenuHandlerTask(() -> drippyOverlayHandler.onRenderPost(new ScreenEvent.Render.Post((Screen)drippyOverlayScreen, matrix, mouseX, mouseY, partial)));
        }
        this.scaleOverlayEnd(matrix);
        MixinCache.cachedCurrentLoadingScreenProgress = this.f_96167_;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V")})
    private void onBackgroundRendered(PoseStack matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
        this.scaleOverlayStart(matrix);
        if (drippyOverlayScreen != null) {
            this.runMenuHandlerTask(() -> drippyOverlayHandler.drawToBackground(new ScreenEvent.BackgroundRendered((Screen)drippyOverlayScreen, matrix)));
        }
        this.scaleOverlayEnd(matrix);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V")})
    private void onClose(PoseStack matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            this.checkForOldLayouts();
        }
    }

    private void checkForOldLayouts() {
        String[] layoutFilesList;
        if (LEGACY_LAYOUT_DIR.isDirectory() && (layoutFilesList = LEGACY_LAYOUT_DIR.list((dir, name) -> name.toLowerCase().endsWith(".dllayout"))).length > 0 && !CHECKED_FOR_OLD_LAYOUTS_FILE.isFile()) {
            try {
                CHECKED_FOR_OLD_LAYOUTS_FILE.createNewFile();
                PopupHandler.displayPopup((Popup)new FMNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, StringUtils.splitLines((String)I18n.m_118938_((String)"drippyloadingscreen.legacy_support.old_layouts", (Object[])new Object[0]), (String)"\n")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clearColor(FFFF)V"), index=0)
    private float overrideBackgroundColorInClearColor0(float f) {
        int i2 = BACKGROUND_COLOR.getAsInt();
        return (float)(i2 >> 16 & 0xFF) / 255.0f;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clearColor(FFFF)V"), index=1)
    private float overrideBackgroundColorInClearColor1(float f) {
        int i2 = BACKGROUND_COLOR.getAsInt();
        return (float)(i2 >> 8 & 0xFF) / 255.0f;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/GlStateManager;_clearColor(FFFF)V"), index=2)
    private float overrideBackgroundColorInClearColor2(float f) {
        int i2 = BACKGROUND_COLOR.getAsInt();
        return (float)(i2 & 0xFF) / 255.0f;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;replaceAlpha(II)I"), index=0)
    private int overrideBackgroundColorInReplaceAlpha(int originalColor) {
        return BACKGROUND_COLOR.getAsInt();
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;replaceAlpha(II)I"), index=1)
    private int setCustomBackgroundOpacityInReplaceAlpha(int alpha) {
        float opacity = Math.max(0.0f, Math.min(1.0f, (float)alpha / 255.0f));
        this.setCustomBackgroundOpacity(opacity);
        if (!((Boolean)DrippyLoadingScreen.config.getOrDefault("early_fade_out_elements", (Object)false)).booleanValue()) {
            this.setOverlayOpacity(opacity);
        }
        return alpha;
    }

    @Inject(method={"drawProgressBar"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceOriginalProgressBar(PoseStack matrix, int p_96184_, int p_96185_, int p_96186_, int p_96187_, float opacity, CallbackInfo info) {
        info.cancel();
        if (((Boolean)DrippyLoadingScreen.config.getOrDefault("early_fade_out_elements", (Object)false)).booleanValue()) {
            this.setOverlayOpacity(opacity);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (drippyOverlayHandler != null && MixinLoadingOverlay.drippyOverlayHandler.progressBarItem != null && drippyOverlayScreen != null) {
            if (!MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.useOriginalSizeAndPosCalculation) {
                this.scaleOverlayStart(matrix);
            }
            MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.render(matrix, drippyOverlayScreen);
            this.scaleOverlayEnd(matrix);
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;blit(Lcom/mojang/blaze3d/vertex/PoseStack;IIIIFFIIII)V"), index=1)
    private int renderOriginalLogoOffscreenSetXMin(int xMinOriginal) {
        return -1000000;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;blit(Lcom/mojang/blaze3d/vertex/PoseStack;IIIIFFIIII)V"), index=2)
    private int renderOriginalLogoOffscreenSetYMin(int yMinOriginal) {
        return -1000000;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;blit(Lcom/mojang/blaze3d/vertex/PoseStack;IIIIFFIIII)V"), index=3)
    private int renderOriginalLogoOffscreenSetXMax(int xMaxOriginal) {
        return -1000000;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/LoadingOverlay;blit(Lcom/mojang/blaze3d/vertex/PoseStack;IIIIFFIIII)V"), index=4)
    private int renderOriginalLogoOffscreenSetYMax(int yMaxOriginal) {
        return -1000000;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;disableBlend()V", shift=At.Shift.AFTER)})
    private void renderCustomizableInstanceOfLogo(PoseStack matrix, int p_96179_, int p_96180_, float p_96181_, CallbackInfo info) {
        if (drippyOverlayHandler != null && MixinLoadingOverlay.drippyOverlayHandler.logoItem != null && drippyOverlayScreen != null) {
            if (!MixinLoadingOverlay.drippyOverlayHandler.logoItem.useOriginalSizeAndPosCalculation) {
                this.scaleOverlayStart(matrix);
            }
            MixinLoadingOverlay.drippyOverlayHandler.logoItem.render(matrix, drippyOverlayScreen);
            this.scaleOverlayEnd(matrix);
        }
    }

    private void setCustomBackgroundOpacity(float opacity) {
        if (drippyOverlayHandler != null) {
            MixinLoadingOverlay.drippyOverlayHandler.backgroundOpacity = opacity;
        }
    }

    private void setOverlayOpacity(float opacity) {
        if (opacity < 0.02f) {
            opacity = 0.02f;
        }
        if (drippyOverlayHandler != null) {
            ArrayList l = new ArrayList();
            l.addAll(MixinLoadingOverlay.drippyOverlayHandler.frontRenderItems);
            l.addAll(MixinLoadingOverlay.drippyOverlayHandler.backgroundRenderItems);
            for (CustomizationItemBase i : l) {
                i.opacity = opacity;
                if (!(i.opacity <= 0.02f)) continue;
                i.visible = false;
            }
            if (MixinLoadingOverlay.drippyOverlayHandler.logoItem != null) {
                MixinLoadingOverlay.drippyOverlayHandler.logoItem.opacity = opacity;
                if (MixinLoadingOverlay.drippyOverlayHandler.logoItem.opacity <= 0.02f) {
                    MixinLoadingOverlay.drippyOverlayHandler.logoItem.hidden = true;
                }
            }
            if (MixinLoadingOverlay.drippyOverlayHandler.progressBarItem != null) {
                MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.opacity = opacity;
                if (MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.opacity <= 0.02f) {
                    MixinLoadingOverlay.drippyOverlayHandler.progressBarItem.hidden = true;
                }
            }
        }
    }

    private void loadFonts() {
        try {
            MixinCache.gameThreadRunnables.add(() -> {
                Object m = ((IMixinSimplePreparableReloadListener)((IMixinFontManager)((IMixinMinecraft)Minecraft.m_91087_()).getFontManagerDrippy()).getReloadListenerDrippy()).invokePrepareDrippy(Minecraft.m_91087_().m_91098_(), (ProfilerFiller)InactiveProfiler.f_18554_);
                ((IMixinSimplePreparableReloadListener)((IMixinFontManager)((IMixinMinecraft)Minecraft.m_91087_()).getFontManagerDrippy()).getReloadListenerDrippy()).invokeApplyDrippy(m, Minecraft.m_91087_().m_91098_(), (ProfilerFiller)InactiveProfiler.f_18554_);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleInitOverlay() {
        try {
            CustomizationItemContainer tickerItem = CustomizationItemRegistry.getItem((String)"fancymenu_customization_item_ticker");
            if (tickerItem != null) {
                ((TickerCustomizationItemContainer)tickerItem).onClientTick(new TickEvent.ClientTickEvent(TickEvent.Phase.END));
            }
            int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
            int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
            if (drippyOverlayScreen == null) {
                Map<String, MenuHandlerBase> m;
                drippyOverlayScreen = new DrippyOverlayScreen();
                MenuHandlerBase b = MenuHandlerRegistry.getHandlerFor((Screen)drippyOverlayScreen);
                if (b != null && (m = this.getMenuHandlerRegistryMap()) != null) {
                    m.remove(DrippyOverlayScreen.class.getName());
                }
                b = new DrippyOverlayMenuHandler();
                MenuHandlerRegistry.registerHandler((MenuHandlerBase)b);
                drippyOverlayHandler = (DrippyOverlayMenuHandler)b;
                this.initOverlay(screenWidth, screenHeight);
                this.lastScreenWidth = screenWidth;
                this.lastScreenHeight = screenHeight;
            }
            if (screenWidth != this.lastScreenWidth || screenHeight != this.lastScreenHeight) {
                this.initOverlay(screenWidth, screenHeight);
            }
            this.lastScreenWidth = screenWidth;
            this.lastScreenHeight = screenHeight;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    private Map<String, MenuHandlerBase> getMenuHandlerRegistryMap() {
        try {
            Field f = MenuHandlerRegistry.class.getDeclaredField("handlers");
            f.setAccessible(true);
            return (Map)f.get(MenuHandlerRegistry.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initOverlay(int screenWidth, int screenHeight) {
        this.runMenuHandlerTask(() -> {
            try {
                MixinLoadingOverlay.drippyOverlayScreen.f_96543_ = screenWidth;
                MixinLoadingOverlay.drippyOverlayScreen.f_96544_ = screenHeight;
                double oriScale = Minecraft.m_91087_().m_91268_().m_85449_();
                drippyOverlayHandler.onInitPre(new ScreenEvent.Init.Pre((Screen)drippyOverlayScreen, new ArrayList(), d -> {}, d -> {}));
                drippyOverlayHandler.onButtonsCached(new ButtonCachedEvent((Screen)drippyOverlayScreen, new ArrayList(), false));
                this.renderScale = Minecraft.m_91087_().m_91268_().m_85449_();
                Minecraft.m_91087_().m_91268_().m_85378_(oriScale);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void scaleOverlayStart(PoseStack matrix) {
        this.overlayScaled = true;
        double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
        float scale = (float)(1.0 * (1.0 / guiScale) * this.renderScale);
        if (drippyOverlayHandler != null) {
            ArrayList l = new ArrayList();
            l.addAll(MixinLoadingOverlay.drippyOverlayHandler.frontRenderItems);
            l.addAll(MixinLoadingOverlay.drippyOverlayHandler.backgroundRenderItems);
            for (CustomizationItemBase i : l) {
                i.customGuiScale = (float)this.renderScale;
            }
        }
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, scale);
    }

    private void scaleOverlayEnd(PoseStack matrix) {
        if (this.overlayScaled) {
            matrix.m_85849_();
            this.overlayScaled = false;
        }
    }

    private void runMenuHandlerTask(Runnable run) {
        try {
            boolean gameIntroDisplayed = GameIntroHandler.introDisplayed;
            GameIntroHandler.introDisplayed = true;
            MenuHandlerBase menuHandler = MenuHandlerRegistry.getLastActiveHandler();
            MenuHandlerRegistry.setActiveHandler((String)DrippyOverlayScreen.class.getName());
            boolean allowCustomizations = MenuCustomization.allowScreenCustomization;
            MenuCustomization.allowScreenCustomization = true;
            boolean animationsReady = AnimationHandler.isReady();
            AnimationHandler.setReady((boolean)true);
            Screen s = Minecraft.m_91087_().f_91080_;
            if (s == null || !(s instanceof DrippyOverlayScreen)) {
                Minecraft.m_91087_().f_91080_ = drippyOverlayScreen;
                run.run();
                Minecraft.m_91087_().f_91080_ = s;
            }
            GameIntroHandler.introDisplayed = gameIntroDisplayed;
            MenuCustomization.allowScreenCustomization = allowCustomizations;
            AnimationHandler.setReady((boolean)animationsReady);
            if (menuHandler != null) {
                MenuHandlerRegistry.setActiveHandler((String)menuHandler.getMenuIdentifier());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

