/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.configuration;

import me.hypherionmc.shaded.moonconfig.core.conversion.Path;
import me.hypherionmc.shaded.moonconfig.core.conversion.SpecComment;
import me.hypherionmc.shaded.moonconfig.core.fields.RandomArrayList;
import me.hypherionmc.simplerpclib.config.BaseRPCConfig;
import me.hypherionmc.simplerpclib.configuration.objects.CustomVariablesConfig;
import me.hypherionmc.simplerpclib.configuration.objects.Dimension;
import me.hypherionmc.simplerpclib.configuration.objects.DimensionSection;
import me.hypherionmc.simplerpclib.configuration.objects.GeneralConfig;
import me.hypherionmc.simplerpclib.configuration.presence.GenericSection;
import me.hypherionmc.simplerpclib.configuration.presence.InitSection;
import me.hypherionmc.simplerpclib.configuration.presence.JoinGameSection;
import me.hypherionmc.simplerpclib.configuration.presence.MainMenuSection;
import me.hypherionmc.simplerpclib.configuration.presence.MultiPlayerSection;
import me.hypherionmc.simplerpclib.configuration.presence.RealmsGameSection;
import me.hypherionmc.simplerpclib.configuration.presence.RealmsScreenSection;
import me.hypherionmc.simplerpclib.configuration.presence.ServerListSection;
import me.hypherionmc.simplerpclib.configuration.presence.SinglePlayerSection;
import me.hypherionmc.simplerpclib.discord.RichPresenceCore;

public class ClientConfig
extends BaseRPCConfig {
    public transient String configPath = "";
    private final transient RichPresenceCore core;
    @Path(value="general")
    @SpecComment(value="General Config Section. See https://readme.firstdarkdev.xyz/simple-rpc/introduction/")
    public GeneralConfig general = new GeneralConfig();
    @Path(value="init")
    @SpecComment(value="The Game Loading event")
    public InitSection init = new InitSection();
    @Path(value="main_menu")
    @SpecComment(value="The Main Menu event")
    public MainMenuSection main_menu = new MainMenuSection();
    @Path(value="server_list")
    @SpecComment(value="The Server List event")
    public ServerListSection server_list = new ServerListSection();
    @Path(value="realms_list")
    @SpecComment(value="The Realms Screen event")
    public RealmsScreenSection realmsScreenSection = new RealmsScreenSection();
    @Path(value="join_game")
    @SpecComment(value="The Join Game Event")
    public JoinGameSection join_game = new JoinGameSection();
    @Path(value="single_player")
    @SpecComment(value="The Single Player Event")
    public SinglePlayerSection single_player = new SinglePlayerSection();
    @Path(value="multi_player")
    @SpecComment(value="The Multi Player Event")
    public MultiPlayerSection multi_player = new MultiPlayerSection();
    @Path(value="realms")
    @SpecComment(value="The Realms Game Event")
    public RealmsGameSection realmsGameSection = new RealmsGameSection();
    @Path(value="generic")
    @SpecComment(value="Fallback event for disabled events")
    public GenericSection generic = new GenericSection();
    @Path(value="custom")
    @SpecComment(value="Custom Config Variables that you can use")
    public CustomVariablesConfig variablesConfig = new CustomVariablesConfig();
    @Path(value="dimension_overrides")
    @SpecComment(value="Dimension Information Overrides")
    public DimensionSection dimension_overrides = new DimensionSection();

    public ClientConfig(RichPresenceCore core) {
        super("simple-rpc", core.getLangCode());
        this.core = core;
        this.registerAndSetup(this);
    }

    @Override
    public void configReloaded() {
        this.core.setClientConfig((ClientConfig)this.loadConfig(this));
    }

    @Override
    public void appendAdditional() {
        this.dimension_overrides.dimensions.add(new Dimension("overworld", "%player% is in The Overworld", "", RandomArrayList.of(new String[]{"overworld"}), "In the Overworld", RandomArrayList.of(new String[]{"mclogo"}), "%mods% mods installed"));
        this.dimension_overrides.dimensions.add(new Dimension("the_nether", "%player% is in The Nether", "", RandomArrayList.of(new String[]{"nether"}), "In the Nether", RandomArrayList.of(new String[]{"mclogo"}), "%mods% mods installed"));
        this.dimension_overrides.dimensions.add(new Dimension("the_end", "%player% is in The End", "", RandomArrayList.of(new String[]{"end"}), "In the End", RandomArrayList.of(new String[]{"mclogo"}), "%mods% mods installed"));
    }

    @Override
    public int getConfigVersion() {
        return GeneralConfig.version;
    }
}

