/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.gui;

import fr.atesab.customcursormod.common.config.CursorConfig;
import fr.atesab.customcursormod.common.cursor.CursorType;
import fr.atesab.customcursormod.common.cursor.SelectZone;
import fr.atesab.customcursormod.common.handler.CommonButton;
import fr.atesab.customcursormod.common.handler.CommonMatrixStack;
import fr.atesab.customcursormod.common.handler.CommonScreen;
import fr.atesab.customcursormod.common.handler.CommonShaders;
import fr.atesab.customcursormod.common.handler.CommonTextField;
import fr.atesab.customcursormod.common.handler.GuiUtils;
import fr.atesab.customcursormod.common.handler.TranslationCommonText;
import fr.atesab.customcursormod.common.utils.I18n;
import fr.atesab.customcursormod.common.utils.MathHelper;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.imageio.ImageIO;

public class GuiCursorConfig
extends CommonScreen.ScreenListener {
    private SelectZone selectZone;
    private CommonTextField xhotspot;
    private CommonTextField yhotspot;
    private CommonTextField cursorLocation;
    private CommonButton doneButton;
    private int imageWidth = 1;
    private int imageHeight = 1;
    private int numImage = 1;
    private final CursorType type;
    private CursorConfig cursorConfig;
    private Consumer<CursorConfig> callback;

    public static CommonScreen create(CommonScreen parent, CursorType type, CursorConfig cursorConfig, Consumer<CursorConfig> saveCallback) {
        return CommonScreen.create(parent, TranslationCommonText.create("cursormod.gui.cursorList", new Object[0]), new GuiCursorConfig(type, cursorConfig, saveCallback));
    }

    private GuiCursorConfig(CursorType type, CursorConfig cursorConfig, Consumer<CursorConfig> callback) {
        this.type = type;
        this.cursorConfig = cursorConfig.copy();
        this.callback = callback;
    }

    private void updateCursorValues(CursorConfig cursorConfig) {
        this.cursorConfig = cursorConfig;
        this.xhotspot.setValue(String.valueOf(cursorConfig.getxHotSpot()));
        this.yhotspot.setValue(String.valueOf(cursorConfig.getyHotSpot()));
        this.cursorLocation.setValue(cursorConfig.getLink());
    }

    @Override
    public void render(CommonMatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        CommonScreen screen = this.getScreen();
        GuiUtils gutils = GuiUtils.get();
        screen.renderDefaultBackground(stack);
        screen.drawCenterString(stack, this.type.getName(), this.width / 2 - 74, this.height / 2 - 41 - 21, -26300, 2.0f);
        screen.drawRightString(stack, I18n.get("cursormod.config.xhotspot", new Object[0]) + " : ", this.xhotspot.getXPosition(), this.xhotspot.getYPosition() + this.xhotspot.getHeight() / 2 - gutils.fontHeight() / 2, -1);
        screen.drawRightString(stack, I18n.get("cursormod.config.yhotspot", new Object[0]) + " : ", this.yhotspot.getXPosition(), this.yhotspot.getYPosition() + this.yhotspot.getHeight() / 2 - gutils.fontHeight() / 2, -1);
        screen.drawRightString(stack, I18n.get("cursormod.config.location", new Object[0]) + " : ", this.cursorLocation.getXPosition(), this.cursorLocation.getYPosition() + this.cursorLocation.getHeight() / 2 - gutils.fontHeight() / 2, -1);
        if (this.syncImageSize()) {
            gutils.drawGradientRect(stack, screen.getBlitOffset(), this.width / 2 + 36, this.height / 2 - 64, this.width / 2 + 164, this.height / 2 + 64, -1072689136, -804253680);
            gutils.setShader(CommonShaders.get().getPositionTexShader());
            this.cursorConfig.getResourceLocation().setShaderTexture();
            gutils.drawScaledCustomSizeModalRect(this.width / 2 + 36, this.height / 2 - 64, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 128, 128, this.imageWidth, this.imageHeight * this.numImage, -1, true);
            if (this.cursorConfig.getxHotSpot() >= 0 && this.cursorConfig.getxHotSpot() < this.imageWidth && this.cursorConfig.getyHotSpot() >= 0 && this.cursorConfig.getyHotSpot() < this.imageHeight) {
                screen.drawCenterString(stack, "+", this.width / 2 + 36 + (int)((float)this.cursorConfig.getxHotSpot() * 128.0f / (float)this.imageWidth), this.height / 2 - 64 + (int)((float)this.cursorConfig.getyHotSpot() * 128.0f / (float)this.imageHeight) - gutils.fontHeight() / 2, -1);
            }
            if (this.numImage > 1) {
                screen.drawCenterString(stack, "(" + I18n.get("cursormod.gui.animate", new Object[0]) + ")", this.width / 2 + 100, this.height / 2 + 64 + 1, -1);
            }
            this.selectZone.setEnable(true);
        } else {
            screen.drawCenterString(stack, I18n.get("cursormod.gui.error", new Object[0]), this.width / 2 + 100, this.height / 2 - gutils.fontHeight() / 2, -48060);
            this.selectZone.setEnable(false);
        }
        super.render(stack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void init() {
        CommonScreen screen = this.getScreen();
        this.syncImageSize();
        this.xhotspot = screen.addChildren(CommonTextField.create("", this.width / 2 - 99, this.height / 2 - 41, 124, 18));
        this.yhotspot = screen.addChildren(CommonTextField.create("", this.width / 2 - 99, this.height / 2 - 20, 124, 18));
        this.cursorLocation = screen.addChildren(CommonTextField.create("", this.width / 2 - 99, this.height / 2 + 1, 124, 18));
        this.cursorLocation.setMaxLength(Integer.MAX_VALUE);
        this.updateCursorValues(this.cursorConfig);
        this.selectZone = SelectZone.create(this.width / 2 + 36, this.height / 2 - 64, 128, 128);
        screen.addChildren(this.selectZone);
        screen.addChildren(CommonButton.create(TranslationCommonText.create("cursormod.gui.default", new Object[0]), this.width / 2 - 174, this.height / 2 + 21, 200, 20, b -> this.updateCursorValues(this.type.getDefaultConfig())));
        this.doneButton = screen.addChildren(CommonButton.create(TranslationCommonText.create("gui.done", new Object[0]), this.width / 2 - 174, this.height / 2 + 42, 100, 20, b -> {
            this.saveConfig(this.cursorConfig);
            screen.getParent().displayScreen();
        }));
        screen.addChildren(CommonButton.create(TranslationCommonText.create("cursormod.gui.cancel", new Object[0]), this.width / 2 - 72, this.height / 2 + 42, 99, 20, b -> screen.getParent().displayScreen()));
        super.init();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseX >= (double)(this.width / 2 + 36) && mouseY >= (double)(this.height / 2 - 64) && mouseX <= (double)(this.width / 2 + 164) && mouseY <= (double)(this.height / 2 + 64)) {
            this.cursorConfig.setxHotSpot(MathHelper.clamp((int)((float)(mouseX - (double)(this.width / 2 + 36)) * (float)this.imageWidth / 128.0f), 0, this.imageWidth - 1));
            this.cursorConfig.setyHotSpot(MathHelper.clamp((int)((float)(mouseY - (double)(this.height / 2 - 64)) * (float)this.imageHeight / 128.0f), 0, this.imageWidth - 1));
            this.xhotspot.setValue(String.valueOf(this.cursorConfig.getxHotSpot()));
            this.yhotspot.setValue(String.valueOf(this.cursorConfig.getyHotSpot()));
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void saveConfig(CursorConfig cursorConfig) {
        if (this.callback != null) {
            this.callback.accept(cursorConfig);
        }
    }

    private boolean syncImageSize() {
        try {
            BufferedImage image = ImageIO.read(this.cursorConfig.getResource());
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getWidth();
            this.numImage = image.getHeight() / image.getWidth();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void tick() {
        this.verifyValue();
        super.tick();
    }

    private void verifyValue() {
        boolean canLeave = this.syncImageSize();
        try {
            this.cursorConfig.setxHotSpot(Integer.valueOf(this.xhotspot.getValue()));
            if (this.cursorConfig.getxHotSpot() >= 0 && this.cursorConfig.getxHotSpot() < this.imageWidth) {
                this.xhotspot.setTextColor(-1);
            } else {
                this.xhotspot.setTextColor(-48060);
                canLeave = false;
            }
        }
        catch (Exception e) {
            this.xhotspot.setTextColor(-48060);
            canLeave = false;
        }
        try {
            this.cursorConfig.setyHotSpot(Integer.valueOf(this.yhotspot.getValue()));
            if (this.cursorConfig.getyHotSpot() >= 0 && this.cursorConfig.getyHotSpot() < this.imageHeight) {
                this.yhotspot.setTextColor(-1);
            } else {
                this.yhotspot.setTextColor(-48060);
                canLeave = false;
            }
        }
        catch (Exception e) {
            this.yhotspot.setTextColor(-48060);
            canLeave = false;
        }
        this.cursorConfig.setLink(this.cursorLocation.getValue());
        this.doneButton.setEnable(canLeave);
    }
}

