/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.gui;

import fr.atesab.customcursormod.common.CursorMod;
import fr.atesab.customcursormod.common.config.CursorConfig;
import fr.atesab.customcursormod.common.cursor.CursorType;
import fr.atesab.customcursormod.common.gui.GuiCursorConfig;
import fr.atesab.customcursormod.common.handler.CommonButton;
import fr.atesab.customcursormod.common.handler.CommonButtonValue;
import fr.atesab.customcursormod.common.handler.CommonMatrixStack;
import fr.atesab.customcursormod.common.handler.CommonScreen;
import fr.atesab.customcursormod.common.handler.CommonShaders;
import fr.atesab.customcursormod.common.handler.GuiUtils;
import fr.atesab.customcursormod.common.handler.StringCommonText;
import fr.atesab.customcursormod.common.handler.TranslationCommonText;
import fr.atesab.customcursormod.common.utils.I18n;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class GuiConfigCursorMod
extends CommonScreen.ScreenListener {
    private Map<CursorType, CursorConfig> cursors;
    private List<CommonButtonValue<CursorType>> cursorButtons = new ArrayList<CommonButtonValue<CursorType>>();
    private CommonButton lastPage;
    private CommonButton nextPage;
    private int page = 0;
    private int elementByPage = 1;

    public static CommonScreen create(CommonScreen parent) {
        return CommonScreen.create(parent, TranslationCommonText.create("cursormod.gui.cursorList", new Object[0]), new GuiConfigCursorMod());
    }

    private GuiConfigCursorMod() {
        this.cursors = CursorMod.getInstance().getCursors();
    }

    private void defineButton() {
        if (this.lastPage != null) {
            this.lastPage.setEnable(this.page > 0);
        }
        if (this.nextPage != null) {
            this.nextPage.setEnable(this.page < this.cursors.size() / this.elementByPage);
        }
        for (int i = 0; i < this.cursorButtons.size(); ++i) {
            this.cursorButtons.get(i).setVisible(i < (this.page + 1) * this.elementByPage && i >= this.page * this.elementByPage);
        }
    }

    private void drawCursor(CommonMatrixStack stack, int posX, int posY, CursorConfig cursorConfig) {
        try {
            BufferedImage image = ImageIO.read(cursorConfig.getResource());
            int imageWidth = image.getWidth();
            int imageHeight = image.getWidth();
            int numImage = image.getHeight() / image.getWidth();
            GuiUtils gutils = GuiUtils.get();
            gutils.drawGradientRect(stack, this.getScreen().getBlitOffset(), posX, posY, posX + 20, posY + 20, -1072689136, -804253680);
            gutils.setShader(CommonShaders.get().getPositionTexShader());
            cursorConfig.getResourceLocation().setShaderTexture();
            gutils.drawScaledCustomSizeModalRect(posX, posY, 0.0f, 0.0f, imageWidth, imageHeight, 20, 20, imageWidth, imageHeight * numImage, -1, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void render(CommonMatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        CommonScreen screen = this.getScreen();
        screen.renderDefaultBackground(stack);
        screen.drawCenterString(stack, I18n.get("cursormod.gui.cursorList", new Object[0]), this.width / 2, this.height / 2 - ((this.elementByPage / 2 + 1) * 21 + 2 + GuiUtils.get().fontHeight()), -26300);
        for (int i = this.page * this.elementByPage; i < this.cursorButtons.size() && i < (this.page + 1) * this.elementByPage; ++i) {
            CommonButtonValue<CursorType> button = this.cursorButtons.get(i);
            this.drawCursor(stack, button.getXPosition() + button.getWidth() + 1, button.getYPosition(), this.cursors.get(button.getValue()));
        }
        super.render(stack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void init() {
        CommonScreen screen = this.getScreen();
        this.page = 0;
        this.elementByPage = (this.height - 63) / 21;
        if (this.elementByPage > 10) {
            this.elementByPage = 10;
        }
        screen.addChildren(CommonButton.create(TranslationCommonText.create("gui.done", new Object[0]), this.width / 2 - 79, this.height / 2 + this.elementByPage / 2 * 21, 158, 20, b -> screen.getParent().displayScreen()));
        if (this.elementByPage <= this.cursors.size()) {
            this.lastPage = screen.addChildren(CommonButton.create(StringCommonText.create("<"), this.width / 2 - 100, this.height / 2 + this.elementByPage / 2 * 21, 20, 20, b -> {
                --this.page;
                this.defineButton();
            }));
            this.nextPage = screen.addChildren(CommonButton.create(StringCommonText.create(">"), this.width / 2 + 80, this.height / 2 + this.elementByPage / 2 * 21, 20, 20, b -> {
                ++this.page;
                this.defineButton();
            }));
        } else {
            this.nextPage = null;
            this.lastPage = null;
        }
        int i = -1;
        this.cursorButtons.clear();
        for (Map.Entry<CursorType, CursorConfig> entry : this.cursors.entrySet()) {
            CursorType type = entry.getKey();
            CursorConfig cfg = entry.getValue();
            this.cursorButtons.add(CommonButtonValue.create(type, type.getTranslation(), this.width / 2 - 100, this.height / 2 + (i++ % this.elementByPage - this.elementByPage / 2) * 21, 200, 20, b -> GuiCursorConfig.create(screen, type, cfg, cursorConfig -> CursorMod.getInstance().replaceCursor(type, (CursorConfig)cursorConfig)).displayScreen()));
        }
        screen.childrens.addAll(this.cursorButtons);
        this.defineButton();
        super.init();
    }
}

