/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.integration.permissions;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.integration.permissions.FallbackPermissionProvider;
import dev.ftb.mods.ftblibrary.integration.permissions.PermissionProvider;
import java.util.Objects;

public enum PermissionHelper {
    INSTANCE;

    private static final PermissionProvider FALLBACK_PROVIDER;
    private PermissionProvider activeImpl = null;

    public static PermissionHelper getInstance() {
        return INSTANCE;
    }

    public void setProviderImpl(PermissionProvider newProvider) {
        if (this.activeImpl != null) {
            FTBLibrary.LOGGER.warn("Overriding existing permissions provider: {} -> {}", (Object)this.activeImpl.getName(), (Object)newProvider.getName());
        } else {
            FTBLibrary.LOGGER.info("Setting permissions provider implementation to: {}", (Object)newProvider.getName());
        }
        this.activeImpl = newProvider;
    }

    public PermissionProvider getProvider() {
        return Objects.requireNonNullElse(this.activeImpl, FALLBACK_PROVIDER);
    }

    static {
        FALLBACK_PROVIDER = new FallbackPermissionProvider();
    }
}

