/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.compat.jade.provider;

import java.util.ArrayList;
import java.util.List;
import lekavar.lma.drinkbeer.blockentities.TradeBoxBlockEntity;
import lekavar.lma.drinkbeer.compat.jade.provider.JadeHelper;
import lekavar.lma.drinkbeer.utils.Convert;
import lekavar.lma.drinkbeer.utils.ItemStackHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ProgressArrowElement;

public class TradeBoxComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockEntity> {
    public static TradeBoxComponentProvider INSTANCE = new TradeBoxComponentProvider();
    public static final String KEY_COOLING_TIME = "coolingTime";
    public static final String KEY_GOODS_FROM = "goodsFrom";
    public static final String KEY_GOODS_TO = "goodsTo";
    public static final int MaxGoodCount = 4;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        IElementHelper helper = tooltip.getElementHelper();
        CompoundTag data = accessor.getServerData();
        int coolingTime = data.m_128451_(KEY_COOLING_TIME);
        if (coolingTime == 0 && tooltip.size() > 0) {
            int goodsFromNum = data.m_128451_(KEY_GOODS_FROM);
            int goodsToNum = data.m_128451_(KEY_GOODS_TO);
            if (goodsFromNum == 0) {
                return;
            }
            List<IElement> itemElements = this.getInventoryTooltip(tooltip, accessor);
            if (itemElements == null) {
                return;
            }
            IElement[][] inputs = JadeHelper.layoutItems(itemElements, goodsFromNum);
            IElement[][] outputs = JadeHelper.layoutItems(itemElements, goodsToNum);
            int ih = inputs.length;
            int oh = outputs.length;
            int maxRow = Math.max(ih, oh);
            List<List<IElement>> grids = JadeHelper.createRows(maxRow);
            JadeHelper.placeItems(grids, inputs, true);
            JadeHelper.placeArrow(grids);
            JadeHelper.placeItems(grids, outputs, false);
            JadeHelper.addGridsToTooltip(tooltip, grids);
        } else {
            int maxCoolingTime = coolingTime > 4800 ? 6000 : 4800;
            tooltip.add(List.of(new ProgressArrowElement(1.0f - (float)coolingTime / (float)maxCoolingTime), helper.text((Component)Component.m_237113_((String)Convert.tickToTime(coolingTime)))));
        }
    }

    private List<IElement> getInventoryTooltip(ITooltip tooltip, BlockAccessor accessor) {
        ArrayList<IElement> itemElements = null;
        if (accessor.getServerData().m_128441_("jadeHandler")) {
            ItemStack stack;
            ItemStackHandler itemHandler = new ItemStackHandler();
            itemHandler.deserializeNBT(accessor.getServerData().m_128469_("jadeHandler"));
            IElementHelper helper = tooltip.getElementHelper();
            itemElements = new ArrayList<IElement>();
            for (int i = 0; i < itemHandler.getSlots() && !(stack = itemHandler.getStackInSlot(i)).m_41619_(); ++i) {
                itemElements.add(helper.item(stack));
            }
        }
        if (itemElements != null) {
            tooltip.remove(Identifiers.UNIVERSAL_ITEM_STORAGE);
        }
        return itemElements;
    }

    private int getGoodCount(TradeBoxBlockEntity be, int start, int size) {
        int count = 0;
        block0: for (int i = 0; i < size && !be.m_8020_(start + i).m_41619_(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (ItemStackHelper.isSameItem(be.m_8020_(start + i), be.m_8020_(start + j))) continue block0;
            }
            ++count;
        }
        return count;
    }

    public void appendServerData(CompoundTag data, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
        TradeBoxBlockEntity be = (TradeBoxBlockEntity)blockEntity;
        data.m_128405_(KEY_COOLING_TIME, be.syncData.m_6413_(0));
        if (be.syncData.m_6413_(3) == 1) {
            int goodsFromLocNum = this.getGoodCount(be, 0, 4);
            int goodsToLocNum = this.getGoodCount(be, 4, 4);
            data.m_128405_(KEY_GOODS_FROM, goodsFromLocNum);
            data.m_128405_(KEY_GOODS_TO, goodsToLocNum);
        }
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("drinkbeer", "trade_box");
    }
}

