/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.compat.jade.provider;

import java.util.List;
import lekavar.lma.drinkbeer.blockentities.MixedBeerBlockEntity;
import lekavar.lma.drinkbeer.blocks.MixedBeerBlock;
import lekavar.lma.drinkbeer.compat.jade.provider.JadeHelper;
import lekavar.lma.drinkbeer.items.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.managers.MixedBeerManager;
import lekavar.lma.drinkbeer.managers.SpiceAndFlavorManager;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.impl.ui.TextElement;

public class MixedBeerComponentProvider
implements IBlockComponentProvider {
    public static MixedBeerComponentProvider INSTANCE = new MixedBeerComponentProvider();
    public static final float TEXT_HEIGHT = new TextElement((Component)Component.m_130674_((String)"")).getSize().f_82471_;

    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof MixedBeerBlockEntity) {
            MixedBeerBlockEntity mixedBeer = (MixedBeerBlockEntity)blockEntity;
            return ItemStackElement.of((ItemStack)Beers.byId(mixedBeer.getBeerId()).getBeerItem().m_7968_());
        }
        return super.getIcon(accessor, config, currentIcon);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (!(accessor.getBlock() instanceof MixedBeerBlock) || !((blockEntity2 = accessor.getBlockEntity()) instanceof MixedBeerBlockEntity)) {
            return;
        }
        MixedBeerBlockEntity mxBeer = (MixedBeerBlockEntity)blockEntity2;
        MixedBeerBlockItem MIXED_BEER = (MixedBeerBlockItem)((Object)ItemRegistry.MIXED_BEER.get());
        Component name = MIXED_BEER.getMixedBeerName(mxBeer.getPickStack());
        if (name != null) {
            IWailaConfig wailaConfig = config.getWailaConfig();
            tooltip.clear();
            tooltip.add((Component)name.m_6881_().m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)));
        }
        if (!(accessor.getBlock() instanceof MixedBeerBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof MixedBeerBlockEntity)) {
            return;
        }
        MixedBeerBlockEntity mixedBeer = (MixedBeerBlockEntity)blockEntity;
        IElementHelper helper = tooltip.getElementHelper();
        ItemStack stack = mixedBeer.getPickStack();
        List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
        if (!spiceList.isEmpty()) {
            for (int spiceId : spiceList) {
                Spices spice = Spices.byId(spiceId);
                Item spiceItem = spice.getSpiceItem();
                Flavors flavor = spice.getFlavor();
                tooltip.add(List.of(JadeHelper.translateDelta(JadeHelper.createCenteredItem(helper, spiceItem.m_7968_(), 0.8f, TEXT_HEIGHT), 0.0f, -2.0f), helper.text((Component)Component.m_237115_((String)SpiceAndFlavorManager.getFlavorTranslationKey(flavor.getId())).m_130940_(ChatFormatting.RED))));
            }
            Flavors combinedFlavor = SpiceAndFlavorManager.getCombinedFlavor(spiceList);
            if (combinedFlavor != null) {
                tooltip.add((Component)Component.m_237113_((String)"").m_130946_("\"").m_7220_((Component)Component.m_237115_((String)SpiceAndFlavorManager.getFlavorTranslationKey(combinedFlavor.getId()))).m_130946_("\"").m_130940_(ChatFormatting.DARK_RED));
            }
        }
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("drinkbeer", "mixed_beer");
    }
}

