/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.compat.jade.provider;

import java.util.ArrayList;
import java.util.List;
import lekavar.lma.drinkbeer.blockentities.BeerBarrelBlockEntity;
import lekavar.lma.drinkbeer.blocks.BeerBarrelBlock;
import lekavar.lma.drinkbeer.compat.jade.provider.JadeHelper;
import lekavar.lma.drinkbeer.recipes.BrewingRecipe;
import lekavar.lma.drinkbeer.registries.RecipeRegistry;
import lekavar.lma.drinkbeer.utils.Convert;
import lekavar.lma.drinkbeer.utils.ItemStackHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class BeerBarrelComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockEntity> {
    public static BeerBarrelComponentProvider INSTANCE = new BeerBarrelComponentProvider();
    public static final String KEY_TIME_REMAINING = "timeRemaining";

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        BlockEntity blockEntity;
        if (!(accessor.getBlock() instanceof BeerBarrelBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof BeerBarrelBlockEntity)) {
            return;
        }
        BeerBarrelBlockEntity barrel = (BeerBarrelBlockEntity)blockEntity;
        ItemStack output = barrel.getBrewingInventory().m_8020_(5).m_41777_();
        int timeRemaining = accessor.getServerData().m_128451_(KEY_TIME_REMAINING);
        if (!output.m_41619_()) {
            Level level = accessor.getLevel();
            List recipes = level.m_7465_().m_44013_((RecipeType)RecipeRegistry.RECIPE_TYPE_BREWING.get());
            BrewingRecipe recipe = null;
            for (BrewingRecipe candidate : recipes) {
                if (!ItemStackHelper.isSameItem(output, candidate.m_8043_()) || timeRemaining >= candidate.getBrewingTime()) continue;
                recipe = candidate;
                break;
            }
            if (recipe == null) {
                return;
            }
            IElementHelper helper = tooltip.getElementHelper();
            ArrayList<IElement> elements = new ArrayList<IElement>(5);
            NonNullList<Ingredient> ingredients = recipe.m_7527_();
            for (Ingredient ingredient : ingredients) {
                elements.add(helper.item(ingredient.m_43908_()[0]));
            }
            IElement[][] inputs = JadeHelper.layoutItems(elements, ingredients.size());
            List<List<IElement>> grids = JadeHelper.createRows(inputs.length);
            JadeHelper.placeItems(grids, inputs, true);
            JadeHelper.placeArrowProgress(grids, 1.0f - (float)timeRemaining / (float)recipe.getBrewingTime());
            JadeHelper.placeScaledItem(helper, grids, output, 0.8f).translateDelta(-6.0f, 0.0f);
            if (timeRemaining > 0) {
                int inputGridsWidth = inputs[0].length;
                IElement sample = JadeHelper.createSpacerItem();
                tooltip.add(List.of(helper.text((Component)Component.m_237113_((String)Convert.tickToTime(timeRemaining))).size(new Vec2(0.0f, 0.0f)).translate(new Vec2(sample.getSize().f_82470_ * (float)inputGridsWidth, 0.0f))));
            }
            JadeHelper.addGridsToTooltip(tooltip, grids);
            tooltip.add(List.of(helper.text(output.m_41786_()).align(IElement.Align.RIGHT)));
        }
    }

    public void appendServerData(CompoundTag data, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
        BeerBarrelBlockEntity be = (BeerBarrelBlockEntity)blockEntity;
        data.m_128405_(KEY_TIME_REMAINING, be.syncData.m_6413_(0));
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("drinkbeer", "beer_barrel");
    }
}

