/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import lekavar.lma.drinkbeer.blockentities.MixedBeerBlockEntity;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;

public class MixedBeerBlockEntityRenderer
implements BlockEntityRenderer<MixedBeerBlockEntity> {
    public MixedBeerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MixedBeerBlockEntity blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.m_85836_();
        int beerId = blockEntity.getBeerId();
        ItemStack beerStack = this.getBeerStack(beerId);
        BlockPos pos = blockEntity.m_58899_();
        matrices.m_85837_(0.5, 0.25, 0.5);
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(this.getRandomAngleByPos(pos)));
        int lightAbove = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_7494_());
        Minecraft.m_91087_().m_91291_().m_174269_(beerStack, ItemTransforms.TransformType.GROUND, lightAbove, overlay, matrices, vertexConsumers, 0);
        matrices.m_85849_();
    }

    private ItemStack getBeerStack(int beerId) {
        ItemStack itemStack;
        if (beerId > 0) {
            Beers beer = Beers.byId(beerId);
            Item item = beer.getBeerItem();
            itemStack = new ItemStack((ItemLike)item, 1);
        } else {
            itemStack = new ItemStack((ItemLike)((Item)ItemRegistry.MIXED_BEER.get()).m_5456_(), 1);
        }
        return itemStack;
    }

    private float getRandomAngleByPos(BlockPos pos) {
        float angle = 0.0f;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int sum = Math.abs(x) + Math.abs(z) + Math.abs(y);
        angle = 360.0f * ((float)sum % 8.0f / 8.0f);
        return angle;
    }
}

