/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blockentities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.gui.BeerBarrelMenu;
import lekavar.lma.drinkbeer.recipes.BrewingRecipe;
import lekavar.lma.drinkbeer.recipes.IBrewingInventory;
import lekavar.lma.drinkbeer.registries.BlockEntityRegistry;
import lekavar.lma.drinkbeer.registries.RecipeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class BeerBarrelBlockEntity
extends BlockEntity
implements MenuProvider {
    private final BrewingInventory brewingInventory = new BrewingInventory(this);
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> new BarrelInvWrapper(this));
    private int remainingBrewTime;
    private int statusCode;
    public final ContainerData syncData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> BeerBarrelBlockEntity.this.remainingBrewTime;
                case 1 -> BeerBarrelBlockEntity.this.statusCode;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BeerBarrelBlockEntity.this.remainingBrewTime = value;
                    break;
                }
                case 1: {
                    BeerBarrelBlockEntity.this.statusCode = value;
                }
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public BeerBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.BEER_BARREL_TILEENTITY.get(), pos, state);
    }

    public void tickServer() {
        if (this.statusCode == 0) {
            if (this.brewingInventory.getIngredients().size() == 4) {
                BrewingRecipe recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipeRegistry.RECIPE_TYPE_BREWING.get(), (Container)this.brewingInventory, this.f_58857_).orElse(null);
                if (this.canBrew(recipe)) {
                    this.setResult(recipe);
                    if (this.hasEnoughEmptyCap(recipe)) {
                        this.startBrewing(recipe);
                    }
                } else {
                    this.clearResult();
                }
            } else {
                this.clearResult();
            }
        } else if (this.statusCode == 1) {
            if (this.remainingBrewTime > 0) {
                --this.remainingBrewTime;
            } else {
                this.remainingBrewTime = 0;
                this.statusCode = 2;
            }
            this.m_6596_();
        } else if (this.statusCode == 2) {
            if (this.brewingInventory.m_8020_(5).m_41619_()) {
                this.statusCode = 0;
                this.m_6596_();
            }
        } else {
            this.remainingBrewTime = 0;
            this.statusCode = 0;
            this.m_6596_();
        }
    }

    private boolean canBrew(@Nullable BrewingRecipe recipe) {
        if (recipe != null) {
            return recipe.matches(this.brewingInventory, this.f_58857_);
        }
        return false;
    }

    private boolean hasEnoughEmptyCap(BrewingRecipe recipe) {
        return recipe.isCupQualified(this.brewingInventory);
    }

    private void startBrewing(BrewingRecipe recipe) {
        for (int i = 0; i < 4; ++i) {
            ItemStack ingred = this.brewingInventory.m_8020_(i);
            if (this.shouldReturnBucket(ingred)) {
                this.brewingInventory.m_6836_(i, Items.f_42446_.m_7968_());
                continue;
            }
            ingred.m_41774_(1);
        }
        this.brewingInventory.m_8020_(4).m_41774_(recipe.getRequiredCupCount());
        this.remainingBrewTime = recipe.getBrewingTime();
        this.statusCode = 1;
        this.markDirty();
    }

    private boolean shouldReturnBucket(ItemStack item) {
        return item.m_41720_() instanceof BucketItem || item.m_41720_() instanceof MilkBucketItem;
    }

    private void clearResult() {
        if (!this.brewingInventory.m_8020_(5).m_41619_()) {
            this.brewingInventory.m_6836_(5, ItemStack.f_41583_);
            this.remainingBrewTime = 0;
            this.markDirty();
        }
    }

    private void setResult(BrewingRecipe recipe) {
        ItemStack result = recipe.assemble(this.brewingInventory);
        if (!ItemStack.m_41728_((ItemStack)result, (ItemStack)this.brewingInventory.m_8020_(5))) {
            this.brewingInventory.m_6836_(5, recipe.assemble(this.brewingInventory));
            this.remainingBrewTime = recipe.getBrewingTime();
            this.markDirty();
        }
    }

    public BrewingInventory getBrewingInventory() {
        return this.brewingInventory;
    }

    public void markDirty() {
        BlockPos pos = this.m_58899_();
        BlockState bs = this.f_58857_.m_8055_(pos);
        this.f_58857_.m_7260_(pos, bs, bs, 2);
        this.m_6596_();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inv", (Tag)this.brewingInventory.m_7927_());
        tag.m_128376_("RemainingBrewTime", (short)this.remainingBrewTime);
        tag.m_128376_("statusCode", (short)this.statusCode);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.remainingBrewTime = tag.m_128448_("RemainingBrewTime");
        this.statusCode = tag.m_128448_("statusCode");
        if (tag.m_128441_("inv")) {
            this.brewingInventory.m_7797_((ListTag)tag.m_128423_("inv"));
        } else {
            NonNullList items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)items);
            for (int i = 0; i < 6; ++i) {
                this.brewingInventory.m_6836_(i, (ItemStack)items.get(i));
            }
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.drinkbeer.beer_barrel");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new BeerBarrelMenu(id, this.brewingInventory, this.syncData, inventory, this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("inv", (Tag)this.brewingInventory.m_7927_());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.brewingInventory.m_7797_((ListTag)tag.m_128423_("inv"));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (side == null || side == Direction.DOWN)) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static class BrewingInventory
    extends SimpleContainer
    implements IBrewingInventory {
        BeerBarrelBlockEntity be;

        public BrewingInventory(BeerBarrelBlockEntity be) {
            super(6);
            this.be = be;
        }

        @Override
        @NotNull
        public List<ItemStack> getIngredients() {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            if (this.m_7983_()) {
                return ret;
            }
            for (int i = 0; i < 4; ++i) {
                if (this.m_8020_(i).m_41619_()) continue;
                ret.add(this.m_8020_(i));
            }
            return ret;
        }

        @Override
        @NotNull
        public ItemStack getCup() {
            return this.m_8020_(4);
        }

        public boolean m_7013_(int pIndex, ItemStack pStack) {
            return super.m_7013_(pIndex, pStack);
        }

        public boolean m_6542_(Player pPlayer) {
            if (this.be.f_58857_.m_7702_(this.be.f_58858_) != this.be) {
                return false;
            }
            return !(pPlayer.m_20275_((double)this.be.f_58858_.m_123341_() + 0.5, (double)this.be.f_58858_.m_123342_() + 0.5, (double)this.be.f_58858_.m_123343_() + 0.5) > 64.0);
        }

        public void m_7797_(ListTag pContainerNbt) {
            for (int i = 0; i < 6; ++i) {
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)pContainerNbt.m_128728_(i));
                if (itemstack.m_41619_()) continue;
                this.m_6836_(i, itemstack);
            }
        }

        public ListTag m_7927_() {
            ListTag listtag = new ListTag();
            for (int i = 0; i < 6; ++i) {
                listtag.add((Object)this.m_8020_(i).m_41739_(new CompoundTag()));
            }
            return listtag;
        }
    }

    static class BarrelInvWrapper
    implements IItemHandlerModifiable {
        private BrewingInventory brewingInventory;
        private BeerBarrelBlockEntity be;

        public BarrelInvWrapper(BeerBarrelBlockEntity be) {
            this.brewingInventory = be.brewingInventory;
            this.be = be;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.brewingInventory.m_6836_(5, stack);
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (this.be.statusCode != 2) {
                return ItemStack.f_41583_;
            }
            return this.brewingInventory.m_8020_(5);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.be.statusCode != 2) {
                return ItemStack.f_41583_;
            }
            ItemStack ret = this.brewingInventory.m_8020_(5).m_41777_();
            amount = Math.min(ret.m_41613_(), amount);
            ret.m_41764_(amount);
            if (!simulate) {
                this.brewingInventory.m_8020_(5).m_41774_(amount);
            }
            return ret;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

