/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.core.registrate;

import com.google.common.collect.Lists;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.BlockHelper;
import xyz.apex.forge.apexcore.lib.block.IMultiBlock;
import xyz.apex.forge.apexcore.lib.block.ISeatBlock;
import xyz.apex.forge.apexcore.registrate.BasicRegistrate;
import xyz.apex.forge.apexcore.registrate.builder.BlockBuilder;
import xyz.apex.forge.commonality.tags.BlockTags;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.common.block.decorations.CandleBlock;
import xyz.apex.forge.fantasyfurniture.common.block.decorations.CookieJarBlock;
import xyz.apex.forge.fantasyfurniture.common.block.decorations.StackedBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.BedBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.CounterBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.DyeableBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.DyeableCarpetBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.FloorLightBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.FurnitureDoorBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.OvenBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.OvenMultiBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.ShelfBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.SofaBlock;

public interface BlockTransformers {
    public static Property<?>[] getIgnoredProperties(Block block, String blockName) {
        ArrayList list = Lists.newArrayList();
        if (block instanceof IDyeable) {
            list.add(IDyeable.BLOCKSTATE_PROPERTY);
        }
        if (block instanceof BedBlock) {
            list.add(BedBlock.OCCUPIED);
        }
        if (block instanceof FloorLightBlock) {
            list.add(FloorLightBlock.PART);
        }
        if (block instanceof SimpleWaterloggedBlock) {
            list.add(BlockStateProperties.f_61362_);
        }
        if (!blockName.equals("dunmer/bed_single") && !blockName.equals("dunmer/bed_double") && block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            list.add(multiBlock.getMultiBlockPattern().getBlockProperty());
        }
        if (block instanceof ISeatBlock) {
            list.add(ISeatBlock.OCCUPIED);
        }
        if (block instanceof FurnitureDoorBlock) {
            list.addAll(Arrays.asList(FurnitureDoorBlock.f_52729_, FurnitureDoorBlock.f_52730_));
        }
        if ((block instanceof CandleBlock || block instanceof OvenBlock || block instanceof OvenMultiBlock) && !AllBlocks.DUNMER_OVEN.is(block)) {
            list.add(CandleBlock.LIT);
        }
        return (Property[])list.toArray(Property[]::new);
    }

    public static <BLOCK extends FurnitureDoorBlock> BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> applyDoorProperties(BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> builder) {
        return builder.blockState((ctx, provider) -> provider.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(blockState -> {
            BlockModelBuilder model = BlockTransformers.getModelFile(ctx, blockState, provider.models());
            boolean rightHinge = blockState.m_61145_((Property)DoorBlock.f_52728_).orElse(DoorHingeSide.LEFT) == DoorHingeSide.RIGHT;
            int yRot = (int)BaseBlock.getFacing((BlockState)blockState).m_122435_();
            Boolean open = blockState.m_61145_((Property)DoorBlock.f_52727_).orElse(false);
            if (open.booleanValue()) {
                yRot += 90;
            }
            if (rightHinge && open.booleanValue()) {
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(yRot %= 360).build();
        }, BlockTransformers.getIgnoredProperties((Block)ctx.get(), ctx.getId().m_135815_()))).tag(new TagKey[]{BlockTags.Vanilla.WOODEN_DOORS});
    }

    public static <BLOCK extends Block> BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> applyBlockDefaults(BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> builder) {
        return (BlockBuilder)builder.lang(RegistrateLangProvider.toEnglishName((String)builder.getName().replace('/', '_'))).loot(BlockTransformers::lootTable).transform(BlockTransformers::mineableAxe);
    }

    public static <BLOCK extends Block> BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> applyFurnitureBlockDefaults(BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> builder) {
        return ((BlockBuilder)builder.transform(BlockTransformers::applyBlockDefaults)).noOcclusion().isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never);
    }

    public static ToIntFunction<BlockState> lightLevel() {
        return BlockTransformers.lightLevel(blockState -> true);
    }

    public static ToIntFunction<BlockState> lightLevel(Predicate<BlockState> lightLevelPredicate) {
        return blockState -> lightLevelPredicate.test((BlockState)blockState) && !BaseBlock.isWaterLogged((BlockState)blockState) ? 14 : 0;
    }

    public static <BLOCK extends Block> void simpleBlockState(DataGenContext<Block, BLOCK> ctx, RegistrateBlockstateProvider provider, Function<BlockState, ModelFile> modelGetter) {
        provider.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(blockState -> ConfiguredModel.builder().modelFile((ModelFile)modelGetter.apply((BlockState)blockState)).build(), BlockTransformers.getIgnoredProperties((Block)ctx.get(), ctx.getId().m_135815_()));
    }

    public static <BLOCK extends Block> void horizontalBlockState(DataGenContext<Block, BLOCK> ctx, RegistrateBlockstateProvider provider) {
        provider.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(blockState -> ConfiguredModel.builder().rotationY(((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).modelFile((ModelFile)BlockTransformers.getModelFile(ctx, blockState, provider.models())).build(), BlockTransformers.getIgnoredProperties((Block)ctx.get(), ctx.getId().m_135815_()));
    }

    public static <BLOCK extends Block> BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> applyDyeable(BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> builder) {
        return builder.color(() -> () -> (blockState, level, pos, tintIndex) -> tintIndex == (blockState.m_60734_() instanceof DyeableBlock || blockState.m_60734_() instanceof DyeableCarpetBlock ? 0 : 1) ? IDyeable.getDyeColor(blockState).map(IDyeable::tintFromDyeColor).orElse(-1) : -1);
    }

    public static <BLOCK extends Block> BlockModelBuilder getModelFile(DataGenContext<Block, BLOCK> ctx, BlockState blockState, BlockModelProvider provider) {
        String suffix = "";
        Object object = ctx.get();
        if (object instanceof StackedBlock) {
            StackedBlock block = (StackedBlock)((Object)object);
            suffix = "_%d".formatted(blockState.m_61143_((Property)block.getStackSizeProperty()));
        } else if (ctx.get() instanceof ShelfBlock) {
            suffix = "_%s".formatted(((ShelfBlock.Connection)((Object)blockState.m_61143_(ShelfBlock.CONNECTION))).m_7912_());
        } else if (ctx.get() instanceof SofaBlock) {
            suffix = "_%s".formatted(((SofaBlock.Connection)((Object)blockState.m_61143_(SofaBlock.CONNECTION))).m_7912_());
        } else if (ctx.get() instanceof CounterBlock) {
            suffix = "_%s".formatted(((CounterBlock.Connection)((Object)blockState.m_61143_(CounterBlock.CONNECTION))).m_7912_());
        } else if (AllBlocks.DUNMER_BED_DOUBLE.is((Block)ctx.get()) || AllBlocks.DUNMER_BED_SINGLE.is((Block)ctx.get())) {
            suffix = ((IMultiBlock)ctx.get()).isMultiBlockOrigin(blockState) ? "_head" : "_foot";
        } else if (ctx.get() instanceof FurnitureDoorBlock) {
            DoorHingeSide hinge = (DoorHingeSide)blockState.m_61143_((Property)FurnitureDoorBlock.f_52728_);
            Boolean open = (Boolean)blockState.m_61143_((Property)FurnitureDoorBlock.f_52727_);
            suffix = open.booleanValue() ? (hinge == DoorHingeSide.RIGHT ? "_left" : "_right") : (hinge == DoorHingeSide.RIGHT ? "_right" : "_left");
        } else if (AllBlocks.DUNMER_OVEN.is((Block)ctx.get()) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            suffix = "_lit";
        } else if (ctx.get() instanceof CookieJarBlock) {
            suffix = "_%s".formatted(((CookieJarBlock.FillStage)((Object)blockState.m_61143_(CookieJarBlock.FILL_STAGE))).serializedName);
        }
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.withExistingParent("%s:generated/block/%s%s".formatted(ctx.getId().m_135827_(), ctx.getId().m_135815_(), suffix), new ResourceLocation(ctx.getId().m_135827_(), "block/%s%s".formatted(ctx.getId().m_135815_(), suffix)))).renderType(new ResourceLocation("minecraft", "cutout"))).texture("particle", BlockTransformers.getParticlePath(ctx.getId()))).texture(BlockTransformers.getTextureKey(ctx.getId()), BlockTransformers.getTexturePath(ctx.getId()));
    }

    public static ResourceLocation getParticlePath(ResourceLocation registryName) {
        String path = registryName.m_135815_();
        String type = path.substring(0, path.indexOf(47));
        if (type.equals("decorations")) {
            String name = path.substring(type.length() + 1);
            if (name.startsWith("berry_basket")) {
                name = "berry_basket";
            } else if (name.startsWith("bowl")) {
                name = "bowl";
            } else if (name.startsWith("tankards")) {
                name = "tankards";
            } else if (name.startsWith("venthyr")) {
                name = "venthyr";
            } else {
                if (name.startsWith("dunmer")) {
                    return new ResourceLocation(registryName.m_135827_(), "particles/dunmer");
                }
                if (name.startsWith("bone")) {
                    if (name.contains("wither")) {
                        return new ResourceLocation(registryName.m_135827_(), "particles/bone_wither");
                    }
                    return new ResourceLocation(registryName.m_135827_(), "particles/bone");
                }
                if (name.startsWith("royal")) {
                    return new ResourceLocation(registryName.m_135827_(), "particles/royal");
                }
                if (name.startsWith("necrolord")) {
                    return new ResourceLocation(registryName.m_135827_(), "particles/necrolord");
                }
                if (name.startsWith("spider_web")) {
                    return new ResourceLocation(registryName.m_135827_(), "particles/decorations/spider_webs");
                }
                if (name.startsWith("potion_bottles")) {
                    return new ResourceLocation(registryName.m_135827_(), "particles/decorations/potion_bottles");
                }
                if (name.startsWith("fairy_lights")) {
                    return new ResourceLocation(registryName.m_135827_(), "particles/decorations/fairy_lights_1");
                }
            }
            return new ResourceLocation(registryName.m_135827_(), "particles/%s/%s".formatted(type, name));
        }
        if (type.equals("bone")) {
            String subType = path.substring(type.length() + 1);
            if (subType.contains("wither")) {
                return new ResourceLocation(registryName.m_135827_(), "particles/bone_wither");
            }
            return new ResourceLocation(registryName.m_135827_(), "particles/bone");
        }
        return new ResourceLocation(registryName.m_135827_(), "particles/%s".formatted(type));
    }

    public static <BLOCK extends Block> void lootTable(RegistrateBlockLootTables lootTables, BLOCK block) {
        AtomicReference<LootPoolSingletonContainer.Builder> item = new AtomicReference<LootPoolSingletonContainer.Builder>(LootItem.m_79579_(block));
        AtomicReference<LootPool.Builder> pool = new AtomicReference<LootPool.Builder>(((LootPool.Builder)RegistrateBlockLootTables.m_236224_(block, (ConditionUserBuilder)LootPool.m_79043_())).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)));
        if (block instanceof StackedBlock) {
            StackedBlock stacked = (StackedBlock)block;
            for (Integer value : stacked.getStackSizeProperty().m_6908_()) {
                pool.getAndUpdate(builder -> builder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)(value + 1))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)stacked.getStackSizeProperty(), value.intValue())))));
            }
        }
        if (block instanceof FurnitureDoorBlock) {
            item.getAndUpdate(builder -> builder.m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)FurnitureDoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER))));
        }
        if (block instanceof IDyeable) {
            pool.getAndUpdate(builder -> builder.m_79078_((LootItemFunction.Builder)CopyBlockState.m_80062_((Block)block).m_80084_(IDyeable.BLOCKSTATE_PROPERTY)));
        }
        lootTables.m_124165_(block, LootTable.m_79147_().m_79161_(pool.get().m_79076_((LootPoolEntryContainer.Builder)item.get())));
    }

    public static String getTextureKey(ResourceLocation registryName) {
        String path = registryName.m_135815_();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static ResourceLocation getTexturePath(ResourceLocation registryName) {
        String name;
        String path = registryName.m_135815_();
        String type = path.substring(0, path.lastIndexOf(47));
        name = switch (name = path.substring(type.length() + 1)) {
            case "desk_left", "desk_right" -> "desk";
            case "wardrobe_bottom", "wardrobe_top" -> "wardrobe";
            default -> name;
        };
        return new ResourceLocation(registryName.m_135827_(), "models/%s/%s".formatted(type, name));
    }

    public static <BLOCK extends Block> BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> clearMineable(BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> builder) {
        return builder.removeTag(new TagKey[]{BlockTags.Vanilla.MINEABLE_WITH_PICKAXE, BlockTags.Vanilla.MINEABLE_WITH_AXE, BlockTags.Vanilla.MINEABLE_WITH_SHOVEL, BlockTags.Vanilla.MINEABLE_WITH_HOE});
    }

    public static <BLOCK extends Block> BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> mineablePickaxe(BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> builder) {
        return ((BlockBuilder)builder.transform(BlockTransformers::clearMineable)).tag(new TagKey[]{BlockTags.Vanilla.MINEABLE_WITH_PICKAXE});
    }

    public static <BLOCK extends Block> BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> mineableAxe(BlockBuilder<BasicRegistrate, BLOCK, BasicRegistrate> builder) {
        return ((BlockBuilder)builder.transform(BlockTransformers::clearMineable)).tag(new TagKey[]{BlockTags.Vanilla.MINEABLE_WITH_AXE});
    }
}

