/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.IMultiBlock;
import xyz.apex.forge.commonality.tags.ItemTags;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.FurnitureDoorBlock;

public interface IDyeable {
    public static final String NBT_KEY = "DyeColor";
    public static final EnumProperty<DyeColor> BLOCKSTATE_PROPERTY = EnumProperty.m_61587_((String)"dye_color", DyeColor.class);
    public static final TagKey<Item> TAG = ItemTags.tag((String)"fantasyfurniture", (String)"dyeable");
    public static final String TRANSLATION_KEY = "text.%s.dyeable";

    default public String getDyeableTranslationKey() {
        return TRANSLATION_KEY.formatted(((Block)this).m_7705_());
    }

    default public MutableComponent getDyeableComponent() {
        return Component.m_237115_((String)this.getDyeableTranslationKey()).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }

    public static BlockState registerDefaultBlockState(BlockState blockState) {
        return IDyeable.setDyeColor(blockState, DyeColor.WHITE);
    }

    public static Optional<DyeColor> getDyeColor(BlockGetter level, BlockPos pos, BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            BlockPos origin = multiBlock.getMultiBlockOriginPos(blockState, pos);
            BlockState originBlockState = level.m_8055_(origin);
            return IDyeable.getDyeColor(originBlockState).or(() -> IDyeable.getDyeColor(blockState));
        }
        return IDyeable.getDyeColor(blockState);
    }

    public static boolean setDyeColor(LevelAccessor level, BlockPos pos, BlockState blockState, DyeColor dyeColor) {
        BlockState newBlockState;
        DoubleBlockHalf half;
        BlockPos otherPos;
        BlockState otherBlockState;
        BlockState newOtherBlockState;
        boolean changed = false;
        Block block = blockState.m_60734_();
        if (block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            BlockPos origin = multiBlock.getMultiBlockOriginPos(blockState, pos);
            for (BlockPos localPos : multiBlock.getMultiBlockLocalPositions()) {
                BlockState worldBlockState;
                BlockState newBlockState2;
                BlockPos worldPos = multiBlock.getMultiBlockWorldSpaceFromLocalSpace(blockState, origin, localPos);
                if (worldPos.equals((Object)pos) || (newBlockState2 = IDyeable.setDyeColor(worldBlockState = level.m_8055_(worldPos), dyeColor)) == worldBlockState) continue;
                changed = level.m_7731_(worldPos, newBlockState2, 3) || changed;
            }
        }
        if (blockState.m_60734_() instanceof FurnitureDoorBlock && (newOtherBlockState = IDyeable.setDyeColor(otherBlockState = level.m_8055_(otherPos = (half = (DoubleBlockHalf)blockState.m_61143_((Property)FurnitureDoorBlock.f_52730_)) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_()), dyeColor)) != otherBlockState) {
            boolean bl = changed = level.m_7731_(otherPos, newOtherBlockState, 3) || changed;
        }
        if ((newBlockState = IDyeable.setDyeColor(blockState, dyeColor)) != blockState) {
            changed = level.m_7731_(pos, newBlockState, 3) || changed;
        }
        return changed;
    }

    public static MaterialColor getDyedMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
        return IDyeable.getDyeColor(level, pos, blockState).map(DyeColor::m_41069_).orElse(defaultColor);
    }

    public static void registerProperties(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)BLOCKSTATE_PROPERTY);
    }

    @Nullable
    public static BlockState getStateForPlacement(BlockPlaceContext ctx, @Nullable BlockState placementBlockState) {
        if (placementBlockState != null) {
            BlockState[] effectivelyFinal = new BlockState[]{placementBlockState};
            effectivelyFinal[0] = IDyeable.getDyeColor(ctx.m_43722_()).map(c -> IDyeable.setDyeColor(effectivelyFinal[0], c)).orElse(effectivelyFinal[0]);
            BlockState existingBlockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
            if (existingBlockState.m_60713_(effectivelyFinal[0].m_60734_())) {
                effectivelyFinal[0] = IDyeable.getDyeColor(existingBlockState).map(color -> IDyeable.setDyeColor(effectivelyFinal[0], color)).orElse(effectivelyFinal[0]);
            }
            placementBlockState = effectivelyFinal[0];
        }
        return placementBlockState;
    }

    public static InteractionResult use(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (dyeColor != null && IDyeable.setDyeColor((LevelAccessor)level, pos, blockState, dyeColor)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static ItemStack getCloneItemStack(BlockState blockState, BlockGetter level, BlockPos pos, ItemStack stack) {
        return IDyeable.getDyeColor(level, pos, blockState).map(color -> IDyeable.setDyeColor(stack, color)).orElse(stack);
    }

    public static void appendHoverText(IDyeable dyeable, List<Component> tooltip) {
        tooltip.add((Component)dyeable.getDyeableComponent());
    }

    public static int tintFromDyeColor(DyeColor color) {
        if (color == DyeColor.BLACK) {
            return 0x212121;
        }
        float[] colors = color.m_41068_();
        int red = (int)(colors[0] * 255.0f);
        int green = (int)(colors[1] * 255.0f);
        int blue = (int)(colors[2] * 255.0f);
        return FastColor.ARGB32.m_13660_((int)255, (int)red, (int)green, (int)blue);
    }

    public static Optional<DyeColor> getDyeColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            String name;
            CompoundTag blockStateTag;
            if (tag.m_128425_("BlockStateTag", 10) && (blockStateTag = tag.m_128469_("BlockStateTag")).m_128425_(name = BLOCKSTATE_PROPERTY.m_61708_(), 8)) {
                return BLOCKSTATE_PROPERTY.m_6215_(blockStateTag.m_128461_(name));
            }
            if (tag.m_128425_(NBT_KEY, 8)) {
                String dyeName = tag.m_128461_(NBT_KEY);
                return Optional.ofNullable(DyeColor.m_41057_((String)dyeName, null));
            }
        }
        return Optional.empty();
    }

    @CanIgnoreReturnValue
    public static ItemStack setDyeColor(ItemStack stack, @Nullable DyeColor color) {
        CompoundTag stackTag = stack.m_41783_();
        if (color == null) {
            if (stackTag != null && stackTag.m_128425_(NBT_KEY, 8)) {
                stackTag.m_128473_(NBT_KEY);
                stack.m_41751_(stackTag);
            }
        } else {
            if (stackTag == null) {
                stackTag = new CompoundTag();
            }
            stackTag.m_128359_(NBT_KEY, color.m_7912_());
            stack.m_41751_(stackTag);
        }
        return stack;
    }

    public static boolean hasDyeColorProperty(BlockState blockState) {
        return blockState.m_61138_(BLOCKSTATE_PROPERTY);
    }

    public static Optional<DyeColor> getDyeColor(BlockState blockState) {
        return blockState.m_61145_(BLOCKSTATE_PROPERTY);
    }

    public static BlockState setDyeColor(BlockState blockState, DyeColor color) {
        return IDyeable.hasDyeColorProperty(blockState) ? (BlockState)blockState.m_61124_(BLOCKSTATE_PROPERTY, (Comparable)color) : blockState;
    }
}

