/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class FurnitureDoorBlock
extends DoorBlock {
    public FurnitureDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape m_7514_(BlockState blockState) {
        DoubleBlockHalf half = blockState.m_61145_((Property)f_52730_).orElse(DoubleBlockHalf.LOWER);
        return half == DoubleBlockHalf.LOWER ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_DOOR_DOUBLE.isIn(blockState)) {
            return HitBoxes.NORDIC.doorDouble(this, blockState);
        }
        if (AllBlocks.NORDIC_DOOR_SINGLE.isIn(blockState)) {
            return HitBoxes.NORDIC.doorSingle(this, blockState);
        }
        if (AllBlocks.DUNMER_DOOR_DOUBLE.isIn(blockState)) {
            return HitBoxes.DUNMER.doorDouble(this, blockState);
        }
        if (AllBlocks.DUNMER_DOOR_SINGLE.isIn(blockState)) {
            return HitBoxes.DUNMER.doorSingle(this, blockState);
        }
        if (AllBlocks.VENTHYR_DOOR_DOUBLE.isIn(blockState)) {
            return HitBoxes.VENTHYR.doorDouble(this, blockState);
        }
        if (AllBlocks.VENTHYR_DOOR_SINGLE.isIn(blockState)) {
            return HitBoxes.VENTHYR.doorSingle(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_DOOR_DOUBLE.isIn(blockState) || AllBlocks.BONE_WITHER_DOOR_DOUBLE.isIn(blockState)) {
            return HitBoxes.BONE.doorDouble(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_DOOR_SINGLE.isIn(blockState) || AllBlocks.BONE_WITHER_DOOR_SINGLE.isIn(blockState)) {
            return HitBoxes.BONE.doorSingle(this, blockState);
        }
        if (AllBlocks.ROYAL_DOOR_DOUBLE.isIn(blockState)) {
            return HitBoxes.ROYAL.doorDouble(this, blockState);
        }
        if (AllBlocks.ROYAL_DOOR_SINGLE.isIn(blockState)) {
            return HitBoxes.ROYAL.doorSingle(this, blockState);
        }
        if (AllBlocks.NECROLORD_DOOR_DOUBLE.isIn(blockState)) {
            return HitBoxes.NECROLORD.doorDouble(this, blockState);
        }
        if (AllBlocks.NECROLORD_DOOR_SINGLE.isIn(blockState)) {
            return HitBoxes.NECROLORD.doorSingle(this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public static class Dyeable
    extends FurnitureDoorBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MaterialColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
            MaterialColor color = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, color);
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            IDyeable.registerProperties(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
        }

        @Nullable
        public BlockState m_5573_(BlockPlaceContext ctx) {
            BlockState placementBlockState = super.m_5573_(ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

