/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.integration.jei;

import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import umpaz.farmersrespite.client.gui.KettleScreen;
import umpaz.farmersrespite.common.block.entity.container.KettleMenu;
import umpaz.farmersrespite.common.registry.FRItems;
import umpaz.farmersrespite.common.registry.FRMenuTypes;
import umpaz.farmersrespite.integration.jei.JEIFRRecipeTypes;
import umpaz.farmersrespite.integration.jei.JEIFRRecipes;
import umpaz.farmersrespite.integration.jei.category.BrewingRecipeCategory;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIFRPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("farmersrespite", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new BrewingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        JEIFRRecipes modRecipes = new JEIFRRecipes();
        registration.addRecipes(JEIFRRecipeTypes.BREWING, modRecipes.getKettleRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)FRItems.KETTLE.get()), new RecipeType[]{JEIFRRecipeTypes.BREWING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(KettleScreen.class, 62, 25, 40, 17, new RecipeType[]{JEIFRRecipeTypes.BREWING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(KettleMenu.class, (MenuType)FRMenuTypes.KETTLE.get(), JEIFRRecipeTypes.BREWING, 0, 2, 5, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

