/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import umpaz.farmersrespite.common.block.KettleBlock;
import umpaz.farmersrespite.common.block.entity.container.KettleMenu;
import umpaz.farmersrespite.common.block.entity.inventory.KettleItemHandler;
import umpaz.farmersrespite.common.crafting.KettleRecipe;
import umpaz.farmersrespite.common.registry.FRBlockEntityTypes;
import umpaz.farmersrespite.common.registry.FRItems;
import umpaz.farmersrespite.common.registry.FRRecipeTypes;
import umpaz.farmersrespite.common.registry.FRSounds;
import umpaz.farmersrespite.common.utility.FRTextUtils;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class KettleBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
HeatableBlockEntity,
Nameable,
RecipeHolder {
    public static final int DRINK_DISPLAY_SLOT = 2;
    public static final int CONTAINER_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;
    public static final int INVENTORY_SIZE = 5;
    public static boolean WHISTLE = false;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new KettleItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new KettleItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private int brewTime;
    private int brewTimeTotal;
    private boolean needWater;
    private ItemStack drinkContainerStack = ItemStack.f_41583_;
    private Component customName;
    protected final ContainerData kettleData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe = true;

    public KettleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FRBlockEntityTypes.KETTLE.get(), pos, state);
    }

    public static ItemStack getMealFromItem(ItemStack kettleStack) {
        CompoundTag inventoryTag;
        if (!kettleStack.m_150930_((Item)FRItems.KETTLE.get())) {
            return ItemStack.f_41583_;
        }
        CompoundTag compound = kettleStack.m_41737_("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.m_128469_("Inventory")).m_128425_("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            return handler.getStackInSlot(2);
        }
        return ItemStack.f_41583_;
    }

    public static void takeServingFromItem(ItemStack kettleStack) {
        CompoundTag inventoryTag;
        if (!kettleStack.m_150930_((Item)FRItems.KETTLE.get())) {
            return;
        }
        CompoundTag compound = kettleStack.m_41737_("BlockEntityTag");
        if (compound != null && (inventoryTag = compound.m_128469_("Inventory")).m_128425_("Items", 9)) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(inventoryTag);
            ItemStack newMealStack = handler.getStackInSlot(2);
            newMealStack.m_41774_(1);
            compound.m_128473_("Inventory");
            compound.m_128365_("Inventory", (Tag)handler.serializeNBT());
        }
    }

    public static ItemStack getContainerFromItem(ItemStack kettleStack) {
        if (!kettleStack.m_150930_((Item)FRItems.KETTLE.get())) {
            return ItemStack.f_41583_;
        }
        CompoundTag compound = kettleStack.m_41737_("BlockEntityTag");
        if (compound != null) {
            return ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        }
        return ItemStack.f_41583_;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.brewTime = compound.m_128451_("BrewTime");
        this.brewTimeTotal = compound.m_128451_("BrewTimeTotal");
        this.needWater = compound.m_128471_("NeedWater");
        this.drinkContainerStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        CompoundTag compoundRecipes = compound.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("BrewTime", this.brewTime);
        compound.m_128405_("BrewTimeTotal", this.brewTimeTotal);
        compound.m_128379_("NeedWater", this.needWater);
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag writeMeal(CompoundTag compound) {
        if (this.getMeal().m_41619_()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(5);
        for (int i = 0; i < 5; ++i) {
            drops.setStackInSlot(i, i == 2 ? this.inventory.getStackInSlot(i) : ItemStack.f_41583_);
        }
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)drops.serializeNBT());
        return compound;
    }

    public static void brewingTick(Level level, BlockPos pos, BlockState state, KettleBlockEntity kettle) {
        boolean isHeated = kettle.isHeated(level, pos);
        boolean didInventoryChange = false;
        if (isHeated && kettle.hasInput()) {
            Optional<KettleRecipe> recipe = kettle.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)kettle.inventory));
            if (recipe.isPresent() && kettle.canBrew(recipe.get())) {
                didInventoryChange = kettle.processBrewing(recipe.get(), kettle);
            } else {
                kettle.brewTime = 0;
            }
        } else if (kettle.brewTime > 0) {
            kettle.brewTime = Mth.m_14045_((int)(kettle.brewTime - 2), (int)0, (int)kettle.brewTimeTotal);
        }
        ItemStack mealStack = kettle.getMeal();
        if (!mealStack.m_41619_()) {
            if (!kettle.doesMealHaveContainer(mealStack)) {
                kettle.moveMealToOutput();
                didInventoryChange = true;
            } else if (!kettle.inventory.getStackInSlot(3).m_41619_()) {
                kettle.useStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            kettle.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, KettleBlockEntity kettle) {
        boolean i = (Boolean)state.m_61143_((Property)KettleBlock.LID);
        ItemStack mealStack = kettle.getMeal();
        if (kettle.isHeated(level, pos) && i && !mealStack.m_41619_()) {
            double d7;
            Direction direction = (Direction)state.m_61143_((Property)KettleBlock.FACING);
            Direction.Axis direction$axis = direction.m_122434_();
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.5;
            double d2 = (double)pos.m_123343_() + 0.5;
            double d4 = 0.0;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = 0.0;
            double d = d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            if (level.f_46441_.m_188503_(5) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123806_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
            if (WHISTLE) {
                KettleBlockEntity.whistleNoise(level, pos, state, kettle);
                WHISTLE = false;
            }
        }
    }

    public static void whistleNoise(Level level, BlockPos pos, BlockState state, KettleBlockEntity kettle) {
        boolean i = (Boolean)state.m_61143_((Property)KettleBlock.LID);
        if (kettle.isHeated() && i) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            float pitch = RandomSource.m_216327_().m_188501_() * 0.2f + 0.9f;
            level.m_7785_(x, y, z, (SoundEvent)FRSounds.BLOCK_KETTLE_WHISTLE.get(), SoundSource.BLOCKS, 0.25f, pitch, false);
        }
    }

    private Optional<KettleRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)FRRecipeTypes.BREWING.get()).get(this.lastRecipeID)) instanceof KettleRecipe) {
            if (recipe.m_5818_((Container)inventoryWrapper, this.f_58857_)) {
                return Optional.of((KettleRecipe)recipe);
            }
            if (recipe.m_8043_().m_41656_(this.getMeal())) {
                return Optional.empty();
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)FRRecipeTypes.BREWING.get(), (Container)inventoryWrapper, this.f_58857_))).isPresent()) {
            this.lastRecipeID = ((KettleRecipe)((Optional)recipe).get()).m_6423_();
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public ItemStack getContainer() {
        if (!this.drinkContainerStack.m_41619_()) {
            return this.drinkContainerStack;
        }
        return this.getMeal().getCraftingRemainingItem();
    }

    private boolean hasInput() {
        for (int i = 0; i < 2; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean canBrew(KettleRecipe recipe) {
        this.needWater = recipe.getNeedWater();
        if (this.hasInput()) {
            ItemStack resultStack = recipe.m_8043_();
            if (resultStack.m_41619_()) {
                return false;
            }
            ItemStack storedDrinkStack = this.inventory.getStackInSlot(2);
            if (this.isWater() || !this.needWater) {
                if (storedDrinkStack.m_41619_()) {
                    return true;
                }
                if (!storedDrinkStack.m_41656_(resultStack)) {
                    return false;
                }
                if (storedDrinkStack.m_41613_() + resultStack.m_41613_() <= this.inventory.getSlotLimit(2)) {
                    return true;
                }
                return storedDrinkStack.m_41613_() + resultStack.m_41613_() <= resultStack.m_41741_();
            }
        }
        return false;
    }

    private boolean processBrewing(KettleRecipe recipe, KettleBlockEntity kettle) {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.brewTime;
        this.brewTimeTotal = recipe.getBrewTime();
        if (this.brewTime < this.brewTimeTotal) {
            return false;
        }
        this.brewTime = 0;
        this.drinkContainerStack = recipe.getOutputContainer();
        ItemStack resultStack = recipe.m_8043_();
        ItemStack storedDrinkStack = this.inventory.getStackInSlot(2);
        if (storedDrinkStack.m_41619_()) {
            this.inventory.setStackInSlot(2, resultStack.m_41777_());
            WHISTLE = true;
        } else if (storedDrinkStack.m_41656_(resultStack)) {
            storedDrinkStack.m_41769_(resultStack.m_41613_());
            WHISTLE = true;
        }
        if (this.needWater) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)KettleBlock.WATER_LEVEL, (Comparable)Integer.valueOf((Integer)this.m_58900_().m_61143_((Property)KettleBlock.WATER_LEVEL) - 1)));
        }
        kettle.m_6029_(recipe);
        for (int i = 0; i < 2; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                Direction direction = ((Direction)this.m_58900_().m_61143_((Property)KettleBlock.FACING)).m_122428_();
                double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
                double y = (double)this.f_58858_.m_123342_() + 0.7;
                double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
                ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)this.inventory.getStackInSlot(i).getCraftingRemainingItem(), (double)x, (double)y, (double)z, (double)((float)direction.m_122429_() * 0.08f), (double)0.25, (double)((float)direction.m_122431_() * 0.08f));
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        return true;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(Player player) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.f_19853_, player.m_20182_());
        player.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                KettleBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((KettleRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.m_14143_((float)((float)craftedAmount * experience));
        float expFraction = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public boolean isHeated() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.isHeated(this.f_58857_, this.f_58858_);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getMeal() {
        return this.inventory.getStackInSlot(2);
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 5; ++i) {
            if (i == 2) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.inventory.getStackInSlot(2);
        ItemStack outputStack = this.inventory.getStackInSlot(4);
        int mealCount = Math.min(mealStack.m_41613_(), mealStack.m_41741_() - outputStack.m_41613_());
        if (outputStack.m_41619_()) {
            this.inventory.setStackInSlot(4, mealStack.m_41620_(mealCount));
        } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
            mealStack.m_41774_(mealCount);
            outputStack.m_41769_(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        ItemStack mealStack = this.inventory.getStackInSlot(2);
        ItemStack containerInputStack = this.inventory.getStackInSlot(3);
        ItemStack outputStack = this.inventory.getStackInSlot(4);
        if (this.isContainerValid(containerInputStack) && outputStack.m_41613_() < outputStack.m_41741_()) {
            int smallerStackCount = Math.min(mealStack.m_41613_(), containerInputStack.m_41613_());
            int mealCount = Math.min(smallerStackCount, mealStack.m_41741_() - outputStack.m_41613_());
            if (outputStack.m_41619_()) {
                containerInputStack.m_41774_(mealCount);
                this.inventory.setStackInSlot(4, mealStack.m_41620_(mealCount));
            } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
                mealStack.m_41774_(mealCount);
                containerInputStack.m_41774_(mealCount);
                outputStack.m_41769_(mealCount);
            }
        }
    }

    public ItemStack useHeldItemOnMeal(ItemStack container) {
        if (this.isContainerValid(container) && !this.getMeal().m_41619_()) {
            container.m_41774_(1);
            return this.getMeal().m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return !this.drinkContainerStack.m_41619_() || meal.hasCraftingRemainingItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.m_41619_()) {
            return false;
        }
        if (!this.drinkContainerStack.m_41619_()) {
            return this.drinkContainerStack.m_41656_(containerItem);
        }
        return this.getMeal().getCraftingRemainingItem().m_41656_(containerItem);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : FRTextUtils.getTranslation("container.kettle", new Object[0]);
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new KettleMenu(id, player, this, this.kettleData);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 2) {
                    KettleBlockEntity.this.checkNewRecipe = true;
                }
                KettleBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> KettleBlockEntity.this.brewTime;
                    case 1 -> KettleBlockEntity.this.brewTimeTotal;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        KettleBlockEntity.this.brewTime = value;
                        break;
                    }
                    case 1: {
                        KettleBlockEntity.this.brewTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public boolean isWater() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        return (Integer)state.m_61143_((Property)KettleBlock.WATER_LEVEL) > 0;
    }
}

