/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import umpaz.farmersrespite.common.FRConfiguration;
import umpaz.farmersrespite.common.registry.FRAdvancments;
import umpaz.farmersrespite.common.registry.FRBlocks;
import umpaz.farmersrespite.common.registry.FRItems;

public class TeaBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final BooleanProperty STUNTED = BooleanProperty.m_61465_((String)"stunted");
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape SHAPE_LOWER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0));
    private static final VoxelShape SHAPE_UPPER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)-5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)-16.0, (double)6.0, (double)10.0, (double)-5.0, (double)10.0));

    public TeaBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)STUNTED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_UPPER;
        }
        return SHAPE_LOWER;
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_204336_(BlockTags.f_144274_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? this.m_6266_(level.m_8055_(blockpos), (BlockGetter)level, blockpos) : state.m_60713_((Block)this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, STUNTED, HALF});
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FRItems.TEA_SEEDS.get());
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3 && state.m_61143_(HALF) == DoubleBlockHalf.LOWER && (Boolean)state.m_61143_((Property)STUNTED) != true;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)((Integer)facingState.m_61143_((Property)AGE)))).m_61124_((Property)STUNTED, (Comparable)((Boolean)facingState.m_61143_((Property)STUNTED))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && !((Boolean)state.m_61143_((Property)STUNTED)).booleanValue() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(12) == 0 ? 1 : 0) != 0) && (Integer)state.m_61143_((Property)AGE) < 3) {
            this.m_214148_(level, random, pos, state);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            TeaBushBlock.preventCreativeDropFromBottomPart(pLevel, pPos, pState, pPlayer);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos = pContext.m_8083_();
        if (blockpos.m_123342_() < 255 && pContext.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(pContext)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)STUNTED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        pLevel.m_7731_(pPos.m_7494_(), (BlockState)pState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    protected static void preventCreativeDropFromBottomPart(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        int i = (Integer)state.m_61143_((Property)AGE);
        ItemStack heldStack = player.m_21120_(handIn);
        Item item = heldStack.m_41720_();
        if (item == Items.f_42574_) {
            int j = world.f_46441_.m_188503_(2);
            int k = 2 + world.f_46441_.m_188503_(2);
            int l = world.f_46441_.m_188503_(2);
            if (i == 0) {
                TeaBushBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FRItems.GREEN_TEA_LEAVES.get(), 2 + j));
            }
            if (i == 1) {
                TeaBushBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FRItems.YELLOW_TEA_LEAVES.get(), 2 + j));
            }
            if (i == 2) {
                TeaBushBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FRItems.YELLOW_TEA_LEAVES.get(), 1 + j));
                TeaBushBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FRItems.BLACK_TEA_LEAVES.get(), 1 + l));
            }
            if (i == 3) {
                TeaBushBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FRItems.BLACK_TEA_LEAVES.get(), 2 + j));
            }
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                world.m_46597_(pos, ((Block)FRBlocks.SMALL_TEA_BUSH.get()).m_49966_());
            }
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                world.m_46597_(pos.m_7495_(), ((Block)FRBlocks.SMALL_TEA_BUSH.get()).m_49966_());
            }
            world.m_5594_(player, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            TeaBushBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42398_, k));
            heldStack.m_41622_(1, (LivingEntity)player, p_226874_1_ -> player.m_21190_(handIn));
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (item instanceof AxeItem && !((Boolean)state.m_61143_((Property)STUNTED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)STUNTED, (Comparable)Boolean.valueOf(true)));
            world.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            heldStack.m_41622_(1, (LivingEntity)player, p_226874_1_ -> player.m_21190_(handIn));
            if (player instanceof ServerPlayer) {
                FRAdvancments.STUNT_TEA_BUSH.trigger((ServerPlayer)player);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, handIn, result);
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i != 3) {
            return (Boolean)FRConfiguration.BONE_MEAL_TEA.get();
        }
        return false;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)AGE);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)));
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }
}

