/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import umpaz.farmersrespite.common.FRConfiguration;
import umpaz.farmersrespite.common.block.state.WitherRootsUtil;
import umpaz.farmersrespite.common.registry.FRBlocks;
import umpaz.farmersrespite.common.registry.FRItems;

public class CoffeeStemBlock
extends BushBlock
implements BonemealableBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public CoffeeStemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.NETHER;
    }

    protected boolean m_6266_(BlockState state, BlockGetter pLevel, BlockPos pPos) {
        return state.m_60713_(Blocks.f_50137_) || state.m_60713_(Blocks.f_50138_) || state.m_60713_(Blocks.f_152597_) || state.m_60713_(Blocks.f_50450_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, FACING});
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FRItems.COFFEE_BEANS.get());
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 2;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        for (BlockPos neighborPos : WitherRootsUtil.randomInSquare(random, pos, 2)) {
            BlockState neighborState = level.m_8055_(neighborPos);
            int witherRootRandom = random.m_188503_(5);
            BlockState witherRootsState = witherRootRandom < 2 ? ((Block)FRBlocks.WITHER_ROOTS.get()).m_49966_() : (witherRootRandom < 4 ? ((Block)FRBlocks.WITHER_ROOTS_PLANT.get()).m_49966_() : ((Block)FRBlocks.WILD_COFFEE_BUSH.get()).m_49966_());
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(2) == 0 ? 1 : 0) != 0)) {
                if (neighborState.m_60734_() instanceof CropBlock) {
                    level.m_46597_(neighborPos, witherRootsState);
                    this.m_214148_(level, random, pos, state);
                } else if (level.m_6042_().f_63857_()) {
                    this.m_214148_(level, random, pos, state);
                }
            }
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        boolean flag;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl = flag = i == 2;
        if (!flag && player.m_21120_(handIn).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (i == 2) {
            CoffeeStemBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FRItems.COFFEE_BERRIES.get(), 1));
            world.m_5594_(player, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, handIn, result);
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        int i = (Integer)state.m_61143_((Property)AGE);
        return (Boolean)FRConfiguration.BONE_MEAL_COFFEE.get() != false && i != 2;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)AGE);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)));
    }
}

