/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.pack;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.crystalnest.cobweb.api.pack.DynamicResourceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public class DynamicTagBuilder<T>
extends TagBuilder {
    private final Set<String> keys = new HashSet<String>();
    private final List<ResourceLocation> tags;
    private final Registry<T> registry;

    private DynamicTagBuilder(Registry<T> registry, List<ResourceLocation> tags) {
        this.tags = tags;
        this.registry = registry;
    }

    @SafeVarargs
    public static <R> DynamicTagBuilder<R> of(Registry<R> registry, TagKey<? extends R> ... tags) {
        return new DynamicTagBuilder<R>(registry, Arrays.stream(tags).map(TagKey::f_203868_).toList());
    }

    @SafeVarargs
    public static <R> DynamicTagBuilder<R> of(ResourceKey<? extends Registry<R>> registryKey, TagKey<? extends R> ... tags) {
        return DynamicTagBuilder.of((Registry)Registry.f_122897_.m_7745_(registryKey.m_135782_()), tags);
    }

    public List<ResourceLocation> getTags() {
        return this.tags;
    }

    public List<ResourceLocation> getPaths() {
        return this.getTags().stream().map(tag -> DynamicResourceType.TAG.getPath(new ResourceLocation(tag.m_135827_(), this.registry.m_123023_().m_135782_().m_135815_() + "s/" + tag.m_135815_()))).toList();
    }

    @NotNull
    public DynamicTagBuilder<T> add(@NotNull TagEntry entry) {
        if (this.keys.add(entry.toString())) {
            return (DynamicTagBuilder)super.m_215902_(entry);
        }
        return this;
    }

    public DynamicTagBuilder<T> addTag(TagKey<? extends T> tagKey) {
        return (DynamicTagBuilder)this.m_215907_(tagKey.f_203868_());
    }

    public DynamicTagBuilder<T> addElement(T element) {
        return (DynamicTagBuilder)this.m_215900_(Objects.requireNonNull(this.registry.m_7981_(element)));
    }

    public DynamicTagBuilder<T> addElements(Collection<? extends T> elements) {
        for (T element : elements) {
            this.addElement(element);
        }
        return this;
    }

    public DynamicTagBuilder<T> addElements(T ... elements) {
        for (T element : elements) {
            this.addElement(element);
        }
        return this;
    }

    public JsonElement json() {
        return (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(this.m_215904_(), false)).getOrThrow(false, error -> {});
    }
}

