/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.secondchanceforge.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SecondChanceConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final SecondChanceConfig CONFIG;
    public final ForgeConfigSpec.BooleanValue coyoteTimeEnabled;
    public final ForgeConfigSpec.BooleanValue secondChanceEnabled;
    public final ForgeConfigSpec.BooleanValue secondChanceSound;
    public final ForgeConfigSpec.BooleanValue secondChanceExplosions;
    public final ForgeConfigSpec.BooleanValue secondChanceMobs;
    public final ForgeConfigSpec.BooleanValue secondChanceFalls;
    public final ForgeConfigSpec.BooleanValue secondChanceAnvils;
    public final ForgeConfigSpec.BooleanValue secondChanceLightning;
    public final ForgeConfigSpec.BooleanValue secondChanceElytraCrash;
    public final ForgeConfigSpec.BooleanValue secondChanceFallingBlocks;
    public final ForgeConfigSpec.BooleanValue secondChanceMagic;
    public final ForgeConfigSpec.BooleanValue secondChancePlayers;
    public final ForgeConfigSpec.BooleanValue secondChanceTridents;
    public final ForgeConfigSpec.BooleanValue secondChanceArrows;
    public final ForgeConfigSpec.BooleanValue secondChanceFireworks;
    public final ForgeConfigSpec.BooleanValue secondChanceWitherSkulls;
    public final ForgeConfigSpec.BooleanValue secondChanceStalactite;
    public final ForgeConfigSpec.BooleanValue secondChanceStalagmite;
    public final ForgeConfigSpec.IntValue coyoteTimeTicks;
    public final ForgeConfigSpec.BooleanValue usePercentConfig;
    public final ForgeConfigSpec.DoubleValue secondChanceActivationHealth;
    public final ForgeConfigSpec.DoubleValue secondChanceHealthRemainder;
    public final ForgeConfigSpec.DoubleValue secondChanceActivationPercent;
    public final ForgeConfigSpec.DoubleValue secondChanceRemainderPercent;

    public SecondChanceConfig(ForgeConfigSpec.Builder builder) {
        this.coyoteTimeEnabled = builder.comment("Determines if the 'Coyote Time' feature is enabled.\n'Coyote Time' allows the player to jump for a second or two after falling off of a block in order to stop themselves from falling into a pit.\nThis will not allow the player to double jump, only jump when walking off of a block.").translation("secondchanceforge.config.tooltip.coyoteTimeEnabled").define("coyoteTimeEnabled", true);
        this.coyoteTimeTicks = builder.comment("Determines how long (in ticks) the player has to jump with 'Coyote Time' after falling off a block.").translation("secondchanceforge.config.tooltip.coyoteTimeTicks").defineInRange("coyoteTimeTicks", 10, 1, Integer.MAX_VALUE);
        this.secondChanceEnabled = builder.comment("Determines if the 'Second Chance' feature is enabled.\n'Second Chance' leaves the player at half a heart after taking fatal damage from a mob or explosion while at or above 7 hearts.").translation("secondchanceforge.config.tooltip.secondChanceEnabled").define("secondChanceEnabled", true);
        this.secondChanceSound = builder.comment("Determines if the 'Second Chance' sound will play when the effect is activated.").translation("secondchanceforge.config.tooltip.secondChanceSound").define("secondChanceSound", true);
        this.secondChanceExplosions = builder.comment("Determines if the 'Second Chance' feature will be activated by explosions.").translation("secondchanceforge.config.tooltip.secondChanceExplosions").define("secondChanceExplosions", true);
        this.secondChanceMobs = builder.comment("Determines if the 'Second Chance' feature will be activated by mobs.").translation("secondchanceforge.config.tooltip.secondChanceMobs").define("secondChanceMobs", true);
        this.secondChanceFalls = builder.comment("Determines if the 'Second Chance' feature will be activated by fall damage.").translation("secondchanceforge.config.tooltip.secondChanceFalls").define("secondChanceFalls", false);
        this.secondChanceAnvils = builder.comment("Determines if the 'Second Chance' feature will be activated by falling anvils.").translation("secondchanceforge.config.tooltip.secondChanceAnvils").define("secondChanceAnvils", false);
        this.secondChanceLightning = builder.comment("Determines if the 'Second Chance' feature will be activated by lightning.").translation("secondchanceforge.config.tooltip.secondChanceLightning").define("secondChanceLightning", false);
        this.secondChanceElytraCrash = builder.comment("Determines if the 'Second Chance' feature will be activated by crashing into a wall.").translation("secondchanceforge.config.tooltip.secondChanceElytraCrash").define("secondChanceElytraCrash", false);
        this.secondChanceFallingBlocks = builder.comment("Determines if the 'Second Chance' feature will be activated by falling blocks.").translation("secondchanceforge.config.tooltip.secondChanceFallingBlocks").define("secondChanceFallingBlocks", false);
        this.secondChanceMagic = builder.comment("Determines if the 'Second Chance' feature will be activated by magic, such as potions.").translation("secondchanceforge.config.tooltip.secondChanceMagic").define("secondChanceMagic", false);
        this.secondChancePlayers = builder.comment("Determines if the 'Second Chance' feature will be activated by players.").translation("secondchanceforge.config.tooltip.secondChancePlayers").define("secondChancePlayers", false);
        this.secondChanceTridents = builder.comment("Determines if the 'Second Chance' feature will be activated by thrown tridents.").translation("secondchanceforge.config.tooltip.secondChanceTridents").define("secondChanceTridents", false);
        this.secondChanceArrows = builder.comment("Determines if the 'Second Chance' feature will be activated by arrows.").translation("secondchanceforge.config.tooltip.secondChanceArrows").define("secondChanceArrows", false);
        this.secondChanceFireworks = builder.comment("Determines if the 'Second Chance' feature will be activated by fireworks.").translation("secondchanceforge.config.tooltip.secondChanceFireworks").define("secondChanceFireworks", false);
        this.secondChanceWitherSkulls = builder.comment("Determines if the 'Second Chance' feature will be activated by wither skulls.").translation("secondchanceforge.config.tooltip.secondChanceWitherSkulls").define("secondChanceWitherSkulls", false);
        this.secondChanceStalactite = builder.comment("Determines if the 'Second Chance' feature will be activated by a falling stalactite.").translation("secondchanceforge.config.tooltip.secondChanceStalactite").define("secondChanceStalactite", false);
        this.secondChanceStalagmite = builder.comment("Determines if the 'Second Chance' feature will be activated by falling on a stalagmite.").translation("secondchanceforge.config.tooltip.secondChanceStalagmite").define("secondChanceStalagmite", false);
        this.usePercentConfig = builder.comment("Determines if the 'percentage of health' config values will be used instead of exact values.").translation("secondchanceforge.config.tooltip.usePercentConfig").define("usePercentConfig", false);
        this.secondChanceActivationHealth = builder.comment("Determines how much health the player must start with for 'Second Chance' to activate.").translation("secondchanceforge.config.tooltip.secondChanceActivationHealth").defineInRange("secondChanceActivationHealth", 13.5, 0.5, Double.MAX_VALUE);
        this.secondChanceHealthRemainder = builder.comment("Determines how much health the player should be left with after 'Second Chance' activates.").translation("secondchanceforge.config.tooltip.secondChanceHealthRemainder").defineInRange("secondChanceHealthRemainder", 1.0, 1.0, Double.MAX_VALUE);
        this.secondChanceActivationPercent = builder.comment("Determines what percent of health the player must start with for 'Second Chance' to activate.").translation("secondchanceforge.config.tooltip.secondChanceActivationPercent").defineInRange("secondChanceActivationPercent", 0.65, 0.01, Double.MAX_VALUE);
        this.secondChanceRemainderPercent = builder.comment("Determines what percent health the player should be left with after 'Second Chance' activates.").translation("secondchanceforge.config.tooltip.secondChanceRemainderPercent").defineInRange("secondChanceHealthPercent", 0.05, 0.01, Double.MAX_VALUE);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(SecondChanceConfig::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (SecondChanceConfig)specPair.getLeft();
    }
}

