/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.entities;

import com.google.common.collect.Iterables;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class RiddenSummonEntity
extends Mob {
    private boolean clearedAI;

    public RiddenSummonEntity(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        if (!level.f_46443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(5.0);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return spawnData;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_20197_().contains(source.m_7639_())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entity) {
        return false;
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_21023_(MobEffect potion) {
        return false;
    }

    @Nullable
    public MobEffectInstance m_21124_(MobEffect potion) {
        return null;
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance potioneffect) {
        return false;
    }

    public void m_147215_(MobEffectInstance mobEffectInstance, @Nullable Entity entity) {
    }

    protected void m_6668_(DamageSource damageSource) {
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public SlotAccess m_141942_(int slot) {
        return SlotAccess.f_147290_;
    }

    public EntityDimensions m_6972_(Pose pose) {
        Entity e;
        EntityDimensions dimensions = this.originDimension(pose);
        if (this.m_20160_() && (e = this.m_146895_()) != null) {
            EntityDimensions otherDim = e.m_6972_(e.m_20089_());
            float rideOffsetY = (float)(this.m_6048_() + e.m_6049_());
            return EntityDimensions.m_20395_((float)Math.max(dimensions.f_20377_, otherDim.f_20377_), (float)Math.max(dimensions.f_20378_, otherDim.f_20378_ + rideOffsetY));
        }
        return dimensions;
    }

    protected EntityDimensions originDimension(Pose pose) {
        return this.m_6095_().m_20680_();
    }

    public static AABB riddenAABB(AABB thisAABB, AABB other) {
        double d = Math.min(thisAABB.f_82288_, other.f_82288_);
        double e = thisAABB.f_82289_;
        double f = Math.min(thisAABB.f_82290_, other.f_82290_);
        double g = Math.max(thisAABB.f_82291_, other.f_82291_);
        double h = Math.max(thisAABB.f_82292_, other.f_82292_);
        double i = Math.max(thisAABB.f_82293_, other.f_82293_);
        return new AABB(d, e, f, g, h, i);
    }

    public Iterable<ItemStack> m_20158_() {
        return Iterables.concat((Iterable[])new Iterable[0]);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.clearedAI) {
            this.clearedAI = true;
            this.m_147272_();
        }
        if (!this.m_20160_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected Component m_5677_() {
        return this.m_6095_().m_20676_();
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        this.m_6210_();
    }

    public CompoundTag m_20240_(CompoundTag compound) {
        CompoundTag tag = super.m_20240_(compound);
        tag.m_128469_("IMFlags").m_128359_("ServerSideEntityID", this.serverSideID().toString());
        return tag;
    }

    protected ResourceLocation m_7582_() {
        return BuiltInLootTables.f_78712_;
    }

    public abstract ResourceLocation serverSideID();

    public boolean doesntCollideWithRidden(Entity rider) {
        return this.f_19853_.m_45756_((Entity)this, RiddenSummonEntity.riddenAABB(this.m_20191_(), rider.m_20191_()));
    }
}

