/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.difficulty;

import com.google.common.collect.Lists;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.difficulty.IPlayerDifficulty;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.improvedmobs.platform.integration.DifficultyValues;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class DifficultyData
extends SavedData {
    private static final String identifier = "Difficulty";
    private float difficultyLevel;
    private long prevTime;

    public DifficultyData() {
    }

    private DifficultyData(CompoundTag tag) {
        this.load(tag);
    }

    public static DifficultyData get(MinecraftServer server) {
        return (DifficultyData)server.m_129783_().m_8895_().m_164861_(DifficultyData::new, DifficultyData::new, identifier);
    }

    public static float getDifficulty(Level world, LivingEntity e) {
        if (!(world instanceof ServerLevel)) {
            return 0.0f;
        }
        Vec3 pos = e.m_20182_();
        Supplier<Float> sup = switch (Config.CommonConfig.difficultyType) {
            default -> throw new IncompatibleClassChangeError();
            case Config.DifficultyType.GLOBAL -> () -> Float.valueOf(DifficultyData.get(world.m_7654_()).getDifficulty());
            case Config.DifficultyType.PLAYERMAX -> () -> {
                float diff = 0.0f;
                for (Player player : DifficultyData.playersIn((EntityGetter)world, pos, 256.0)) {
                    float pD = CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((ServerPlayer)player).map(IPlayerDifficulty::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue();
                    if (!(pD > diff)) continue;
                    diff = pD;
                }
                return Float.valueOf(diff);
            };
            case Config.DifficultyType.PLAYERMEAN -> () -> {
                float diff = 0.0f;
                List<Player> list = DifficultyData.playersIn((EntityGetter)world, pos, 256.0);
                if (list.isEmpty()) {
                    return Float.valueOf(0.0f);
                }
                for (Player player : list) {
                    diff += CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((ServerPlayer)player).map(IPlayerDifficulty::getDifficultyLevel).orElse(Float.valueOf(0.0f)).floatValue();
                }
                return Float.valueOf(diff / (float)list.size());
            };
        };
        return DifficultyValues.INSTANCE.getDifficulty(world, e.m_20183_(), sup);
    }

    public static List<Player> playersIn(EntityGetter getter, Vec3 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (Player player : getter.m_6907_()) {
            if (!player.m_20182_().m_82509_((Position)pos, radius)) continue;
            list.add(player);
        }
        return list;
    }

    public void increaseDifficultyBy(Function<Float, Float> increase, long time, MinecraftServer server) {
        this.difficultyLevel += increase.apply(Float.valueOf(this.getDifficulty())).floatValue();
        this.prevTime = time;
        server.m_6846_().m_11314_().forEach(player -> CrossPlatformStuff.INSTANCE.getPlayerDifficultyData((ServerPlayer)player).ifPresent(pd -> pd.setDifficultyLevel(pd.getDifficultyLevel() + ((Float)increase.apply(Float.valueOf(pd.getDifficultyLevel()))).floatValue())));
        this.m_77762_();
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
    }

    public void setDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel = level;
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
        this.m_77762_();
    }

    public void addDifficulty(float level, MinecraftServer server) {
        this.difficultyLevel += level;
        CrossPlatformStuff.INSTANCE.sendDifficultyData(this, server);
        this.m_77762_();
    }

    public float getDifficulty() {
        return this.difficultyLevel;
    }

    public long getPrevTime() {
        return this.prevTime;
    }

    public void load(CompoundTag nbt) {
        this.difficultyLevel = nbt.m_128457_(identifier);
        this.prevTime = nbt.m_128454_("Time");
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128350_(identifier, this.difficultyLevel);
        compound.m_128356_("Time", this.prevTime);
        return compound;
    }
}

