/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.ai.util.ItemAI;
import io.github.flemmli97.improvedmobs.ai.util.ItemAITasks;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.tenshilib.api.config.ExtendedItemStackWrapper;
import io.github.flemmli97.tenshilib.common.utils.ItemUtils;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class EquipmentList {
    private static final Map<EquipmentSlot, WeightedItemstackList> equips = new HashMap<EquipmentSlot, WeightedItemstackList>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Field techGunDmg;
    private static Field techgunAIAttackTime;
    private static Field techgunAIBurstCount;
    private static Field techgunAIburstAttackTime;
    private static final List<String> defaultZeroWeight;

    public static ItemStack getEquip(Mob e, EquipmentSlot slot, float difficulty) {
        WeightedItemstackList eq = equips.get(slot);
        if (eq == null || eq.list.isEmpty() || eq.getTotalWeight(difficulty) <= 0) {
            return ItemStack.f_41583_;
        }
        int index = e.m_217043_().m_188503_(eq.getTotalWeight(difficulty));
        for (WeightedItemstack entry : eq.list) {
            if ((index -= entry.getWeight(difficulty)) >= 0) continue;
            return entry.getItem();
        }
        return ItemStack.f_41583_;
    }

    public static void initEquip() throws InvalidItemNameException {
        try {
            File conf = CrossPlatformStuff.INSTANCE.configDirPath().resolve("improvedmobs").resolve("equipment.json").toFile();
            JsonObject confObj = new JsonObject();
            ArrayList errors = new ArrayList();
            if (!conf.exists()) {
                EquipmentList.initDefaultVals();
                conf.createNewFile();
            } else {
                FileReader reader = new FileReader(conf);
                confObj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (confObj == null) {
                    confObj = new JsonObject();
                }
                reader.close();
                for (EquipmentSlot key : EquipmentSlot.values()) {
                    if (!confObj.has(key.toString())) continue;
                    JsonObject obj = (JsonObject)confObj.get(key.toString());
                    if (!obj.entrySet().isEmpty()) {
                        obj.entrySet().forEach(ent -> {
                            float quality;
                            int weight;
                            if (((JsonElement)ent.getValue()).isJsonPrimitive()) {
                                weight = ((JsonElement)ent.getValue()).getAsInt();
                                quality = EquipmentList.correctQuality((String)ent.getKey()) ? EquipmentList.defaultQualityFromWeight(weight) : 0.0f;
                            } else {
                                JsonArray entry = ((JsonElement)ent.getValue()).getAsJsonArray();
                                weight = entry.get(0).getAsInt();
                                quality = entry.get(1).getAsFloat();
                            }
                            equips.compute(key, (s, l) -> l == null ? new WeightedItemstackList(new WeightedItemstack((String)ent.getKey(), weight, quality, errors)) : l.add(new WeightedItemstack((String)ent.getKey(), weight, quality, errors)));
                        });
                        continue;
                    }
                    equips.put(key, new WeightedItemstackList(new WeightedItemstack[0]));
                }
            }
            JsonArray comment = new JsonArray();
            comment.add("Mobs will be able to equip items declared here");
            comment.add("The first number is the weight while the second number is the quality");
            comment.add("Weight is the weight of an item. Higher weight means that the item is more likely to get choosen");
            comment.add("Quality is a modifier applied to the weight. The final weight used is weight + quality * current difficulty");
            confObj.add("__comment", (JsonElement)comment);
            for (EquipmentSlot key : EquipmentSlot.values()) {
                JsonObject eq = confObj.has(key.toString()) ? (JsonObject)confObj.get(key.toString()) : new JsonObject();
                EquipmentList.equips.get((Object)key).list.forEach(w -> {
                    JsonArray entry = new JsonArray();
                    entry.add((Number)w.weight);
                    entry.add((Number)Float.valueOf(w.quality));
                    eq.add(w.configString, (JsonElement)entry);
                });
                JsonObject sorted = new JsonObject();
                ArrayList member = new ArrayList();
                eq.entrySet().forEach(ent -> member.add((String)ent.getKey()));
                Collections.sort(member);
                member.forEach(s -> sorted.add(s, eq.get(s)));
                confObj.add(key.toString(), (JsonElement)sorted);
                equips.get(key).finishList();
            }
            conf.delete();
            conf.createNewFile();
            JsonWriter wr = GSON.newJsonWriter((Writer)new FileWriter(conf));
            GSON.toJson((Object)confObj, JsonObject.class, wr);
            wr.close();
            if (!errors.isEmpty()) {
                throw new InvalidItemNameException("No items with following names exist: " + errors);
            }
        }
        catch (IOException | IllegalStateException e) {
            ImprovedMobs.logger.error("Error initializing equipment");
            e.printStackTrace();
        }
    }

    private static void initDefaultVals() {
        PlatformUtils.INSTANCE.items().getIterator().forEach(item -> {
            ItemAI ai;
            if (item instanceof BowItem) {
                EquipmentList.addItemTo(EquipmentSlot.MAINHAND, item);
            }
            if ((ai = ItemAITasks.getAI(item)) != null) {
                switch (ai.prefHand()) {
                    case BOTH: {
                        if (ai.type() == ItemAI.ItemType.NONSTRAFINGITEM) {
                            float[] weights = EquipmentList.getDefaultWeight(item);
                            WeightedItemstack val = new WeightedItemstack((Item)item, (int)weights[0], weights[1]);
                            if (EquipmentList.equips.get((Object)EquipmentSlot.MAINHAND).list.contains(val)) break;
                            equips.compute(EquipmentSlot.OFFHAND, (s, l) -> l == null ? new WeightedItemstackList(val) : l.add(val));
                            break;
                        }
                        if (item instanceof ThrowablePotionItem) {
                            String potionItem = PlatformUtils.INSTANCE.items().getIDFrom(item).toString() + "{Potion:\"minecraft:harming\"}";
                            float[] weights = EquipmentList.getDefaultWeight(item);
                            equips.compute(EquipmentSlot.MAINHAND, (s, l) -> l == null ? new WeightedItemstackList(new WeightedItemstack(potionItem, (int)weights[0], weights[1], new ArrayList<String>())) : l.add(new WeightedItemstack(potionItem, (int)weights[0], weights[1], new ArrayList<String>())));
                            break;
                        }
                        EquipmentList.addItemTo(EquipmentSlot.MAINHAND, item);
                        break;
                    }
                    case MAIN: {
                        EquipmentList.addItemTo(EquipmentSlot.MAINHAND, item);
                        break;
                    }
                    case OFF: {
                        EquipmentList.addItemTo(EquipmentSlot.OFFHAND, item);
                    }
                }
            }
            if (item instanceof ArmorItem) {
                switch (((ArmorItem)item).m_40402_()) {
                    case FEET: {
                        EquipmentList.addItemTo(EquipmentSlot.FEET, item);
                        break;
                    }
                    case CHEST: {
                        EquipmentList.addItemTo(EquipmentSlot.CHEST, item);
                        break;
                    }
                    case HEAD: {
                        EquipmentList.addItemTo(EquipmentSlot.HEAD, item);
                        break;
                    }
                    case LEGS: {
                        EquipmentList.addItemTo(EquipmentSlot.LEGS, item);
                    }
                }
            }
            if ((item instanceof SwordItem || item instanceof DiggerItem) && !EquipmentList.defaultBlackLists(item)) {
                EquipmentList.addItemTo(EquipmentSlot.MAINHAND, item);
            }
        });
    }

    private static void addItemTo(EquipmentSlot slot, Item item) {
        float[] weights = EquipmentList.getDefaultWeight(item);
        equips.compute(slot, (s, l) -> l == null ? new WeightedItemstackList(new WeightedItemstack(item, (int)weights[0], weights[1])) : l.add(new WeightedItemstack(item, (int)weights[0], weights[1])));
    }

    private static boolean defaultBlackLists(Item item) {
        if (item instanceof DiggerItem && !(item instanceof AxeItem)) {
            return true;
        }
        return PlatformUtils.INSTANCE.items().getIDFrom((Object)item).m_135827_().equals("mobbattle");
    }

    private static float[] getDefaultWeight(Item item) {
        if (defaultZeroWeight.contains(PlatformUtils.INSTANCE.items().getIDFrom((Object)item).toString())) {
            return new float[]{0.0f, 0.0f};
        }
        int weight = 1500;
        float quality = 0.0f;
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            float fullProt = armor.m_40401_().m_7365_(EquipmentSlot.HEAD) + armor.m_40401_().m_7365_(EquipmentSlot.CHEST) + armor.m_40401_().m_7365_(EquipmentSlot.LEGS) + armor.m_40401_().m_7365_(EquipmentSlot.FEET);
            float toughness = armor.m_40401_().m_6651_();
            float averageDurability = (float)(armor.m_40401_().m_7366_(EquipmentSlot.HEAD) + armor.m_40401_().m_7366_(EquipmentSlot.CHEST) + armor.m_40401_().m_7366_(EquipmentSlot.LEGS) + armor.m_40401_().m_7366_(EquipmentSlot.FEET)) / 4.0f;
            if (averageDurability < 0.0f) {
                averageDurability = 0.0f;
            }
            float ench = armor.m_6473_();
            float rep = armor.m_40401_().m_6230_() != null && armor.m_40401_().m_6230_() != Ingredient.f_43901_ ? 0.9f : 1.15f;
            float vanillaMulti = armor.m_40401_() == ArmorMaterials.LEATHER || armor.m_40401_() == ArmorMaterials.GOLD || armor.m_40401_() == ArmorMaterials.CHAIN || armor.m_40401_() == ArmorMaterials.IRON || armor.m_40401_() == ArmorMaterials.DIAMOND || armor.m_40401_() == ArmorMaterials.NETHERITE || armor.m_40401_() == ArmorMaterials.TURTLE ? 0.8f : 1.1f;
            weight = (int)((double)weight - ((double)(fullProt * fullProt) * 2.5 + (double)(toughness * toughness * 12.0f) + (double)averageDurability * 0.9 + (double)ench) * (double)rep * (double)vanillaMulti);
            quality = EquipmentList.defaultQualityFromWeight(weight);
        } else if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            float dmg = 5.0f + sword.m_43299_();
            weight = (int)((double)weight - ((double)(dmg * dmg * 2.0f) + (double)item.m_41462_() * 0.3));
            quality = EquipmentList.defaultQualityFromWeight(weight);
        } else if (item instanceof DiggerItem) {
            ItemStack def = new ItemStack((ItemLike)item);
            double dmg = 5.0 + ItemUtils.damage((ItemStack)def);
            weight = (int)((double)weight - (dmg * dmg * 2.0 + (double)item.m_41462_() * 0.3));
            quality = EquipmentList.defaultQualityFromWeight(weight);
        } else if (item == Items.f_42409_) {
            weight = 1200;
        } else if (item instanceof ShieldItem) {
            weight = 1350;
        } else if (item == Items.f_42448_) {
            weight = 900;
        } else if (item == Items.f_42584_) {
            weight = 1100;
        } else if (item == Items.f_42452_) {
            weight = 1400;
        } else if (item instanceof ThrowablePotionItem) {
            weight = 1050;
        } else if (item instanceof BowItem) {
            BowItem bow = (BowItem)item;
            weight = (int)(1300.0 - (double)bow.m_41462_() * 0.5);
        } else if (item == Items.f_42690_) {
            weight = 1100;
        } else if (item == Blocks.f_50077_.m_5456_()) {
            weight = 800;
        } else if (item == Items.f_42713_) {
            weight = 900;
        } else if (item instanceof CrossbowItem) {
            weight = 1000;
        }
        return new float[]{Math.max(weight, 1), quality};
    }

    private static boolean correctQuality(String itemString) {
        Item item;
        String itemReg = itemString;
        if (itemString.contains("{")) {
            int idx = itemString.indexOf("{");
            itemReg = itemString.substring(0, idx);
        }
        return (item = (Item)PlatformUtils.INSTANCE.items().getFromId(new ResourceLocation(itemReg))) instanceof ArmorItem || item instanceof SwordItem || item instanceof DiggerItem;
    }

    private static float defaultQualityFromWeight(int weight) {
        return (float)(1000 - weight) / 125.0f;
    }

    static {
        defaultZeroWeight = Lists.newArrayList((Object[])new String[]{"techguns:nucleardeathray", "techguns:grenadelauncher", "techguns:tfg", "techguns:guidedmissilelauncher", "techguns:rocketlauncher"});
    }

    public static class WeightedItemstackList {
        private final List<WeightedItemstack> list = new ArrayList<WeightedItemstack>();
        private int totalWeight;
        private float lastModifier = -1.0f;

        public WeightedItemstackList(WeightedItemstack ... item) {
            this.list.addAll(Arrays.asList(item));
            this.list.removeIf(w -> w.item == null);
        }

        public int getTotalWeight(float modifier) {
            if (this.lastModifier != modifier) {
                this.lastModifier = modifier;
                this.calculateTotalWeight(this.lastModifier);
            }
            return this.totalWeight;
        }

        private void calculateTotalWeight(float modifier) {
            this.totalWeight = this.list.stream().mapToInt(entry -> entry.getWeight(modifier)).sum();
        }

        public void finishList() {
            this.list.removeIf(w -> w.weight == 0 && w.quality <= 0.0f || this.modBlacklist(w.item.getItem()));
        }

        private boolean modBlacklist(Item item) {
            if (Config.CommonConfig.equipmentModWhitelist) {
                for (String s : Config.CommonConfig.equipmentModBlacklist) {
                    if (!PlatformUtils.INSTANCE.items().getIDFrom((Object)item).m_135827_().equals(s)) continue;
                    return false;
                }
                return true;
            }
            for (String s : Config.CommonConfig.equipmentModBlacklist) {
                if (!PlatformUtils.INSTANCE.items().getIDFrom((Object)item).m_135827_().equals(s)) continue;
                return true;
            }
            return false;
        }

        public WeightedItemstackList add(WeightedItemstack item) {
            if (item.item == null) {
                return this;
            }
            this.list.remove(item);
            this.list.add(item);
            return this;
        }

        public String toString() {
            return String.format("TotalWeight: %d ; [%s]", this.totalWeight, this.list.toString());
        }
    }

    public static class WeightedItemstack
    implements Comparable<WeightedItemstack> {
        private final ExtendedItemStackWrapper item;
        public final String configString;
        private final int weight;
        private final float quality;

        public WeightedItemstack(Item item, int itemWeight, float quality) {
            this.weight = itemWeight;
            this.quality = quality;
            this.item = new ExtendedItemStackWrapper(PlatformUtils.INSTANCE.items().getIDFrom((Object)item).toString());
            this.configString = PlatformUtils.INSTANCE.items().getIDFrom((Object)item).toString();
        }

        public WeightedItemstack(String item, int itemWeight, float quality, List<String> errors) {
            Item it;
            this.weight = itemWeight;
            this.quality = quality;
            this.configString = item;
            String itemReg = item;
            CompoundTag nbt = null;
            if (item.contains("{")) {
                int idx = item.indexOf("{");
                itemReg = item.substring(0, idx);
                try {
                    nbt = TagParser.m_129359_((String)item.substring(idx));
                }
                catch (CommandSyntaxException e) {
                    ImprovedMobs.logger.error("Error reading nbt from config {}", (Object)item.substring(idx));
                    e.printStackTrace();
                }
            }
            if ((it = (Item)PlatformUtils.INSTANCE.items().getFromId(new ResourceLocation(itemReg))) == null || it == Items.f_41852_ && !itemReg.equals("minecraft:air")) {
                errors.add(itemReg);
                this.item = null;
            } else {
                this.item = new ExtendedItemStackWrapper(itemReg).setNBT(nbt);
            }
        }

        public ItemStack getItem() {
            return this.item.getStack();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof WeightedItemstack) {
                WeightedItemstack oth = (WeightedItemstack)other;
                if (this.item.getItem() != oth.item.getItem()) {
                    return false;
                }
                if (this.item.getTag() == null && oth.item.getTag() != null) {
                    return false;
                }
                return this.item.getTag() == null || this.item.getTag().equals((Object)oth.item.getTag());
            }
            return false;
        }

        public int hashCode() {
            return (PlatformUtils.INSTANCE.items().getIDFrom((Object)this.item.getItem()) + (this.item.getTag() != null ? this.item.getTag().toString() : "")).hashCode();
        }

        @Override
        public int compareTo(WeightedItemstack o) {
            return PlatformUtils.INSTANCE.items().getIDFrom((Object)this.item.getItem()).toString().compareTo(PlatformUtils.INSTANCE.items().getIDFrom((Object)o.item.getItem()).toString());
        }

        public String toString() {
            return String.format("Item: %s; Weight: %d", PlatformUtils.INSTANCE.items().getIDFrom((Object)this.item.getItem()), this.weight);
        }

        public int getWeight(float modifier) {
            return Math.max(this.weight + Mth.m_14143_((float)(modifier * this.quality)), 0);
        }
    }

    public static class InvalidItemNameException
    extends Exception {
        private static final long serialVersionUID = -6736627280613384759L;

        public InvalidItemNameException(String message) {
            super(message);
        }
    }
}

