/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.tenshilib.api.config.IConfigListValue;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BreakableBlocks
implements IConfigListValue<BreakableBlocks> {
    private final Set<String> blocks = new HashSet<String>();
    private List<String> configString = new ArrayList<String>();
    private final Set<HolderSet<Block>> tags = new HashSet<HolderSet<Block>>();
    private boolean initialized;

    public boolean canBreak(BlockState state, BlockPos pos, BlockGetter level, @Nullable Entity entity, CollisionContext ctx) {
        Mob mob;
        if (!this.initialized) {
            this.initialize();
        }
        if (!Config.CommonConfig.idleBreak && entity instanceof Mob && (mob = (Mob)entity).m_5448_() == null) {
            return false;
        }
        if (state.m_60742_(level, pos, ctx).m_83281_()) {
            return false;
        }
        if (!Config.CommonConfig.breakTileEntities && state.m_155947_()) {
            return false;
        }
        if (Config.CommonConfig.breakingAsBlacklist) {
            return this.tags.stream().noneMatch(arg_0 -> ((BlockState)state).m_204341_(arg_0)) && !this.blocks.contains(PlatformUtils.INSTANCE.blocks().getIDFrom((Object)state.m_60734_()).toString()) && !this.blocks.contains(PlatformUtils.INSTANCE.blocks().getIDFrom((Object)state.m_60734_()).m_135827_());
        }
        return this.tags.stream().anyMatch(arg_0 -> ((BlockState)state).m_204341_(arg_0)) || this.blocks.contains(PlatformUtils.INSTANCE.blocks().getIDFrom((Object)state.m_60734_()).m_135827_()) || this.blocks.contains(PlatformUtils.INSTANCE.blocks().getIDFrom((Object)state.m_60734_()).toString());
    }

    public BreakableBlocks readFromString(List<String> arr) {
        this.blocks.clear();
        this.configString = arr;
        this.initialized = false;
        return this;
    }

    private void initialize() {
        this.initialized = true;
        HashSet<String> blackList = new HashSet<String>();
        HashSet<HolderSet<Block>> blackListTags = new HashSet<HolderSet<Block>>();
        for (String s : this.configString) {
            if (s.startsWith("!")) {
                BreakableBlocks.addBlocks(s.substring(1), blackList, blackListTags);
                continue;
            }
            BreakableBlocks.addBlocks(s, this.blocks, this.tags);
        }
        this.blocks.removeAll(blackList);
        this.tags.removeAll(blackListTags);
    }

    private static void addBlocks(String s, Set<String> list, Set<HolderSet<Block>> tags) {
        if (s.contains(":")) {
            Optional tag = Registry.f_122824_.m_203431_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(s)));
            if (tag.isPresent()) {
                tags.add((HolderSet<Block>)((HolderSet)tag.get()));
            } else {
                list.add(s);
            }
        } else {
            Class<?> clss = null;
            try {
                clss = Class.forName("net.minecraft.block." + s);
            }
            catch (ClassNotFoundException e) {
                try {
                    clss = Class.forName(s);
                }
                catch (ClassNotFoundException e1) {
                    ImprovedMobs.logger.error("Couldn't find class for " + s);
                }
            }
            if (clss != null) {
                for (Block block : PlatformUtils.INSTANCE.blocks().getIterator()) {
                    if (!clss.isInstance(block)) continue;
                    list.add(PlatformUtils.INSTANCE.blocks().getIDFrom((Object)block).toString());
                }
            }
        }
    }

    public List<String> writeToString() {
        return this.configString;
    }

    public static String use() {
        return "Usage: <registry name;classname;tag;namespace> put \"!\" infront to exclude blocks";
    }
}

