/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai.util;

import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AIUtils {
    public static void setHeadingToPosition(ThrowableProjectile e, double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 dir = new Vec3(x - e.m_20185_(), y - e.m_20186_(), z - e.m_20189_()).m_82490_((double)(1.0f / velocity));
        e.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, velocity, inaccuracy);
    }

    public static void attackWithArrows(Mob entity, LivingEntity target, float distanceFactor) {
        ItemStack itemstack = entity.m_6298_(entity.m_21120_(ProjectileUtil.m_37297_((LivingEntity)entity, (Item)Items.f_42411_)));
        AbstractArrow abstractarrowentity = ProjectileUtil.m_37300_((LivingEntity)entity, (ItemStack)itemstack, (float)distanceFactor);
        if (entity.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = CrossPlatformStuff.INSTANCE.customBowArrow((BowItem)entity.m_21205_().m_41720_(), abstractarrowentity);
        }
        double d0 = target.m_20185_() - entity.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
        double d2 = target.m_20189_() - entity.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - entity.f_19853_.m_46791_().m_19028_() * 4));
        entity.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (entity.m_217043_().m_188501_() * 0.4f + 0.8f));
        entity.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    public static void tridentAttack(Mob entity, LivingEntity target) {
        ThrownTrident tridententity = new ThrownTrident(entity.f_19853_, (LivingEntity)entity, new ItemStack((ItemLike)Items.f_42713_));
        double d0 = target.m_20185_() - entity.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - tridententity.m_20186_();
        double d2 = target.m_20189_() - entity.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        tridententity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - entity.f_19853_.m_46791_().m_19028_() * 4));
        entity.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (entity.m_217043_().m_188501_() * 0.4f + 0.8f));
        entity.f_19853_.m_7967_((Entity)tridententity);
    }

    public static boolean tryPlaceLava(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Material material = state.m_60767_();
        boolean flag = !material.m_76333_();
        boolean flag1 = state.m_60767_().m_76336_();
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        if (!(state.m_60795_() || flag || flag1)) {
            return false;
        }
        if (!level.f_46443_ && (flag || flag1) && !material.m_76332_()) {
            level.m_46961_(pos, true);
        }
        level.m_5594_(null, pos, SoundEvents.f_11780_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_7731_(pos, (BlockState)Blocks.f_49991_.m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(1)), 11);
        return true;
    }

    public static boolean isBadPotion(ItemStack stack) {
        for (MobEffectInstance effect : PotionUtils.m_43547_((ItemStack)stack)) {
            if (effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            return true;
        }
        return false;
    }

    public static void applyPotion(ThrownPotion entity, List<MobEffectInstance> p_213888_1_, @Nullable Entity p_213888_2_) {
        AABB axisalignedbb = entity.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = entity.f_19853_.m_45976_(LivingEntity.class, axisalignedbb);
        for (LivingEntity livingentity : list) {
            double d0;
            if (entity.m_37282_() instanceof Mob && !livingentity.equals((Object)((Mob)entity.m_37282_()).m_5448_()) || !livingentity.m_5801_() || !((d0 = entity.m_20280_((Entity)livingentity)) < 16.0)) continue;
            double d1 = 1.0 - Math.sqrt(d0) / 4.0;
            if (livingentity == p_213888_2_) {
                d1 = 1.0;
            }
            for (MobEffectInstance effectinstance : p_213888_1_) {
                MobEffect effect = effectinstance.m_19544_();
                if (effect.m_8093_()) {
                    effect.m_19461_((Entity)entity, entity.m_37282_(), livingentity, effectinstance.m_19564_(), d1);
                    continue;
                }
                int i = (int)(d1 * (double)effectinstance.m_19557_() + 0.5);
                if (i <= 20) continue;
                livingentity.m_7292_(new MobEffectInstance(effect, i, effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
            }
        }
    }
}

