/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai;

import io.github.flemmli97.improvedmobs.ai.util.ItemAI;
import io.github.flemmli97.improvedmobs.ai.util.ItemAITasks;
import io.github.flemmli97.improvedmobs.utils.EntityFlags;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.apache.commons.lang3.tuple.Pair;

public class ItemUseGoal
extends Goal {
    private final Mob living;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private ItemAI ai;
    private InteractionHand hand;
    private ItemStack stackMain;
    private ItemStack stackOff;

    public ItemUseGoal(Mob entity, float maxDistance) {
        this.living = entity;
        float follow = maxDistance;
        if (entity.m_21051_(Attributes.f_22277_) != null) {
            follow = (float)entity.m_21051_(Attributes.f_22277_).m_22135_();
        }
        maxDistance = Math.min(follow - 3.0f, maxDistance);
        this.maxAttackDistance = maxDistance * maxDistance;
    }

    public boolean m_8036_() {
        LivingEntity target = this.living.m_5448_();
        if (target == null || !target.m_6084_() || target.m_217043_().m_188503_(10) != 0) {
            return false;
        }
        Pair<ItemAI, InteractionHand> pair = ItemAITasks.getAI(this.living);
        this.ai = (ItemAI)pair.getKey();
        this.hand = (InteractionHand)pair.getValue();
        return this.ai != null;
    }

    public void m_8056_() {
        this.m_7021_(this.ai.type() != ItemAI.ItemType.NONSTRAFINGITEM ? EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK) : EnumSet.noneOf(Goal.Flag.class));
        this.stackMain = this.living.m_21205_();
        this.stackOff = this.living.m_21206_();
    }

    public boolean m_8045_() {
        LivingEntity target = this.living.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.stackMain != this.living.m_21205_() || this.stackOff != this.living.m_21206_()) {
            Pair<ItemAI, InteractionHand> pair = ItemAITasks.getAI(this.living);
            this.ai = (ItemAI)pair.getKey();
            this.hand = (InteractionHand)pair.getValue();
        }
        return this.ai != null;
    }

    public void m_8041_() {
        this.seeTime = 0;
        this.attackTime = -1;
        this.living.m_5810_();
        this.ai = null;
        this.stackMain = null;
        this.stackOff = null;
        this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
    }

    public void m_8037_() {
        if (EntityFlags.get((Entity)this.living).isShieldDisabled() && this.living.m_21120_(this.hand).m_41780_() == UseAnim.BLOCK) {
            return;
        }
        LivingEntity target = this.living.m_5448_();
        if (target != null) {
            boolean flag = this.living.m_21574_().m_148306_((Entity)target);
            if (this.ai.type() == ItemAI.ItemType.STRAFINGITEM) {
                this.moveStrafing(target, flag);
            } else if (this.ai.type() == ItemAI.ItemType.STANDING) {
                this.moveToRange(target, flag);
            }
            if (this.living.m_6117_() || !this.ai.useHand()) {
                if (!flag && this.seeTime < -60) {
                    this.living.m_5810_();
                    this.ai.onReset(this.living, this.hand);
                } else if (flag) {
                    if (this.ai.useHand()) {
                        int i = this.living.m_21252_();
                        if (i >= this.ai.maxUseCount(this.living, this.hand)) {
                            this.living.m_21253_();
                            this.ai.attack(this.living, target, this.hand);
                            this.attackTime = this.ai.cooldown();
                        }
                    } else if (--this.attackTime <= 0) {
                        this.ai.attack(this.living, target, this.hand);
                        this.living.m_21253_();
                        this.attackTime = this.ai.cooldown();
                    }
                }
            } else if (--this.attackTime < 0 && this.seeTime >= -60) {
                this.living.m_6672_(this.hand);
            }
        }
    }

    private void moveStrafing(LivingEntity target, boolean canSee) {
        boolean flag1;
        double dist = this.living.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        boolean bl = flag1 = this.seeTime > 0;
        if (canSee != flag1) {
            this.seeTime = 0;
        }
        this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
        if (dist <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.living.m_21573_().m_26573_();
            ++this.strafingTime;
        } else {
            this.living.m_21573_().m_5624_((Entity)target, 1.0);
            this.strafingTime = -1;
        }
        if (this.strafingTime >= 20) {
            if ((double)this.living.m_217043_().m_188501_() < 0.3) {
                boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)this.living.m_217043_().m_188501_() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            if (dist > (double)this.maxAttackDistance * 0.75) {
                this.strafingBackwards = false;
            } else if (dist < (double)this.maxAttackDistance * 0.25) {
                this.strafingBackwards = true;
            }
            this.living.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            this.living.m_21391_((Entity)target, 30.0f, 30.0f);
        } else {
            this.living.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
    }

    private void moveToRange(LivingEntity target, boolean canSee) {
        double dist = this.living.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (dist <= (double)this.maxAttackDistance && this.seeTime >= 5) {
            this.living.m_21573_().m_26573_();
        } else {
            this.living.m_21573_().m_5624_((Entity)target, 1.0);
        }
        this.living.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
    }
}

