/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.util;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.widget.copied.GridWidget;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtil {
    public static final int GRID_HORZ_PADDING = 4;
    public static final int GRID_VERT_PADDING = 2;
    public static final double STOP_SOUND_DISTANCE = 10.0;
    public static final Lazy<Boolean> ON_QWERTY = Lazy.of(() -> {
        String qwerty = "QWERTY";
        InputConstants.Key[] keyRow = InstrumentKeyMappings.GRID_INSTRUMENT_MAPPINGS[0];
        for (int i = 0; i < "QWERTY".length(); ++i) {
            if (ClientUtil.charEquals("QWERTY".charAt(i), keyRow[i].m_84875_().m_130668_(1).charAt(0))) continue;
            return false;
        }
        return true;
    });

    public static boolean stopMusicIfClose(double playDistSqr) {
        if (((Boolean)ModClientConfigs.STOP_MUSIC_ON_PLAY.get()).booleanValue() && playDistSqr < Mth.m_144952_((double)10.0)) {
            Minecraft.m_91087_().m_91397_().m_120186_();
            return true;
        }
        return false;
    }

    public static boolean stopMusicIfClose(BlockPos pos) {
        return ClientUtil.stopMusicIfClose(pos.m_203193_((Position)Minecraft.m_91087_().f_91074_.m_20182_()));
    }

    private static boolean charEquals(char char1, char char2) {
        return Character.toLowerCase(char1) == Character.toLowerCase(char2);
    }

    public static Point getInitCenter(int initX, int initY, int initSize, int currSize) {
        return new Point((initSize - currSize) / 2 + initX, (initSize - currSize) / 2 + initY);
    }

    public static void setShaderColor(Color color, float alpha) {
        RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)alpha);
    }

    public static void setShaderColor(Color color) {
        ClientUtil.setShaderColor(color, 1.0f);
    }

    public static void resetShaderColor() {
        ClientUtil.setShaderColor(Color.WHITE);
    }

    public static void displaySprite(ResourceLocation location) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
    }

    public static GridWidget createSettingsGrid() {
        GridWidget grid = new GridWidget();
        grid.defaultCellSetting().padding(4, 2).alignVertically(0.5f).alignHorizontallyCenter();
        return grid;
    }

    public static void alignGrid(GridWidget grid, int screenWidth, int screenHeight) {
        grid.pack();
        grid.setX((screenWidth - grid.m_5711_()) / 2);
        grid.setY(30);
        grid.pack();
    }

    public static int lowerButtonsY(int desiredY, int desiredHeight, int screenHeight) {
        return Math.min(desiredY + desiredHeight + 50, screenHeight - 20 - 15);
    }
}

