/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.widget.copied.AbstractContainerWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractInstrumentOptionsScreen
extends Screen {
    public final Optional<InstrumentScreen> instrumentScreen;
    public final Screen lastScreen;
    public final boolean isOverlay;
    protected final HashMap<String, Runnable> appliedOptions = new HashMap();
    private static final Logger LOGGER = LogUtils.getLogger();

    public AbstractInstrumentOptionsScreen(Component pTitle, InstrumentScreen instrumentScreen, Screen lastScreen) {
        super(pTitle);
        this.instrumentScreen = Optional.ofNullable(instrumentScreen);
        this.lastScreen = lastScreen;
        this.isOverlay = instrumentScreen != null;
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, Optional<InstrumentScreen> instrumentScreen, Screen lastScreen) {
        this(pTitle, (InstrumentScreen)instrumentScreen.orElse(null), lastScreen);
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, InstrumentScreen instrumentScreen) {
        this(pTitle, instrumentScreen, null);
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, Optional<InstrumentScreen> instrumentScreen) {
        this(pTitle, instrumentScreen, null);
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, Screen prevScreen) {
        this(pTitle, Optional.empty(), prevScreen);
    }

    public int getSmallButtonWidth() {
        return 190;
    }

    public int getBigButtonWidth() {
        return (this.getSmallButtonWidth() + 4) * 2;
    }

    public int getButtonHeight() {
        return 20;
    }

    public void m_6305_(PoseStack stack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(stack);
        AbstractInstrumentOptionsScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)Color.WHITE.getRGB());
        super.m_6305_(stack, pMouseX, pMouseY, pPartialTick);
        this.f_169369_.forEach(renderable -> this.renderTooltips((Widget)renderable, stack, pMouseX, pMouseY));
    }

    private void renderTooltips(Widget widget, PoseStack stack, int pMouseX, int pMouseY) {
        AbstractWidget aWidget;
        if (widget instanceof AbstractContainerWidget) {
            AbstractContainerWidget container = (AbstractContainerWidget)widget;
            container.getContainedChildren().forEach(child -> this.renderTooltips((Widget)child, stack, pMouseX, pMouseY));
            return;
        }
        if (!(widget instanceof AbstractWidget) || !((aWidget = (AbstractWidget)widget) instanceof TooltipAccessor)) {
            return;
        }
        if (aWidget.m_198029_()) {
            this.m_96617_(stack, ((TooltipAccessor)aWidget).m_141932_(), pMouseX, pMouseY);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        this.instrumentScreen.ifPresent(screen -> {
            if (screen.isKeyConsumed(pKeyCode, pScanCode)) {
                screen.m_7933_(pKeyCode, pScanCode, pModifiers);
            }
        });
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        this.instrumentScreen.ifPresent(screen -> {
            if (screen.isKeyConsumed(pKeyCode, pScanCode)) {
                screen.m_7920_(pKeyCode, pScanCode, pModifiers);
            }
        });
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    protected <T> OptionInstance.TooltipSupplier<T> tooltip(Function<T, Component> text) {
        return value -> this.f_96541_.f_91062_.m_92923_((FormattedText)text.apply(value), 200);
    }

    public boolean m_7043_() {
        return !this.isOverlay;
    }

    public void m_7379_() {
        this.saveOptions();
        if (this.isOverlay) {
            super.m_7379_();
            if (this.lastScreen != null) {
                this.f_96541_.pushGuiLayer(this.lastScreen);
            }
        } else if (this.lastScreen != null) {
            this.f_96541_.m_91152_(this.lastScreen);
        } else {
            super.m_7379_();
        }
    }

    protected void queueToSave(String optionKey, Runnable saveRunnable) {
        String modId = this.modId();
        if (modId != null) {
            optionKey = modId + ":" + (String)optionKey;
        }
        if (this.appliedOptions.containsKey(optionKey)) {
            this.appliedOptions.replace((String)optionKey, saveRunnable);
        } else {
            this.appliedOptions.put((String)optionKey, saveRunnable);
        }
    }

    public void saveOptions() {
        if (this.appliedOptions.isEmpty()) {
            return;
        }
        this.appliedOptions.values().forEach(Runnable::run);
        ModClientConfigs.CONFIGS.save();
        LOGGER.info("Successfully saved " + this.appliedOptions.size() + " option(s) for " + this.f_96539_.getString());
    }

    public String modId() {
        return this.instrumentScreen.map(InstrumentScreen::getModId).orElse(null);
    }
}

