/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.midi;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.SliderButton;
import com.cstav.genshinstrument.client.gui.widget.copied.GridWidget;
import com.cstav.genshinstrument.client.gui.widget.copied.SpacerWidget;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.util.CommonUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MidiOptionsScreen
extends AbstractInstrumentOptionsScreen {
    public static final int MIN_OCTAVE_SHIFT = -5;
    public static final int MAX_OCTAVE_SHIFT = 5;
    public static final int MIN_MIDI_CHANNEL = 0;
    public static final int MAX_MIDI_CHANNEL = 15;

    public MidiOptionsScreen(Component pTitle, Screen prevScreen, InstrumentScreen instrumentScreen) {
        super(pTitle, instrumentScreen, prevScreen);
    }

    public MidiOptionsScreen(Component pTitle, Screen prevScreen, Optional<InstrumentScreen> instrumentScreen) {
        super(pTitle, instrumentScreen, prevScreen);
    }

    protected void m_7856_() {
        GridWidget grid = new GridWidget();
        grid.defaultCellSetting().padding(4, 2).alignVertically(0.5f).alignHorizontallyCenter();
        this.initOptionsGrid(grid, grid.createRowHelper(2));
        ClientUtil.alignGrid(grid, this.f_96543_, this.f_96544_);
        this.m_142416_((GuiEventListener)grid);
        Button doneBtn = new Button((this.f_96543_ - 150) / 2, ClientUtil.lowerButtonsY(grid.f_93621_, grid.m_93694_(), this.f_96544_), 150, this.getButtonHeight(), CommonComponents.f_130655_, btn -> this.m_7379_());
        this.m_142416_((GuiEventListener)doneBtn);
    }

    protected void initDeviceSection(GridWidget grid, GridWidget.RowHelper rowHelper) {
        CycleButton midiEnabled = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.MIDI_ENABLED.get())).m_168936_(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.midiEnabled"), this::onMidiEnabledChanged);
        rowHelper.addChild(midiEnabled, 2);
        SliderButton inputSensitivity = new SliderButton(this.getSmallButtonWidth(), (Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get(), 0.0, 1.0){
            private static final DecimalFormat D_FORMAT = new DecimalFormat("0.0");

            @Override
            public Component m_6035_() {
                return Component.m_237115_((String)"button.genshinstrument.inputSensitivity").m_130946_(": " + D_FORMAT.format((Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get() * 100.0) + "%");
            }

            protected void m_5697_() {
                MidiOptionsScreen.this.onMidiSensitivityChanged(this, this.f_93577_);
            }
        };
        CycleButton fixedTouch = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.FIXED_TOUCH.get())).m_232498_(this.tooltip(value -> Component.m_237115_((String)"button.genshinstrument.fixedTouch.tooltip"))).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.fixedTouch"), (btn, val) -> {
            this.onFixedTouchChanged((CycleButton<Boolean>)btn, (boolean)val);
            inputSensitivity.f_93623_ = val == false;
        });
        inputSensitivity.f_93623_ = (Boolean)ModClientConfigs.FIXED_TOUCH.get() == false;
        rowHelper.addChild(fixedTouch);
        rowHelper.addChild(inputSensitivity);
        MidiController.reloadDevices();
        CycleButton midiDevice = CycleButton.m_168894_(value -> {
            if (value == -1) {
                return Component.m_237115_((String)"button.none");
            }
            return Component.m_237113_((String)MidiController.infoAsString(MidiController.getInfoFromIndex(value)));
        }).m_232502_(MidiOptionsScreen.getMidiDevicesRange()).m_168948_((Object)((Integer)ModClientConfigs.MIDI_DEVICE_INDEX.get())).m_168936_(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.midiDevice"), this::onMidiDeviceChanged);
        rowHelper.addChild(midiDevice, 2);
    }

    protected void initThatOtherSection(GridWidget grid, GridWidget.RowHelper rowHelper) {
        boolean canInstrumentOverflow = this.instrumentScreen.map(screen -> screen.midiReceiver.allowMidiOverflow()).orElse(false);
        if (canInstrumentOverflow) {
            CycleButton extendOctaves = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.EXTEND_OCTAVES.get())).m_232498_(this.tooltip(value -> Component.m_237115_((String)"button.genshinstrument.extendOctaves.tooltip"))).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.extendOctaves"), this::onExtendOctavesChanged);
            rowHelper.addChild(extendOctaves);
        }
        SliderButton octaveShift = new SliderButton(canInstrumentOverflow ? this.getSmallButtonWidth() : this.getBigButtonWidth(), ((Integer)ModClientConfigs.OCTAVE_SHIFT.get()).intValue(), -5.0, 5.0){

            @Override
            public Component m_6035_() {
                return Component.m_237115_((String)"button.genshinstrument.midiOctaveShift").m_130946_(": " + ModClientConfigs.OCTAVE_SHIFT.get());
            }

            protected void m_5697_() {
                MidiOptionsScreen.this.onOctaveShiftChanged(this, (int)this.getValueClamped());
            }
        };
        rowHelper.addChild(octaveShift, canInstrumentOverflow ? 1 : 2);
        SliderButton midiChannel = new SliderButton(this.getSmallButtonWidth(), ((Integer)ModClientConfigs.MIDI_CHANNEL.get()).intValue(), 0.0, 15.0){

            @Override
            public Component m_6035_() {
                return Component.m_237115_((String)"button.genshinstrument.midiChannel").m_130946_(": " + ModClientConfigs.MIDI_CHANNEL.get());
            }

            protected void m_5697_() {
                MidiOptionsScreen.this.onMidiChannelChanged(this, (int)this.getValueClamped());
            }
        };
        CycleButton acceptAllChannels = CycleButton.m_168896_((Component)CommonComponents.f_130653_, (Component)CommonComponents.f_130654_).m_168948_((Object)((Boolean)ModClientConfigs.ACCEPT_ALL_CHANNELS.get())).m_168936_(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.m_237115_((String)"button.genshinstrument.acceptAllChannels"), (btn, val) -> {
            this.onAcceptAllChannelsChanged((CycleButton<Boolean>)btn, (boolean)val);
            midiChannel.f_93623_ = val == false;
        });
        midiChannel.f_93623_ = (Boolean)acceptAllChannels.m_168883_() == false;
        rowHelper.addChild(acceptAllChannels);
        rowHelper.addChild(midiChannel);
    }

    protected void initOptionsGrid(GridWidget grid, GridWidget.RowHelper rowHelper) {
        this.initDeviceSection(grid, rowHelper);
        rowHelper.addChild(SpacerWidget.height(7), 2);
        this.initThatOtherSection(grid, rowHelper);
    }

    public static List<Integer> getMidiDevicesRange() {
        return IntStream.range(-1, MidiController.DEVICES.size()).boxed().toList();
    }

    protected void onMidiEnabledChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.MIDI_ENABLED.set((Object)value);
        MidiController.loadByConfigs();
    }

    protected void onMidiDeviceChanged(CycleButton<Integer> button, int value) {
        ModClientConfigs.MIDI_DEVICE_INDEX.set((Object)value);
        MidiController.loadByConfigs();
    }

    protected void onExtendOctavesChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.EXTEND_OCTAVES.set((Object)value);
    }

    protected void onOctaveShiftChanged(AbstractSliderButton button, int value) {
        if ((Integer)ModClientConfigs.OCTAVE_SHIFT.get() != value) {
            ModClientConfigs.OCTAVE_SHIFT.set((Object)value);
        }
    }

    protected void onFixedTouchChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.FIXED_TOUCH.set((Object)value);
    }

    protected void onMidiSensitivityChanged(AbstractSliderButton button, double value) {
        value = CommonUtil.round(value, 3);
        if ((Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get() != value) {
            ModClientConfigs.MIDI_IN_SENSITIVITY.set((Object)value);
        }
    }

    protected void onAcceptAllChannelsChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.ACCEPT_ALL_CHANNELS.set((Object)value);
    }

    protected void onMidiChannelChanged(AbstractSliderButton button, int value) {
        if ((Integer)ModClientConfigs.MIDI_CHANNEL.get() != value) {
            ModClientConfigs.MIDI_CHANNEL.set((Object)value);
        }
    }
}

