/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButtonRenderer;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteRing;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation.HeldNoteAnimationController;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation.NoteAnimationController;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held.HeldNoteRing;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held.IHoldableNoteButton;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeldNoteButtonRenderer
extends NoteButtonRenderer {
    private static final int RING_ADDITION_INTERVAL = 4;
    private float ringTimeAlive = 0.0f;

    public HeldNoteButtonRenderer(IHoldableNoteButton noteButton, Supplier<ResourceLocation> noteTextureProvider) {
        super((NoteButton)((Object)noteButton), noteTextureProvider);
    }

    private IHoldableNoteButton getHeldBtn() {
        return (IHoldableNoteButton)((Object)this.noteButton);
    }

    @Override
    public void render(PoseStack stack, int mouseX, int mouseY, float partialTick, InstrumentThemeLoader themeLoader) {
        if (this.getHeldBtn().isHeld()) {
            this.ringTimeAlive += partialTick;
            if (this.ringTimeAlive > 4.0f) {
                this.addRing(true);
                this.ringTimeAlive = 0.0f;
            }
        } else {
            this.ringTimeAlive = 0.0f;
        }
        super.render(stack, mouseX, mouseY, partialTick, themeLoader);
    }

    @Override
    public void playNoteAnimation(boolean isForeign) {
        this.foreignPlaying = isForeign;
        this.playHold();
        this.addRing();
    }

    @Override
    public void addRing() {
        this.addRing(false);
    }

    public void addRing(boolean isConsecutive) {
        HeldNoteRing ring = new HeldNoteRing(this.noteButton, this.foreignPlaying, isConsecutive);
        this.rings.add(ring);
        ((NoteRing)ring).playAnim();
    }

    @Override
    protected NoteAnimationController initNoteAnimation() {
        return new HeldNoteAnimationController(0.075, 4.5, this.noteButton);
    }

    private HeldNoteAnimationController noteAnimation() {
        return (HeldNoteAnimationController)this.noteAnimation;
    }

    public void playRelease() {
        this.noteAnimation().playReleased(this.foreignPlaying);
    }

    public void playHold() {
        this.noteAnimation().playHold(this.foreignPlaying);
    }
}

