/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.projectile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSpawnData;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.EverlastingAllegiance;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.IndirectEpicFightDamageSource;
import yesman.epicfight.world.damagesource.SourceTags;
import yesman.epicfight.world.damagesource.StunType;

public class ThrownTridentPatch
extends ProjectilePatch<ThrownTrident> {
    private boolean innateActivated;
    private int returnTick;
    private float independentXRotO;
    private float independentXRot;
    public float renderXRot;
    public float renderXRotO;
    public float renderYRot;
    public float renderYRotO;

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        if (this.innateActivated) {
            SPSpawnData packet = new SPSpawnData(((ThrownTrident)this.original).m_19879_());
            packet.getBuffer().writeInt(this.returnTick);
            packet.getBuffer().writeInt(((ThrownTrident)this.original).f_19797_);
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer);
        }
    }

    @Override
    public void processSpawnData(ByteBuf buf) {
        this.innateActivated = true;
        this.returnTick = buf.readInt();
        ((ThrownTrident)this.original).f_19797_ = buf.readInt();
    }

    @Override
    protected void setMaxStrikes(ThrownTrident projectileEntity, int maxStrikes) {
        projectileEntity.m_36767_((byte)(maxStrikes - 1));
    }

    @Override
    public void onJoinWorld(ThrownTrident projectileEntity, EntityJoinLevelEvent event) {
        super.onJoinWorld(projectileEntity, event);
        if (!this.isLogicalClient()) {
            SkillContainer container;
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch(projectileEntity.m_37282_(), ServerPlayerPatch.class);
            if (playerpatch != null && (container = playerpatch.getSkill(SkillSlots.WEAPON_INNATE)).getSkill() instanceof EverlastingAllegiance) {
                EverlastingAllegiance.setThrownTridentEntityId((ServerPlayer)playerpatch.getOriginal(), container, projectileEntity.m_19879_());
            }
            this.armorNegation = 20.0f;
        }
    }

    public void tickEnd() {
        if (!this.isLogicalClient()) {
            SkillContainer container;
            ServerPlayerPatch playerpatch;
            if (((ThrownTrident)this.original).f_37556_ && (playerpatch = EpicFightCapabilities.getEntityPatch(((ThrownTrident)this.original).m_37282_(), ServerPlayerPatch.class)) != null && (container = playerpatch.getSkill(SkillSlots.WEAPON_INNATE)).getSkill() instanceof EverlastingAllegiance && EverlastingAllegiance.getThrownTridentEntityId(container) > -1) {
                EverlastingAllegiance.setThrownTridentEntityId((ServerPlayer)playerpatch.getOriginal(), container, -1);
            }
            if (this.innateActivated) {
                List entities = ((ThrownTrident)this.original).f_19853_.m_45933_(this.original, ((ThrownTrident)this.original).m_20191_().m_82377_(1.0, 1.0, 1.0));
                EpicFightDamageSource source = new IndirectEpicFightDamageSource("trident", ((ThrownTrident)this.original).m_37282_(), this.original, StunType.HOLD).addTag(SourceTags.WEAPON_INNATE).addExtraDamage(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0])).setDamageModifier(ValueModifier.multiplier(1.4f)).setArmorNegation(30.0f);
                for (Entity entity : entities) {
                    if (entity.m_7306_(((ThrownTrident)this.original).m_37282_())) continue;
                    float f = 8.0f;
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingentity = (LivingEntity)entity;
                    if (!entity.m_6469_(source.cast(), f += EnchantmentHelper.m_44833_((ItemStack)((ThrownTrident)this.original).f_37555_, (MobType)livingentity.m_6336_()))) continue;
                    entity.m_5496_((SoundEvent)EpicFightSounds.BLADE_HIT.get(), 1.0f, 1.0f);
                    ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)((HitParticleType)((Object)EpicFightParticles.HIT_BLADE.get())), entity.m_20182_().f_82479_, entity.m_20182_().f_82480_ + (double)entity.m_20206_() * 0.5, entity.m_20182_().f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
        if (this.innateActivated) {
            int elapsedTicks = Math.max(((ThrownTrident)this.original).f_19797_ - this.returnTick - 10, 0);
            Vec3 toOwner = ((ThrownTrident)this.original).m_37282_().m_146892_().m_82546_(((ThrownTrident)this.original).m_20182_());
            double length = toOwner.m_82553_();
            double speed = Math.min(Math.pow(elapsedTicks, 2.0) * 5.0E-4 + Math.abs((double)elapsedTicks * 0.05), Math.min(10.0, length));
            Vec3 toMaster = toOwner.m_82541_().m_82490_(speed);
            ((ThrownTrident)this.original).m_20256_(new Vec3(0.0, 0.0, 0.0));
            Vec3 pos = ((ThrownTrident)this.original).m_20182_();
            ((ThrownTrident)this.original).m_6034_(pos.f_82479_ + toMaster.f_82479_, pos.f_82480_ + toMaster.f_82480_, pos.f_82481_ + toMaster.f_82481_);
            ((ThrownTrident)this.original).m_146926_(0.0f);
            ((ThrownTrident)this.original).f_19860_ = 0.0f;
            ((ThrownTrident)this.original).m_146922_(0.0f);
            ((ThrownTrident)this.original).f_19859_ = 0.0f;
            this.independentXRotO = this.independentXRot;
            this.independentXRot += 60.0f;
            ((ThrownTrident)this.original).f_19860_ = this.independentXRotO;
            ((ThrownTrident)this.original).m_146926_(this.independentXRot);
            if (((ThrownTrident)this.original).f_19797_ % 3 == 0) {
                ((ThrownTrident)this.original).m_5496_((SoundEvent)EpicFightSounds.WHOOSH_ROD.get(), 3.0f, 1.0f);
            }
        }
    }

    public boolean isInnateActivated() {
        return this.innateActivated;
    }

    public void catchByPlayer(PlayerPatch<?> playerpatch) {
        playerpatch.playAnimationSynchronized(Animations.EVERLASTING_ALLEGIANCE_CATCH, 0.0f);
    }

    public void recalledBySkill() {
        ((ThrownTrident)this.original).m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
        ((ThrownTrident)this.original).f_37556_ = true;
        this.innateActivated = true;
        this.independentXRot = ((ThrownTrident)this.original).m_146909_();
        this.returnTick = ((ThrownTrident)this.original).f_19797_;
        this.initialFirePosition = ((ThrownTrident)this.original).m_20182_();
    }
}

