/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class SkeletonPatch<T extends PathfinderMob>
extends HumanoidMobPatch<T> {
    public SkeletonPatch() {
        super(Faction.UNDEAD);
    }

    public SkeletonPatch(Faction faction) {
        super(faction);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        super.commonAggresiveMobAnimatorInit(clientAnimator);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
    }

    @Override
    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, Set.of(Pair.of((Object)LivingMotions.CHASE, (Object)Animations.WITHER_SKELETON_CHASE))));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.SKELETON_SWORD));
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder;
        if (!holdingRanedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AnimatedAttackGoal<SkeletonPatch>(this, builder.build(this)));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.original, 1.2, true));
        }
    }
}

