/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class RavagerPatch
extends MobPatch<Ravager> {
    public RavagerPatch() {
        super(Faction.ILLAGER);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((Ravager)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(8.0);
        ((Ravager)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(6.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.RAVAGER_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.RAVAGER_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.RAVAGER_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((Ravager)this.original).f_21345_.m_25352_(0, new AnimatedAttackGoal<RavagerPatch>(this, MobCombatBehaviors.RAVAGER.build(this)));
        ((Ravager)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.original, 1.0, false));
    }

    @Override
    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> opponent) {
        if (((Ravager)this.original).m_33364_() > 0) {
            this.playAnimationSynchronized(Animations.RAVAGER_STUN, 0.0f);
        }
    }

    @Override
    public StaticAnimation getHitAnimation(StunType stunType) {
        return null;
    }

    @Override
    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.BLUNT_HIT_HARD.get();
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.WHOOSH_BIG.get();
    }
}

