/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CreeperSwellStoppableGoal;

public class CreeperPatch
extends MobPatch<Creeper> {
    private CreeperSwellStoppableGoal swellerGoal;

    public CreeperPatch() {
        super(Faction.NEUTRAL);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((Creeper)this.original).m_21051_((Attribute)EpicFightAttributes.STUN_ARMOR.get()).m_22100_(1.0);
    }

    @Override
    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (WrappedGoal wrappedGoal : ((Creeper)this.original).f_21345_.m_148105_()) {
            Goal goal = wrappedGoal.m_26015_();
            if (!(goal instanceof SwellGoal)) continue;
            toRemove.add(goal);
        }
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.swellerGoal = new CreeperSwellStoppableGoal(this, (Creeper)this.original);
        ((Creeper)this.original).f_21345_.m_25352_(2, (Goal)this.swellerGoal);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.CREEPER_IDLE);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.CREEPER_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.CREEPER_DEATH);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void serverTick(LivingEvent.LivingTickEvent event) {
        super.serverTick(event);
        if (this.getEntityState().inaction()) {
            for (WrappedGoal goal : ((Creeper)this.original).f_21345_.m_148105_()) {
                if (!(goal.m_26015_() instanceof CreeperSwellStoppableGoal) || !goal.m_7620_()) continue;
                goal.m_8041_();
            }
        }
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        OpenMatrix4f mat = super.getModelMatrix(partialTicks);
        if (this.isLogicalClient()) {
            float f = ((Creeper)this.original).m_32320_(partialTicks);
            float f1 = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f2 = (1.0f + f * 0.4f) * f1;
            float f3 = (1.0f + f * 0.1f) / f1;
            OpenMatrix4f.scale(new Vec3f(f2, f3, f2), mat, mat);
        }
        return mat;
    }

    @Override
    public StaticAnimation getHitAnimation(StunType stunType) {
        if (stunType == StunType.LONG) {
            return Animations.CREEPER_HIT_LONG;
        }
        return Animations.CREEPER_HIT_SHORT;
    }
}

