/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.ServerAnimator;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.TargetIndicatorCheckEvent;
import yesman.epicfight.world.gamerule.EpicFightGamerules;

public abstract class LivingEntityPatch<T extends LivingEntity>
extends HurtableEntityPatch<T> {
    public static final EntityDataAccessor<Float> STUN_SHIELD = new EntityDataAccessor(251, EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> MAX_STUN_SHIELD = new EntityDataAccessor(252, EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> EXECUTION_RESISTANCE = new EntityDataAccessor(254, EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> AIRBORNE = new EntityDataAccessor(250, EntityDataSerializers.f_135035_);
    private ItemStack tempOffhandHolder = ItemStack.f_41583_;
    private AttackResult.ResultType lastResultType;
    private float lastDealDamage;
    protected Entity lastTryHurtEntity;
    protected LivingEntity grapplingTarget;
    protected Armature armature;
    protected EntityState state = EntityState.DEFAULT_STATE;
    protected Animator animator;
    protected Vec3 lastAttackPosition;
    protected EpicFightDamageSource epicFightDamageSource;
    protected boolean isLastAttackSuccess;
    public LivingMotion currentLivingMotion = LivingMotions.IDLE;
    public LivingMotion currentCompositeMotion = LivingMotions.IDLE;

    @Override
    public void onConstructed(T entityIn) {
        super.onConstructed(entityIn);
        this.armature = Armatures.getArmatureFor(this);
        this.animator = EpicFightMod.getAnimator(this);
        this.animator.init();
        ((LivingEntity)this.original).m_20088_().m_135372_(STUN_SHIELD, (Object)Float.valueOf(0.0f));
        ((LivingEntity)this.original).m_20088_().m_135372_(MAX_STUN_SHIELD, (Object)Float.valueOf(0.0f));
        ((LivingEntity)this.original).m_20088_().m_135372_(EXECUTION_RESISTANCE, (Object)1);
        ((LivingEntity)this.original).m_20088_().m_135372_(AIRBORNE, (Object)false);
    }

    @Override
    public void onJoinWorld(T entityIn, EntityJoinLevelEvent event) {
        super.onJoinWorld(entityIn, event);
        this.initAttributes();
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void initAnimator(ClientAnimator var1);

    public abstract void updateMotion(boolean var1);

    public Armature getArmature() {
        return this.armature;
    }

    protected void initAttributes() {
        ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22100_(((LivingEntity)this.original).m_21051_(Attributes.f_22276_).m_22115_() * 2.0);
        ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(1.0);
        ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22100_(0.0);
        ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(0.5);
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        this.animator.tick();
        super.tick(event);
        if (((LivingEntity)this.original).f_20919_ == 19) {
            this.aboutToDeath();
        }
        if (((LivingEntity)this.original).f_19861_) {
            this.setAirborneState(false);
        }
    }

    public void onFall(LivingFallEvent event) {
        StaticAnimation fallAnimation;
        if (!((LivingEntity)this.getOriginal()).f_19853_.m_5776_() && (this.isAirborneState() || ((LivingEntity)this.getOriginal()).f_19853_.m_46469_().m_46207_(EpicFightGamerules.HAS_FALL_ANIMATION) && event.getDamageMultiplier() > 0.0f && !this.getEntityState().inaction()) && (this.isAirborneState() || event.getDistance() > 5.0f) && (fallAnimation = ((Animator)this.getAnimator()).getLivingAnimation(LivingMotions.LANDING_RECOVERY, this.getHitAnimation(StunType.FALL))) != null) {
            this.playAnimationSynchronized(fallAnimation, 0.0f);
        }
        this.setAirborneState(false);
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        ((Animator)this.getAnimator()).playDeathAnimation();
        this.currentLivingMotion = LivingMotions.DEATH;
    }

    public void updateEntityState() {
        this.state = this.animator.getEntityState();
    }

    public void cancelAnyAction() {
        ((LivingEntity)this.original).m_5810_();
        ForgeEventFactory.onUseItemStop((LivingEntity)((LivingEntity)this.original), (ItemStack)((LivingEntity)this.original).m_21211_(), (int)((LivingEntity)this.original).m_21212_());
    }

    public CapabilityItem getHoldingItemCapability(InteractionHand hand) {
        return EpicFightCapabilities.getItemStackCapability(((LivingEntity)this.original).m_21120_(hand));
    }

    public CapabilityItem getAdvancedHoldingItemCapability(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.getHoldingItemCapability(hand);
        }
        return this.isOffhandItemValid() ? this.getHoldingItemCapability(hand) : CapabilityItem.EMPTY;
    }

    public EpicFightDamageSource getDamageSource(StaticAnimation animation, InteractionHand hand) {
        EpicFightDamageSource damagesource = EpicFightDamageSource.commonEntityDamageSource("mob", (LivingEntity)this.original, animation);
        damagesource.setImpact(this.getImpact(hand));
        damagesource.setArmorNegation(this.getArmorNegation(hand));
        damagesource.setHurtItem(((LivingEntity)this.original).m_21120_(hand));
        return damagesource;
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        return AttackResult.of(this.getEntityState().attackResult(damageSource), amount);
    }

    public AttackResult tryHarm(Entity target, EpicFightDamageSource damagesource, float amount) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(target, LivingEntityPatch.class);
        AttackResult result = entitypatch != null ? entitypatch.tryHurt(damagesource.cast(), amount) : AttackResult.success(amount);
        return result;
    }

    @Nullable
    public EpicFightDamageSource getEpicFightDamageSource() {
        return this.epicFightDamageSource;
    }

    protected void setOffhandDamage(boolean execute) {
        ItemStack offHandItem;
        if (!execute) {
            return;
        }
        ItemStack mainHandItem = ((LivingEntity)this.getOriginal()).m_21205_();
        ItemStack itemStack = offHandItem = this.isOffhandItemValid() ? ((LivingEntity)this.getOriginal()).m_21206_() : ItemStack.f_41583_;
        if (!this.isOffhandItemValid()) {
            this.tempOffhandHolder = ((LivingEntity)this.getOriginal()).m_21206_();
        }
        ((LivingEntity)this.getOriginal()).m_21008_(InteractionHand.MAIN_HAND, offHandItem);
        ((LivingEntity)this.getOriginal()).m_21008_(InteractionHand.OFF_HAND, mainHandItem);
        AttributeInstance damageAttributeInstance = ((LivingEntity)this.original).m_21051_(Attributes.f_22281_);
        Collection modifiers = this.isOffhandItemValid() ? offHandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_) : null;
        mainHandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).m_22130_(arg_0));
        if (modifiers != null) {
            modifiers.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).m_22118_(arg_0));
        }
    }

    protected void recoverMainhandDamage(boolean execute) {
        if (!execute) {
            return;
        }
        ItemStack mainHandItem = this.tempOffhandHolder.m_41619_() ? ((LivingEntity)this.getOriginal()).m_21205_() : this.tempOffhandHolder;
        ItemStack offHandItem = ((LivingEntity)this.getOriginal()).m_21206_();
        ((LivingEntity)this.getOriginal()).m_21008_(InteractionHand.MAIN_HAND, offHandItem);
        ((LivingEntity)this.getOriginal()).m_21008_(InteractionHand.OFF_HAND, mainHandItem);
        if (!this.tempOffhandHolder.m_41619_()) {
            this.tempOffhandHolder = ItemStack.f_41583_;
        }
        AttributeInstance damageAttributeInstance = ((LivingEntity)this.original).m_21051_(Attributes.f_22281_);
        Collection modifiers = mainHandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_);
        if (modifiers != null) {
            modifiers.forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).m_22130_(arg_0));
        }
        offHandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).forEach(arg_0 -> ((AttributeInstance)damageAttributeInstance).m_22118_(arg_0));
    }

    public void setLastAttackResult(AttackResult attackResult) {
        this.lastResultType = attackResult.resultType;
        this.lastDealDamage = attackResult.damage;
    }

    public void setLastAttackEntity(Entity tryHurtEntity) {
        this.lastTryHurtEntity = tryHurtEntity;
    }

    protected boolean checkLastAttackSuccess(Entity target) {
        boolean success = target.m_7306_(this.lastTryHurtEntity);
        this.lastTryHurtEntity = null;
        if (success && !this.isLastAttackSuccess) {
            this.setLastAttackSuccess(true);
        }
        return success;
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        return this.checkLastAttackSuccess(target) ? new AttackResult(this.lastResultType, this.lastDealDamage) : AttackResult.missed(0.0f);
    }

    public float getModifiedBaseDamage(float baseDamage) {
        return baseDamage;
    }

    public boolean onDrop(LivingDropsEvent event) {
        return false;
    }

    public void gatherDamageDealt(EpicFightDamageSource source, float amount) {
    }

    @Override
    public float getStunShield() {
        return ((Float)((LivingEntity)this.original).m_20088_().m_135370_(STUN_SHIELD)).floatValue();
    }

    @Override
    public void setStunShield(float value) {
        value = Math.max(value, 0.0f);
        value = Math.min(value, this.getMaxStunShield());
        ((LivingEntity)this.original).m_20088_().m_135381_(STUN_SHIELD, (Object)Float.valueOf(value));
    }

    public float getMaxStunShield() {
        return ((Float)((LivingEntity)this.original).m_20088_().m_135370_(MAX_STUN_SHIELD)).floatValue();
    }

    public void setMaxStunShield(float value) {
        value = Math.max(value, 0.0f);
        ((LivingEntity)this.original).m_20088_().m_135381_(MAX_STUN_SHIELD, (Object)Float.valueOf(value));
    }

    public int getExecutionResistance() {
        return (Integer)((LivingEntity)this.original).m_20088_().m_135370_(EXECUTION_RESISTANCE);
    }

    public void setExecutionResistance(int value) {
        int maxExecutionResistance = (int)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.MAX_EXECUTION_RESISTANCE.get());
        value = Math.min(maxExecutionResistance, value);
        ((LivingEntity)this.original).m_20088_().m_135381_(EXECUTION_RESISTANCE, (Object)value);
    }

    @Override
    public float getWeight() {
        return (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.WEIGHT.get());
    }

    public void rotateTo(float degree, float limit, boolean syncPrevRot) {
        LivingEntity entity = (LivingEntity)this.getOriginal();
        float yRot = Mth.m_14177_((float)entity.m_146908_());
        float amount = Mth.m_14036_((float)Mth.m_14177_((float)(degree - yRot)), (float)(-limit), (float)limit);
        float f1 = yRot + amount;
        if (syncPrevRot) {
            entity.f_19859_ = f1;
            entity.f_20886_ = f1;
            entity.f_20884_ = f1;
        }
        entity.m_146922_(f1);
        entity.f_20885_ = f1;
        entity.f_20883_ = f1;
    }

    public void rotateTo(Entity target, float limit, boolean syncPrevRot) {
        Vec3 playerPosition = ((LivingEntity)this.original).m_20182_();
        Vec3 targetPosition = target.m_20182_();
        float yaw = (float)MathUtils.getYRotOfVector(targetPosition.m_82546_(playerPosition));
        this.rotateTo(yaw, limit, syncPrevRot);
    }

    public LivingEntity getTarget() {
        return ((LivingEntity)this.original).m_21214_();
    }

    public float getAttackDirectionPitch() {
        float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.m_91087_().m_91296_() : 1.0f;
        float pitch = -((LivingEntity)this.getOriginal()).m_5686_(partialTicks);
        float correct = pitch > 0.0f ? 0.03333f * (float)Math.pow(pitch, 2.0) : -0.03333f * (float)Math.pow(pitch, 2.0);
        return Mth.m_14036_((float)correct, (float)-30.0f, (float)30.0f);
    }

    public float getCameraXRot() {
        return ((LivingEntity)this.original).m_146909_();
    }

    public float getCameraYRot() {
        return ((LivingEntity)this.original).m_146908_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public OpenMatrix4f getHeadMatrix(float partialTicks) {
        float f2;
        if (this.state.inaction()) {
            f2 = 0.0f;
        } else {
            float f = MathUtils.lerpBetween(((LivingEntity)this.original).f_20884_, ((LivingEntity)this.original).f_20883_, partialTicks);
            float f1 = MathUtils.lerpBetween(((LivingEntity)this.original).f_20886_, ((LivingEntity)this.original).f_20885_, partialTicks);
            f2 = f1 - f;
            if (((LivingEntity)this.original).m_20202_() != null) {
                if (f2 > 45.0f) {
                    f2 = 45.0f;
                } else if (f2 < -45.0f) {
                    f2 = -45.0f;
                }
            }
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((LivingEntity)this.original).f_19860_, ((LivingEntity)this.original).m_146909_(), f2, f2, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float prevYRot;
        float scale = ((LivingEntity)this.original).m_6162_() ? 0.5f : 1.0f;
        Entity entity = ((LivingEntity)this.original).m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            prevYRot = ridingEntity.f_20884_;
            yRot = ridingEntity.f_20883_;
        } else {
            prevYRot = this.isLogicalClient() ? ((LivingEntity)this.original).f_20884_ : ((LivingEntity)this.original).m_146908_();
            yRot = this.isLogicalClient() ? ((LivingEntity)this.original).f_20883_ : ((LivingEntity)this.original).m_146908_();
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prevYRot, yRot, partialTicks, scale, scale, scale);
    }

    public void reserveAnimation(StaticAnimation animation) {
        this.animator.reserveAnimation(animation);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPPlayAnimation(animation, ((LivingEntity)this.original).m_19879_(), 0.0f), this.original);
    }

    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier) {
        this.playAnimationSynchronized(animation, convertTimeModifier, SPPlayAnimation::new);
    }

    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, AnimationPacketProvider packetProvider) {
        this.animator.playAnimation(animation, convertTimeModifier);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(packetProvider.get(animation, convertTimeModifier, this), this.original);
    }

    protected void playReboundAnimation() {
        this.getClientAnimator().playReboundAnimation();
    }

    public void resetSize(EntityDimensions size) {
        EntityDimensions entitysize1;
        EntityDimensions entitysize = ((LivingEntity)this.original).f_19815_;
        ((LivingEntity)this.original).f_19815_ = entitysize1 = size;
        if (entitysize1.f_20377_ < entitysize.f_20377_) {
            double d0 = (double)entitysize1.f_20377_ / 2.0;
            ((LivingEntity)this.original).m_20011_(new AABB(((LivingEntity)this.original).m_20185_() - d0, ((LivingEntity)this.original).m_20186_(), ((LivingEntity)this.original).m_20189_() - d0, ((LivingEntity)this.original).m_20185_() + d0, ((LivingEntity)this.original).m_20186_() + (double)entitysize1.f_20378_, ((LivingEntity)this.original).m_20189_() + d0));
        } else {
            AABB axisalignedbb = ((LivingEntity)this.original).m_20191_();
            ((LivingEntity)this.original).m_20011_(new AABB(axisalignedbb.f_82288_, axisalignedbb.f_82289_, axisalignedbb.f_82290_, axisalignedbb.f_82288_ + (double)entitysize1.f_20377_, axisalignedbb.f_82289_ + (double)entitysize1.f_20378_, axisalignedbb.f_82290_ + (double)entitysize1.f_20377_));
            if (entitysize1.f_20377_ > entitysize.f_20377_ && !((LivingEntity)this.original).f_19853_.m_5776_()) {
                float f = entitysize.f_20377_ - entitysize1.f_20377_;
                ((LivingEntity)this.original).m_6478_(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
            }
        }
    }

    @Override
    public boolean applyStun(StunType stunType, float stunTime) {
        ((LivingEntity)this.original).f_20900_ = 0.0f;
        ((LivingEntity)this.original).f_20901_ = 0.0f;
        ((LivingEntity)this.original).f_20902_ = 0.0f;
        ((LivingEntity)this.original).m_20334_(0.0, 0.0, 0.0);
        this.cancelKnockback = true;
        StaticAnimation hitAnimation = this.getHitAnimation(stunType);
        if (hitAnimation != null) {
            this.playAnimationSynchronized(hitAnimation, stunType.hasFixedStunTime() ? 0.0f : stunTime);
            return true;
        }
        return false;
    }

    public void correctRotation() {
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
    }

    public void updateArmor(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlot slotType) {
    }

    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> opponent) {
    }

    public void onMount(boolean isMountOrDismount, Entity ridingEntity) {
    }

    public void notifyGrapplingWarning() {
    }

    public void onDodgeSuccess(DamageSource damageSource) {
    }

    @Override
    public boolean isStunned() {
        return this.getEntityState().hurt();
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ClientAnimator getClientAnimator() {
        return (ClientAnimator)this.getAnimator();
    }

    public ServerAnimator getServerAnimator() {
        return (ServerAnimator)this.getAnimator();
    }

    public abstract StaticAnimation getHitAnimation(StunType var1);

    public void aboutToDeath() {
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getSmashingSound();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getHitParticle();
    }

    public Collider getColliderMatching(InteractionHand hand) {
        return this.getAdvancedHoldingItemCapability(hand).getWeaponCollider();
    }

    public int getMaxStrikes(InteractionHand hand) {
        return (int)(hand == InteractionHand.MAIN_HAND ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.MAX_STRIKES.get()) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()) : ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22115_()));
    }

    public float getArmorNegation(InteractionHand hand) {
        return (float)(hand == InteractionHand.MAIN_HAND ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()) : (this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()) : ((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22115_()));
    }

    public float getImpact(InteractionHand hand) {
        float impact;
        int i = 0;
        if (hand == InteractionHand.MAIN_HAND) {
            impact = (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.IMPACT.get());
            i = ((LivingEntity)this.getOriginal()).m_21205_().getEnchantmentLevel(Enchantments.f_44980_);
        } else if (this.isOffhandItemValid()) {
            impact = (float)((LivingEntity)this.original).m_21133_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get());
            i = ((LivingEntity)this.getOriginal()).m_21206_().getEnchantmentLevel(Enchantments.f_44980_);
        } else {
            impact = (float)((LivingEntity)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22115_();
        }
        return impact * (1.0f + (float)i * 0.12f);
    }

    public ItemStack getValidItemInHand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return ((LivingEntity)this.original).m_21120_(hand);
        }
        return this.isOffhandItemValid() ? ((LivingEntity)this.original).m_21120_(hand) : ItemStack.f_41583_;
    }

    public boolean isOffhandItemValid() {
        return this.getHoldingItemCapability(InteractionHand.MAIN_HAND).checkOffhandValid(this);
    }

    public boolean isTeammate(Entity entityIn) {
        if (((LivingEntity)this.original).m_20202_() != null && ((LivingEntity)this.original).m_20202_().equals((Object)entityIn)) {
            return true;
        }
        if (this.isRideOrBeingRidden(entityIn)) {
            return true;
        }
        return ((LivingEntity)this.original).m_7307_(entityIn) && ((LivingEntity)this.original).m_5647_() != null && !((LivingEntity)this.original).m_5647_().m_6260_();
    }

    public boolean canPush(Entity entity) {
        EntityState state;
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
        if (entitypatch != null && (state = entitypatch.getEntityState()).inaction()) {
            return false;
        }
        EntityState thisState = this.getEntityState();
        return !thisState.inaction() && !entity.m_7306_((Entity)this.grapplingTarget);
    }

    public LivingEntity getGrapplingTarget() {
        return this.grapplingTarget;
    }

    public void setGrapplingTarget(LivingEntity grapplingTarget) {
        this.grapplingTarget = grapplingTarget;
    }

    public Vec3 getLastAttackPosition() {
        return this.lastAttackPosition;
    }

    public void setLastAttackPosition() {
        this.lastAttackPosition = ((LivingEntity)this.original).m_20182_();
    }

    private boolean isRideOrBeingRidden(Entity entityIn) {
        LivingEntity orgEntity = (LivingEntity)this.getOriginal();
        for (Entity passanger : orgEntity.m_20197_()) {
            if (!passanger.equals((Object)entityIn)) continue;
            return true;
        }
        for (Entity passanger : entityIn.m_20197_()) {
            if (!passanger.equals((Object)orgEntity)) continue;
            return true;
        }
        return false;
    }

    public void setAirborneState(boolean airborne) {
        ((LivingEntity)this.original).m_20088_().m_135381_(AIRBORNE, (Object)airborne);
    }

    public boolean isAirborneState() {
        return (Boolean)((LivingEntity)this.original).m_20088_().m_135370_(AIRBORNE);
    }

    public void setLastAttackSuccess(boolean setter) {
        this.isLastAttackSuccess = setter;
    }

    public boolean isLastAttackSuccess() {
        return this.isLastAttackSuccess;
    }

    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return !this.isLogicalClient();
    }

    public boolean isFirstPerson() {
        return false;
    }

    @Override
    public boolean overrideRender() {
        return true;
    }

    public boolean shouldBlockMoving() {
        return false;
    }

    public float getYRotLimit() {
        return 20.0f;
    }

    public double getXOld() {
        return ((LivingEntity)this.original).f_19790_;
    }

    public double getYOld() {
        return ((LivingEntity)this.original).f_19791_;
    }

    public double getZOld() {
        return ((LivingEntity)this.original).f_19792_;
    }

    @Override
    public EntityState getEntityState() {
        return this.state;
    }

    public LivingMotion getCurrentLivingMotion() {
        return this.currentLivingMotion;
    }

    public List<LivingEntity> getCurrenltyAttackedEntities() {
        return ((Animator)this.getAnimator()).getAnimationVariables(AttackAnimation.HIT_ENTITIES);
    }

    public List<LivingEntity> getCurrenltyHurtEntities() {
        return ((Animator)this.getAnimator()).getAnimationVariables(AttackAnimation.HURT_ENTITIES);
    }

    public void removeHurtEntities() {
        ((Animator)this.getAnimator()).getAnimationVariables(AttackAnimation.HIT_ENTITIES).clear();
        ((Animator)this.getAnimator()).getAnimationVariables(AttackAnimation.HURT_ENTITIES).clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean flashTargetIndicator(LocalPlayerPatch playerpatch) {
        TargetIndicatorCheckEvent event = new TargetIndicatorCheckEvent(playerpatch, this);
        playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, event);
        return event.isCanceled();
    }

    @FunctionalInterface
    public static interface AnimationPacketProvider {
        public SPPlayAnimation get(StaticAnimation var1, float var2, LivingEntityPatch<?> var3);
    }
}

