/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public abstract class WeaponInnateSkill
extends Skill {
    protected List<Map<AnimationProperty.AttackPhaseProperty<?>, Object>> properties = Lists.newArrayList();

    public static Skill.Builder<WeaponInnateSkill> createWeaponInnateBuilder() {
        return new Skill.Builder().setCategory(SkillCategories.WEAPON_INNATE).setResource(Skill.Resource.WEAPON_INNATE_ENERGY);
    }

    public WeaponInnateSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        if (executer.isLogicalClient()) {
            return super.canExecute(executer);
        }
        ItemStack itemstack = ((Player)executer.getOriginal()).m_21205_();
        return super.canExecute(executer) && EpicFightCapabilities.getItemStackCapability(itemstack).getInnateSkill(executer, itemstack) == this && ((Player)executer.getOriginal()).m_20202_() == null && (!executer.getSkill(this).isActivated() || this.activateType == Skill.ActivateType.TOGGLE);
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemstack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        list.add(Component.m_237115_((String)traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(Component.m_237115_((String)(traslatableText + ".tooltip")).m_130940_(ChatFormatting.DARK_GRAY));
        return list;
    }

    protected void generateTooltipforPhase(List<Component> list, ItemStack itemstack, CapabilityItem itemcap, PlayerPatch<?> playerpatch, Map<AnimationProperty.AttackPhaseProperty<?>, Object> propertyMap, String title) {
        Multimap<Attribute, AttributeModifier> capAttributes = itemcap.getAttributeModifiers(EquipmentSlot.MAINHAND, playerpatch);
        double damage = playerpatch.getWeaponAttribute(Attributes.f_22281_, itemstack);
        double armorNegation = playerpatch.getWeaponAttribute((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), itemstack);
        double impact = playerpatch.getWeaponAttribute((Attribute)EpicFightAttributes.IMPACT.get(), itemstack);
        double maxStrikes = playerpatch.getWeaponAttribute((Attribute)EpicFightAttributes.MAX_STRIKES.get(), itemstack);
        ValueModifier damageModifier = ValueModifier.empty();
        ValueModifier armorNegationModifier = ValueModifier.empty();
        ValueModifier impactModifier = ValueModifier.empty();
        ValueModifier maxStrikesModifier = ValueModifier.empty();
        for (AttributeModifier modifier : capAttributes.get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()))) {
            armorNegation += modifier.m_22218_();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)((Attribute)EpicFightAttributes.IMPACT.get()))) {
            impact += modifier.m_22218_();
        }
        for (AttributeModifier modifier : capAttributes.get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get()))) {
            maxStrikes += modifier.m_22218_();
        }
        this.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, propertyMap).ifPresent(damageModifier::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER, propertyMap).ifPresent(armorNegationModifier::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, propertyMap).ifPresent(impactModifier::merge);
        this.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, propertyMap).ifPresent(maxStrikesModifier::merge);
        impactModifier.merge(ValueModifier.multiplier(1.0f + (float)itemstack.getEnchantmentLevel(Enchantments.f_44980_) * 0.12f));
        Double baseDamage = damage;
        damage = damageModifier.getTotalValue(playerpatch.getModifiedBaseDamage((float)damage));
        armorNegation = armorNegationModifier.getTotalValue((float)armorNegation);
        impact = impactModifier.getTotalValue((float)impact);
        maxStrikes = maxStrikesModifier.getTotalValue((float)maxStrikes);
        list.add((Component)Component.m_237113_((String)title).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.GRAY));
        MutableComponent damageComponent = Component.m_237110_((String)"damage_source.epicfight.damage", (Object[])new Object[]{Component.m_237113_((String)ItemStack.f_41584_.format(damage)).m_130940_(ChatFormatting.RED)}).m_130940_(ChatFormatting.DARK_GRAY);
        this.getProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, propertyMap).ifPresent(extraDamageSet -> extraDamageSet.forEach(extraDamage -> extraDamage.setTooltips(itemstack, damageComponent, baseDamage)));
        list.add((Component)damageComponent);
        if (armorNegation != 0.0) {
            list.add((Component)Component.m_237110_((String)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22087_(), (Object[])new Object[]{Component.m_237113_((String)(ItemStack.f_41584_.format(armorNegation) + "%")).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (impact != 0.0) {
            list.add((Component)Component.m_237110_((String)((Attribute)EpicFightAttributes.IMPACT.get()).m_22087_(), (Object[])new Object[]{Component.m_237113_((String)ItemStack.f_41584_.format(impact)).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        list.add((Component)Component.m_237110_((String)((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22087_(), (Object[])new Object[]{Component.m_237113_((String)ItemStack.f_41584_.format(maxStrikes)).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.DARK_GRAY));
        Optional<StunType> stunOption = this.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, propertyMap);
        stunOption.ifPresent(stunType -> list.add((Component)Component.m_237115_((String)stunType.toString()).m_130940_(ChatFormatting.DARK_GRAY)));
        if (!stunOption.isPresent()) {
            list.add((Component)Component.m_237115_((String)StunType.SHORT.toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    protected <V> Optional<V> getProperty(AnimationProperty.AttackPhaseProperty<V> propertyKey, Map<AnimationProperty.AttackPhaseProperty<?>, Object> map) {
        return Optional.ofNullable(map.get(propertyKey));
    }

    public WeaponInnateSkill newProperty() {
        this.properties.add(Maps.newHashMap());
        return this;
    }

    public <T> WeaponInnateSkill addProperty(AnimationProperty.AttackPhaseProperty<T> propertyKey, T object) {
        this.properties.get(this.properties.size() - 1).put(propertyKey, object);
        return this;
    }

    public abstract WeaponInnateSkill registerPropertiesToAnimation();
}

