/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.ChargeableSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;
import yesman.epicfight.world.entity.eventlistener.SkillExecuteEvent;

public class SkillContainer {
    protected Skill containingSkill;
    private PlayerPatch<?> executer;
    protected int prevDuration;
    protected int duration;
    protected int maxDuration;
    protected float resource;
    protected float prevResource;
    protected float maxResource;
    protected boolean isActivated;
    protected int stack;
    protected SkillSlot slot;
    protected SkillDataManager skillDataManager;
    protected boolean disabled;
    protected Skill.Resource lastResource;

    public SkillContainer(PlayerPatch<?> executer, SkillSlot skillSlot) {
        this.executer = executer;
        this.slot = skillSlot;
        this.skillDataManager = new SkillDataManager(skillSlot.universalOrdinal(), this);
    }

    public void setExecuter(PlayerPatch<?> executer) {
        this.executer = executer;
    }

    public PlayerPatch<?> getExecuter() {
        return this.executer;
    }

    public boolean setSkill(Skill skill) {
        return this.setSkill(skill, false);
    }

    public boolean setSkill(Skill skill, boolean initialize) {
        if (this.containingSkill == skill && !initialize) {
            return false;
        }
        if (skill != null && skill.category != this.slot.category()) {
            return false;
        }
        if (this.containingSkill != null) {
            this.containingSkill.onRemoved(this);
        }
        this.containingSkill = skill;
        this.resetValues();
        this.skillDataManager.reset();
        if (skill != null) {
            skill.onInitiate(this);
            this.setMaxResource(skill.consumption);
            this.setMaxDuration(skill.maxDuration);
        }
        this.stack = 0;
        if (initialize) {
            this.setDisabled(false);
        }
        return true;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disable) {
        this.disabled = disable;
    }

    public void resetValues() {
        this.isActivated = false;
        this.prevDuration = 0;
        this.duration = 0;
        this.prevResource = 0.0f;
        this.resource = 0.0f;
    }

    public boolean isEmpty() {
        return this.containingSkill == null;
    }

    public void setResource(float value) {
        if (this.containingSkill != null) {
            this.containingSkill.setConsumption(this, value);
        } else {
            this.prevResource = 0.0f;
            this.resource = 0.0f;
        }
    }

    public void setMaxDuration(int value) {
        this.maxDuration = Math.max(value, 0);
    }

    public void setDuration(int value) {
        if (this.containingSkill != null) {
            if (!this.isActivated() && value > 0) {
                this.isActivated = true;
            }
            this.duration = Math.min(this.maxDuration, Math.max(value, 0));
        } else {
            this.duration = 0;
        }
    }

    public void setStack(int stack) {
        if (this.containingSkill != null) {
            this.stack = Math.min(this.containingSkill.maxStackSize, Math.max(stack, 0));
            if (this.stack <= 0 && this.containingSkill.shouldDeactivateAutomatically(this.executer)) {
                this.deactivate();
                this.containingSkill.onReset(this);
            }
        } else {
            this.stack = 0;
        }
    }

    public void setMaxResource(float maxResource) {
        this.maxResource = maxResource;
    }

    /*
     * Unable to fully structure code
     */
    @OnlyIn(value=Dist.CLIENT)
    public SkillExecuteEvent sendExecuteRequest(LocalPlayerPatch executer, ControllEngine controllEngine) {
        event = new SkillExecuteEvent(executer, this);
        packet = null;
        var6_5 = this.containingSkill;
        if (!(var6_5 instanceof ChargeableSkill)) ** GOTO lbl-1000
        chargeableSkill = (ChargeableSkill)var6_5;
        if (this.containingSkill.getActivateType() == Skill.ActivateType.CHARGING) {
            if (executer.isChargingSkill(this.containingSkill)) {
                ClientEngine.getInstance().renderEngine.unlockRotation((Entity)executer.getOriginal());
                packet = this.containingSkill.getExecutionPacket(executer, this.containingSkill.gatherArguments(executer, controllEngine));
                executer.resetSkillCharging();
            } else {
                if (!this.canExecute(executer, event)) {
                    return event;
                }
                exeSkillPacket = new CPExecuteSkill(this.getSlotId(), CPExecuteSkill.WorkType.CHARGING_START);
                chargeableSkill.gatherChargingArguemtns(executer, controllEngine, exeSkillPacket.getBuffer());
                packet = exeSkillPacket;
            }
        } else lbl-1000:
        // 2 sources

        {
            if (!this.canExecute(executer, event)) {
                return event;
            }
            ClientEngine.getInstance().renderEngine.unlockRotation((Entity)executer.getOriginal());
            packet = this.containingSkill.getExecutionPacket(executer, this.containingSkill.gatherArguments(executer, controllEngine));
        }
        if (packet != null) {
            controllEngine.addPacketToSend(packet);
        }
        return event;
    }

    public boolean requestExecute(ServerPlayerPatch executer, FriendlyByteBuf buf) {
        SkillExecuteEvent event = new SkillExecuteEvent(executer, this);
        if (this.canExecute(executer, event)) {
            this.containingSkill.executeOnServer(executer, buf);
            return true;
        }
        return false;
    }

    public boolean requestCancel(ServerPlayerPatch executer, FriendlyByteBuf buf) {
        if (this.containingSkill != null) {
            this.containingSkill.cancelOnServer(executer, buf);
            return true;
        }
        return false;
    }

    public boolean requestCharging(ServerPlayerPatch executer, FriendlyByteBuf buf) {
        Skill skill = this.containingSkill;
        if (skill instanceof ChargeableSkill) {
            ChargeableSkill chargeableSkill = (ChargeableSkill)((Object)skill);
            SkillExecuteEvent event = new SkillExecuteEvent(executer, this);
            if (this.canExecute(executer, event)) {
                SkillConsumeEvent consumeEvent = new SkillConsumeEvent(executer, this.containingSkill, this.containingSkill.resource, true);
                executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, consumeEvent);
                if (!consumeEvent.isCanceled()) {
                    consumeEvent.getResourceType().consumer.consume(this.containingSkill, executer, consumeEvent.getAmount());
                }
                executer.startSkillCharging(chargeableSkill);
                return true;
            }
        }
        return false;
    }

    public SkillDataManager getDataManager() {
        return this.skillDataManager;
    }

    public float getResource() {
        return this.resource;
    }

    public int getRemainDuration() {
        return this.duration;
    }

    public boolean canExecute(PlayerPatch<?> executer, SkillExecuteEvent event) {
        Skill skill;
        if (this.containingSkill == null) {
            return false;
        }
        if (executer.isChargingSkill(this.containingSkill) && (skill = this.containingSkill) instanceof ChargeableSkill) {
            ChargeableSkill chargingSkill = (ChargeableSkill)((Object)skill);
            if (executer.isLogicalClient()) {
                return true;
            }
            return executer.getSkillChargingTicks() >= chargingSkill.getMinChargingTicks();
        }
        event.setResourcePredicate(this.containingSkill.resourcePredicate(executer) || this.isActivated() && this.containingSkill.activateType == Skill.ActivateType.DURATION);
        event.setSkillExecutable(this.containingSkill.canExecute(executer));
        event.setStateExecutable(this.containingSkill.isExecutableState(executer));
        executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_EXECUTE_EVENT, event);
        return !event.isCanceled() && event.isExecutable();
    }

    public void update() {
        if (this.containingSkill != null) {
            this.containingSkill.updateContainer(this);
        }
    }

    public int getStack() {
        return this.stack;
    }

    public SkillSlot getSlot() {
        return this.slot;
    }

    public int getSlotId() {
        return this.slot.universalOrdinal();
    }

    public Skill getSkill() {
        return this.containingSkill;
    }

    public float getMaxResource() {
        return this.maxResource;
    }

    public void activate() {
        if (!this.isActivated) {
            this.prevDuration = this.maxDuration;
            this.duration = this.maxDuration;
            this.isActivated = true;
        }
    }

    public void deactivate() {
        if (this.isActivated) {
            this.prevDuration = 0;
            this.duration = 0;
            this.isActivated = false;
        }
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public boolean hasSkill(Skill skill) {
        return this.containingSkill != null && this.containingSkill.equals(skill);
    }

    public boolean isFull() {
        return this.containingSkill == null || this.stack >= this.containingSkill.maxStackSize;
    }

    public float getResource(float partialTicks) {
        return this.containingSkill != null && this.maxResource > 0.0f ? (this.prevResource + (this.resource - this.prevResource) * partialTicks) / this.maxResource : 0.0f;
    }

    public float getNeededResource() {
        return this.containingSkill != null ? this.maxResource - this.resource : 0.0f;
    }

    public float getDurationRatio(float partialTicks) {
        return this.containingSkill != null && this.maxDuration > 0 ? ((float)this.prevDuration + (float)(this.duration - this.prevDuration) * partialTicks) / (float)this.maxDuration : 0.0f;
    }

    public boolean equals(Object object) {
        if (object instanceof SkillContainer) {
            SkillContainer skillContainer = (SkillContainer)object;
            return this.slot.equals(skillContainer.slot);
        }
        return false;
    }
}

