/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import com.google.common.collect.Multimap;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPPlayAnimation;
import yesman.epicfight.network.server.SPPotion;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EndermanPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.SourceTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.DealtDamageEvent;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.ProjectileHitEvent;

@Mod.EventBusSubscriber(modid="epicfight")
public class EntityEvents {
    @SubscribeEvent
    public static void spawnEvent(EntityJoinLevelEvent event) {
        EntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(event.getEntity(), EntityPatch.class);
        if (entitypatch != null && !entitypatch.isInitialized()) {
            entitypatch.onJoinWorld(event.getEntity(), event);
        }
    }

    @SubscribeEvent
    public static void updateEvent(LivingEvent.LivingTickEvent event) {
        EntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), EntityPatch.class);
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            entitypatch.tick(event);
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null) {
            entitypatch.onDeath(event);
        }
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        HurtableEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), HurtableEntityPatch.class);
        if (entitypatch != null && entitypatch.shouldCancelKnockback()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        EpicFightDamageSource epicFightDamageSource = null;
        Entity trueSource = event.getSource().m_7639_();
        if (trueSource != null) {
            LivingEntityPatch attackerEntityPatch = EpicFightCapabilities.getEntityPatch(trueSource, LivingEntityPatch.class);
            float baseDamage = event.getAmount();
            DamageSource damageSource = event.getSource();
            if (damageSource instanceof EpicFightDamageSource) {
                EpicFightDamageSource instance;
                epicFightDamageSource = instance = (EpicFightDamageSource)damageSource;
            } else if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().m_7640_() != null) {
                ProjectilePatch projectileCap = EpicFightCapabilities.getEntityPatch(event.getSource().m_7640_(), ProjectilePatch.class);
                if (projectileCap != null) {
                    epicFightDamageSource = projectileCap.getEpicFightDamageSource(event.getSource());
                }
            } else if (attackerEntityPatch != null) {
                epicFightDamageSource = attackerEntityPatch.getEpicFightDamageSource();
                baseDamage = attackerEntityPatch.getModifiedBaseDamage(baseDamage);
            }
            if (epicFightDamageSource != null) {
                Entity f12;
                int k;
                int i;
                int j;
                float f;
                float f12;
                float f2;
                LivingEntity hitEntity = event.getEntity();
                if (attackerEntityPatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch playerpatch = (ServerPlayerPatch)attackerEntityPatch;
                    DealtDamageEvent dealDamagePre = new DealtDamageEvent(playerpatch, hitEntity, epicFightDamageSource, baseDamage);
                    playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_PRE, dealDamagePre);
                }
                float totalDamage = epicFightDamageSource.getDamageModifier().getTotalValue(baseDamage);
                if (trueSource instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)trueSource;
                    if (epicFightDamageSource.getExtraDamages() != null) {
                        for (ExtraDamageInstance extraDamage : epicFightDamageSource.getExtraDamages()) {
                            totalDamage += extraDamage.get(livingEntity, epicFightDamageSource.getHurtItem(), hitEntity, baseDamage);
                        }
                    }
                }
                HurtableEntityPatch hitHurtableEntityPatch = EpicFightCapabilities.getEntityPatch((Entity)hitEntity, HurtableEntityPatch.class);
                LivingEntityPatch hitLivingEntityPatch = EpicFightCapabilities.getEntityPatch((Entity)hitEntity, LivingEntityPatch.class);
                ServerPlayerPatch hitPlayerPatch = EpicFightCapabilities.getEntityPatch((Entity)hitEntity, ServerPlayerPatch.class);
                if (hitPlayerPatch != null) {
                    HurtEvent.Post hurtEvent = new HurtEvent.Post(hitPlayerPatch, epicFightDamageSource, totalDamage);
                    hitPlayerPatch.getEventListener().triggerEvents(PlayerEventListener.EventType.HURT_EVENT_POST, hurtEvent);
                    totalDamage = hurtEvent.getAmount();
                }
                float trueDamage = totalDamage * epicFightDamageSource.getArmorNegation() * 0.01f;
                if (epicFightDamageSource.hasTag(SourceTags.EXECUTION)) {
                    int executionResistance;
                    trueDamage = Float.MAX_VALUE;
                    if (hitLivingEntityPatch != null && (executionResistance = hitLivingEntityPatch.getExecutionResistance()) > 0) {
                        hitLivingEntityPatch.setExecutionResistance(executionResistance - 1);
                        trueDamage = 0.0f;
                    }
                }
                float calculatedDamage = trueDamage;
                if (hitEntity.m_21023_(MobEffects.f_19606_) && (f2 = (f12 = calculatedDamage) - (calculatedDamage = Math.max((f = calculatedDamage * (float)(j = 25 - (i = (hitEntity.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
                    if (hitEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)hitEntity;
                        serverPlayer.m_36222_(Stats.f_12934_, Math.round(f2 * 10.0f));
                    } else {
                        Entity entity = event.getSource().m_7639_();
                        if (entity instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)entity;
                            serverPlayer.m_36222_(Stats.f_12930_, Math.round(f2 * 10.0f));
                        }
                    }
                }
                if (calculatedDamage > 0.0f && (k = EnchantmentHelper.m_44856_((Iterable)hitEntity.m_6168_(), (DamageSource)event.getSource())) > 0) {
                    calculatedDamage = CombatRules.m_19269_((float)calculatedDamage, (float)k);
                }
                float absorpAmount = hitEntity.m_6103_() - calculatedDamage;
                hitEntity.m_7911_(Math.max(absorpAmount, 0.0f));
                float realHealthDamage = Math.max(-absorpAmount, 0.0f);
                if (realHealthDamage > 0.0f && realHealthDamage < 3.4028235E37f && (f12 = event.getSource().m_7639_()) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)f12;
                    serverPlayer.m_36222_(Stats.f_12929_, Math.round(realHealthDamage * 10.0f));
                }
                if (absorpAmount < 0.0f) {
                    hitEntity.m_21153_(hitEntity.m_21223_() + absorpAmount);
                    if (attackerEntityPatch != null) {
                        if (!hitEntity.m_6084_()) {
                            attackerEntityPatch.setLastAttackEntity((Entity)hitEntity);
                        }
                        attackerEntityPatch.gatherDamageDealt(epicFightDamageSource, calculatedDamage);
                    }
                }
                event.setAmount(totalDamage - trueDamage);
                if (event.getAmount() + trueDamage > 0.0f && hitHurtableEntityPatch != null) {
                    StunType stunType = epicFightDamageSource.getStunType();
                    float stunTime = 0.0f;
                    float knockBackAmount = 0.0f;
                    float weight = 40.0f / hitHurtableEntityPatch.getWeight();
                    float stunShield = hitHurtableEntityPatch.getStunShield();
                    if (stunShield > epicFightDamageSource.getImpact() && (stunType == StunType.SHORT || stunType == StunType.LONG)) {
                        stunType = StunType.NONE;
                    }
                    hitHurtableEntityPatch.setStunShield(stunShield - epicFightDamageSource.getImpact());
                    switch (stunType) {
                        case SHORT: {
                            if (hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) || hitHurtableEntityPatch.getStunShield() != 0.0f) break;
                            float totalStunTime = (0.25f + epicFightDamageSource.getImpact() * 0.1f) * weight;
                            if ((totalStunTime *= 1.0f - hitHurtableEntityPatch.getStunReduction()) >= 0.075f) {
                                stunTime = totalStunTime - 0.1f;
                                boolean flag = totalStunTime >= 0.83f;
                                stunTime = flag ? 0.83f : stunTime;
                                stunType = flag ? StunType.LONG : StunType.SHORT;
                                knockBackAmount = Math.min(flag ? epicFightDamageSource.getImpact() * 0.05f : totalStunTime, 2.0f);
                            } else {
                                stunType = StunType.NONE;
                            }
                            stunTime = (float)((double)stunTime * (1.0 - hitEntity.m_21133_(Attributes.f_22278_)));
                            break;
                        }
                        case LONG: {
                            stunType = hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? StunType.NONE : StunType.LONG;
                            knockBackAmount = Math.min(epicFightDamageSource.getImpact() * 0.05f * weight, 5.0f);
                            stunTime = 0.83f;
                            break;
                        }
                        case HOLD: {
                            stunType = StunType.SHORT;
                            stunTime = epicFightDamageSource.getImpact() * 0.25f;
                            break;
                        }
                        case KNOCKDOWN: {
                            stunType = hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? StunType.NONE : StunType.KNOCKDOWN;
                            knockBackAmount = Math.min(epicFightDamageSource.getImpact() * 0.05f, 5.0f);
                            stunTime = 2.0f;
                            break;
                        }
                        case NEUTRALIZE: {
                            stunType = StunType.NEUTRALIZE;
                            hitHurtableEntityPatch.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
                            ((HitParticleType)((Object)EpicFightParticles.AIR_BURST.get())).spawnParticleWithArgument((ServerLevel)hitEntity.f_19853_, (Entity)hitEntity, event.getSource().m_7640_());
                            knockBackAmount = 0.0f;
                            stunTime = 2.0f;
                        }
                    }
                    Vec3 sourcePosition = epicFightDamageSource.getInitialPosition();
                    hitHurtableEntityPatch.setStunReductionOnHit(stunType);
                    boolean stunApplied = hitHurtableEntityPatch.applyStun(stunType, stunTime);
                    if (sourcePosition != null) {
                        if (!(hitEntity instanceof Player) && stunApplied) {
                            hitEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, sourcePosition);
                        }
                        if (knockBackAmount > 0.0f) {
                            hitHurtableEntityPatch.knockBackEntity(sourcePosition, knockBackAmount);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        LivingEntityPatch attackerpatch;
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null && (attackerpatch = EpicFightCapabilities.getEntityPatch(attacker, LivingEntityPatch.class)) != null && attackerpatch.getEpicFightDamageSource() != null) {
            attackerpatch.gatherDamageDealt(attackerpatch.getEpicFightDamageSource(), event.getAmount());
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        if (event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        Object damageSource = null;
        if (event.getEntity().m_21223_() > 0.0f) {
            AttackResult result;
            LivingEntityPatch attackerPatch = EpicFightCapabilities.getEntityPatch(event.getSource().m_7639_(), LivingEntityPatch.class);
            if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().m_7640_() != null) {
                ProjectilePatch projectilepatch = EpicFightCapabilities.getEntityPatch(event.getSource().m_7640_(), ProjectilePatch.class);
                if (projectilepatch != null) {
                    damageSource = projectilepatch.getEpicFightDamageSource(event.getSource());
                }
            } else if (attackerPatch != null && attackerPatch.getEpicFightDamageSource() != null) {
                damageSource = attackerPatch.getEpicFightDamageSource().cast();
            }
            if (damageSource == null) {
                damageSource = event.getSource();
            }
            AttackResult attackResult = result = entitypatch != null && !damageSource.m_19378_() ? entitypatch.tryHurt((DamageSource)damageSource, event.getAmount()) : AttackResult.success(event.getAmount());
            if (attackerPatch != null) {
                attackerPatch.setLastAttackResult(result);
            }
            if (!result.resultType.dealtDamage()) {
                event.setCanceled(true);
            } else if (event.getAmount() != result.damage) {
                DamageSource deflictedDamage = new DamageSource(damageSource.f_19326_).m_19381_();
                event.setCanceled(true);
                event.getEntity().m_6469_(deflictedDamage, result.damage);
            }
        }
    }

    @SubscribeEvent
    public static void shieldEvent(ShieldBlockEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null) {
            entitypatch.playAnimationSynchronized(Animations.BIPED_HIT_SHIELD, 0.0f);
        }
    }

    @SubscribeEvent
    public static void dropEvent(LivingDropsEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null && entitypatch.onDrop(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void projectileImpactEvent(ProjectileImpactEvent event) {
        EntityHitResult rayresult;
        ProjectilePatch projectilepatch = EpicFightCapabilities.getEntityPatch(event.getEntity(), ProjectilePatch.class);
        if (!event.getProjectile().f_19853_.m_5776_() && projectilepatch != null && projectilepatch.onProjectileImpact(event)) {
            event.setCanceled(true);
            return;
        }
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && (rayresult = (EntityHitResult)hitResult).m_82443_() != null) {
            ServerPlayerPatch playerpatch;
            boolean canceled2;
            if (rayresult.m_82443_() instanceof ServerPlayer && (canceled2 = (playerpatch = EpicFightCapabilities.getEntityPatch(rayresult.m_82443_(), ServerPlayerPatch.class)).getEventListener().triggerEvents(PlayerEventListener.EventType.PROJECTILE_HIT_EVENT, new ProjectileHitEvent(playerpatch, event)))) {
                event.setCanceled(true);
            }
            if (event.getProjectile().m_37282_() != null) {
                Entity canceled2;
                if (rayresult.m_82443_().equals((Object)event.getProjectile().m_37282_().m_20202_())) {
                    event.setCanceled(true);
                }
                if ((canceled2 = rayresult.m_82443_()) instanceof PartEntity) {
                    PartEntity partEntity = (PartEntity)canceled2;
                    Entity parent = partEntity.getParent();
                    if (event.getProjectile().m_37282_().m_7306_(parent)) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void itemAttributeModifierEvent(ItemAttributeModifierEvent event) {
        CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(event.getItemStack());
        if (!itemCap.isEmpty()) {
            Multimap<Attribute, AttributeModifier> multimap = itemCap.getAttributeModifiers(event.getSlotType(), null);
            for (Attribute key : multimap.keys()) {
                for (AttributeModifier modifier : multimap.get((Object)key)) {
                    event.addModifier(key, modifier);
                }
            }
        }
    }

    @SubscribeEvent
    public static void equipChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getFrom().m_41720_().equals(event.getTo().m_41720_())) {
            return;
        }
        HurtableEntityPatch hurtableEntitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), HurtableEntityPatch.class);
        if (hurtableEntitypatch != null) {
            hurtableEntitypatch.setDefaultStunReduction(event.getSlot(), event.getFrom(), event.getTo());
        }
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        CapabilityItem fromCap = EpicFightCapabilities.getItemStackCapability(event.getFrom());
        CapabilityItem toCap = EpicFightCapabilities.getItemStackCapability(event.getTo());
        if (event.getSlot() != EquipmentSlot.OFFHAND) {
            if (fromCap != null) {
                event.getEntity().m_21204_().m_22161_(fromCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
            if (toCap != null) {
                event.getEntity().m_21204_().m_22178_(toCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
        }
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            if (event.getSlot().m_20743_() == EquipmentSlot.Type.HAND) {
                InteractionHand hand = event.getSlot() == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                entitypatch.updateHeldItem(fromCap, toCap, event.getFrom(), event.getTo(), hand);
            } else if (event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
                entitypatch.updateArmor(fromCap, toCap, event.getSlot());
            }
        }
    }

    @SubscribeEvent
    public static void sizingEvent(EntityEvent.Size event) {
        if (event.getEntity() instanceof EnderDragon) {
            event.setNewSize(EntityDimensions.m_20395_((float)5.0f, (float)3.0f));
        }
    }

    @SubscribeEvent
    public static void effectAddEvent(MobEffectEvent.Added event) {
        if (!event.getEntity().f_19853_.m_5776_()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.ACTIVATE, event.getEntity().m_19879_()));
        }
    }

    @SubscribeEvent
    public static void effectRemoveEvent(MobEffectEvent.Remove event) {
        if (!event.getEntity().f_19853_.m_5776_() && event.getEffectInstance() != null) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.REMOVE, event.getEntity().m_19879_()));
        }
    }

    @SubscribeEvent
    public static void effectExpiryEvent(MobEffectEvent.Expired event) {
        if (!event.getEntity().f_19853_.m_5776_()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.REMOVE, event.getEntity().m_19879_()));
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        EntityPatch mountEntity = EpicFightCapabilities.getEntityPatch(event.getEntityMounting(), EntityPatch.class);
        if (!event.getLevel().m_5776_() && mountEntity instanceof HumanoidMobPatch && mountEntity.getOriginal() != null && event.getEntityBeingMounted() instanceof Mob) {
            ((HumanoidMobPatch)mountEntity).onMount(event.isMounting(), event.getEntityBeingMounted());
        }
    }

    @SubscribeEvent
    public static void tpEvent(EntityTeleportEvent.EnderEntity event) {
        LivingEntity entity = event.getEntityLiving();
        if (event.getEntityLiving() instanceof EnderMan) {
            EnderMan enderman = (EnderMan)entity;
            EndermanPatch endermanpatch = EpicFightCapabilities.getEntityPatch(event.getEntity(), EndermanPatch.class);
            if (endermanpatch != null) {
                if (endermanpatch.getEntityState().inaction()) {
                    for (Entity collideEntity : enderman.f_19853_.m_45976_(Entity.class, enderman.m_20191_().m_82377_(0.2, 0.2, 0.2))) {
                        if (!(collideEntity instanceof Projectile)) continue;
                        return;
                    }
                    event.setCanceled(true);
                } else if (endermanpatch.isRaging()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null && entitypatch.isLogicalClient() && !entitypatch.getEntityState().inaction() && !event.getEntity().m_20069_()) {
            StaticAnimation jumpAnimation = entitypatch.getClientAnimator().getJumpAnimation();
            ((Animator)entitypatch.getAnimator()).playAnimation(jumpAnimation, 0.0f);
            EpicFightNetworkManager.sendToServer(new CPPlayAnimation(jumpAnimation.getNamespaceId(), jumpAnimation.getId(), 0.0f, true, false));
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null) {
            entitypatch.onFall(event);
        }
    }

    @SubscribeEvent
    public static void playerFallEvent(PlayerFlyableFallEvent event) {
        PlayerPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), PlayerPatch.class);
        if (entitypatch != null) {
            entitypatch.onFall(new LivingFallEvent((LivingEntity)event.getEntity(), event.getDistance(), event.getMultiplier()));
        }
    }
}

