/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.armor.CustomModelBakery;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class WearableItemLayer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends HumanoidModel<E>, AM extends HumanoidMesh>
extends PatchedLayer<E, T, M, HumanoidArmorLayer<E, M, M>, AM> {
    private static final Map<ResourceLocation, AnimatedMesh> ARMOR_MODELS = new HashMap<ResourceLocation, AnimatedMesh>();
    private static final Map<String, ResourceLocation> EPICFIGHT_OVERRIDING_TEXTURES = Maps.newHashMap();
    private final boolean firstPersonModel;

    public static void clear() {
        ARMOR_MODELS.clear();
        EPICFIGHT_OVERRIDING_TEXTURES.clear();
    }

    public WearableItemLayer(AM mesh, boolean firstPersonModel) {
        super(mesh);
        this.firstPersonModel = firstPersonModel;
    }

    private void renderArmor(PoseStack matStack, MultiBufferSource multiBufferSource, int packedLightIn, boolean hasEffect, AnimatedMesh model, Armature armature, float r, float g, float b, ResourceLocation armorTexture, OpenMatrix4f[] poses) {
        VertexConsumer vertexConsumer = EpicFightRenderTypes.getArmorFoilBufferTriangles(multiBufferSource, RenderType.m_110431_((ResourceLocation)armorTexture), false, hasEffect);
        model.drawModelWithPose(matStack, vertexConsumer, packedLightIn, r, g, b, 1.0f, OverlayTexture.f_118083_, armature, poses);
    }

    @Override
    public void renderLayer(T entitypatch, E entityliving, HumanoidArmorLayer<E, M, M> vanillaLayer, PoseStack poseStack, MultiBufferSource buf, int packedLightIn, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            AnimatedMesh armorMesh;
            boolean debuggingMode;
            ItemStack stack;
            Item item;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            boolean chestPart = false;
            if (((LivingEntityPatch)entitypatch).isFirstPerson() && this.firstPersonModel) {
                if (slot != EquipmentSlot.CHEST) continue;
                chestPart = true;
            }
            if (slot == EquipmentSlot.HEAD && this.firstPersonModel || !((item = (stack = entityliving.m_6844_(slot)).m_41720_()) instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            if (slot != armorItem.m_40402_()) {
                return;
            }
            poseStack.m_85836_();
            float head = 0.0f;
            if (slot == EquipmentSlot.HEAD) {
                poseStack.m_85837_(0.0, (double)head * 0.055, 0.0);
            }
            if (debuggingMode = ClientEngine.getInstance().isArmorModelDebuggingMode()) {
                poseStack.m_85836_();
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                poseStack.m_85837_(1.0, -1.501, 0.0);
                vanillaLayer.m_6494_(poseStack, buf, packedLightIn, entityliving, partialTicks, head, (float)packedLightIn, bob, yRot, xRot);
                poseStack.m_85849_();
            }
            if ((armorMesh = this.getArmorModel(vanillaLayer, entityliving, armorItem, stack, slot, debuggingMode)) == null) {
                poseStack.m_85849_();
                return;
            }
            armorMesh.initialize();
            if (chestPart && armorMesh.hasPart("torso")) {
                armorMesh.getPart((String)"torso").hidden = true;
            }
            boolean hasEffect = stack.m_41790_();
            if (armorItem instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeableItem = (DyeableLeatherItem)armorItem;
                int i = dyeableItem.m_41121_(stack);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, armorMesh, ((LivingEntityPatch)entitypatch).getArmature(), r, g, b, this.getArmorTexture(stack, (Entity)entityliving, armorMesh, slot, null), poses);
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, armorMesh, ((LivingEntityPatch)entitypatch).getArmature(), 1.0f, 1.0f, 1.0f, this.getArmorTexture(stack, (Entity)entityliving, armorMesh, slot, "overlay"), poses);
            } else {
                this.renderArmor(poseStack, buf, packedLightIn, hasEffect, armorMesh, ((LivingEntityPatch)entitypatch).getArmature(), 1.0f, 1.0f, 1.0f, this.getArmorTexture(stack, (Entity)entityliving, armorMesh, slot, null), poses);
            }
            poseStack.m_85849_();
        }
    }

    private AnimatedMesh getArmorModel(HumanoidArmorLayer<E, M, M> originalRenderer, E entityliving, ArmorItem armorItem, ItemStack stack, EquipmentSlot slot, boolean armorDebugging) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)armorItem);
        if (ARMOR_MODELS.containsKey(registryName) && !armorDebugging) {
            return ARMOR_MODELS.get(registryName);
        }
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        ResourceLocation rl = new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)armorItem).m_135827_(), "animmodels/armor/" + ForgeRegistries.ITEMS.getKey((Object)armorItem).m_135815_() + ".json");
        AnimatedMesh model = null;
        if (resourceManager.m_213713_(rl).isPresent()) {
            JsonModelLoader modelLoader = new JsonModelLoader(resourceManager, rl);
            model = modelLoader.loadAnimatedMesh(AnimatedMesh::new);
        } else {
            HumanoidModel defaultModel = originalRenderer.m_117078_(slot);
            Model customModel = ForgeHooksClient.getArmorModel(entityliving, (ItemStack)stack, (EquipmentSlot)slot, (HumanoidModel)defaultModel);
            if (customModel == defaultModel || !(customModel instanceof HumanoidModel)) {
                model = ((HumanoidMesh)this.mesh).getHumanoidArmorModel(slot);
            } else {
                HumanoidModel humanoidModel = (HumanoidModel)customModel;
                model = CustomModelBakery.bake(humanoidModel, armorItem, slot, armorDebugging);
            }
        }
        ARMOR_MODELS.put(registryName, model);
        return model;
    }

    private ResourceLocation getArmorTexture(ItemStack stack, Entity entity, AnimatedMesh armorMesh, EquipmentSlot slot, String type) {
        ResourceLocation resourcelocation;
        int idx2;
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        String s2 = String.format("%s/epicfight/%s", (s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type)).substring(0, idx2 = s1.lastIndexOf(47)), s1.substring(idx2 + 1));
        ResourceLocation resourcelocation2 = EPICFIGHT_OVERRIDING_TEXTURES.get(s2);
        if (resourcelocation2 != null) {
            return resourcelocation2;
        }
        if (!EPICFIGHT_OVERRIDING_TEXTURES.containsKey(s2)) {
            resourcelocation2 = new ResourceLocation(s2);
            ResourceManager rm = Minecraft.m_91087_().m_91098_();
            if (rm.m_213713_(resourcelocation2).isPresent()) {
                EPICFIGHT_OVERRIDING_TEXTURES.put(s2, resourcelocation2);
                return resourcelocation2;
            }
            EPICFIGHT_OVERRIDING_TEXTURES.put(s2, null);
        }
        if (armorMesh.getRenderProperty() != null && armorMesh.getRenderProperty().getCustomTexturePath() != null) {
            s1 = armorMesh.getRenderProperty().getCustomTexturePath();
        }
        if ((resourcelocation = (ResourceLocation)HumanoidArmorLayer.f_117070_.get(s1)) == null) {
            resourcelocation = new ResourceLocation(s1);
            HumanoidArmorLayer.f_117070_.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

