/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.ModelPart;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.EmptyLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedItemInHandLayer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.client.renderer.patched.layer.WearableItemLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Armatures;

@OnlyIn(value=Dist.CLIENT)
public class FirstPersonRenderer
extends PatchedLivingEntityRenderer<LocalPlayer, LocalPlayerPatch, PlayerModel<LocalPlayer>, HumanoidMesh> {
    public FirstPersonRenderer() {
        this.addPatchedLayer(ElytraLayer.class, new EmptyLayer());
        this.addPatchedLayer(PlayerItemInHandLayer.class, new PatchedItemInHandLayer());
        this.addPatchedLayer(HumanoidArmorLayer.class, new WearableItemLayer(Meshes.BIPED, true));
        this.addPatchedLayer(CustomHeadLayer.class, new EmptyLayer());
        this.addPatchedLayer(ArrowLayer.class, new EmptyLayer());
        this.addPatchedLayer(BeeStingerLayer.class, new EmptyLayer());
        this.addPatchedLayer(SpinAttackEffectLayer.class, new EmptyLayer());
        this.addPatchedLayer(CapeLayer.class, new EmptyLayer());
    }

    @Override
    public void render(LocalPlayer entityIn, LocalPlayerPatch entitypatch, LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>> renderer, MultiBufferSource buffer, PoseStack matStackIn, int packedLightIn, float partialTicks) {
        Armature armature = entitypatch.getArmature();
        armature.initializeTransform();
        OpenMatrix4f[] poses = armature.getPoseAsTransformMatrix(entitypatch.getClientAnimator().getComposedLayerPose(partialTicks));
        matStackIn.m_85836_();
        OpenMatrix4f mat = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(partialTicks), Armatures.BIPED.head);
        mat.translate(0.0f, 0.2f, 0.0f);
        Vec3f translateVectorOfHead = mat.toTranslationVector();
        matStackIn.m_85837_((double)(-translateVectorOfHead.x), (double)(-translateVectorOfHead.y), (double)(-translateVectorOfHead.z));
        HumanoidMesh mesh = this.getMesh(entitypatch);
        this.prepareModel(mesh, entityIn, entitypatch);
        if (!((LocalPlayer)entitypatch.getOriginal()).m_20145_()) {
            for (ModelPart p : mesh.getAllParts()) {
                p.hidden = true;
            }
            mesh.lefrArm.hidden = false;
            mesh.rightArm.hidden = false;
            mesh.leftSleeve.hidden = false;
            mesh.rightSleeve.hidden = false;
            mesh.drawModelWithPose(matStackIn, buffer.m_6299_(EpicFightRenderTypes.triangles(RenderType.m_110458_((ResourceLocation)entityIn.m_108560_()))), packedLightIn, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, armature, poses);
        }
        if (!entityIn.m_5833_()) {
            this.renderLayer(renderer, entitypatch, entityIn, poses, buffer, matStackIn, packedLightIn, partialTicks);
        }
        matStackIn.m_85849_();
    }

    @Override
    protected void renderLayer(LivingEntityRenderer<LocalPlayer, PlayerModel<LocalPlayer>> renderer, LocalPlayerPatch entitypatch, LocalPlayer entityIn, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLightIn, float partialTicks) {
        Iterator iter = renderer.f_115291_.iterator();
        float f = MathUtils.lerpBetween(entityIn.f_20884_, entityIn.f_20883_, partialTicks);
        float f1 = MathUtils.lerpBetween(entityIn.f_20886_, entityIn.f_20885_, partialTicks);
        float f2 = f1 - f;
        float f7 = entityIn.m_5686_(partialTicks);
        float bob = this.getVanillaRendererBob(entityIn, renderer, partialTicks);
        while (iter.hasNext()) {
            RenderLayer layer = (RenderLayer)iter.next();
            Class<?> rendererClass = layer.getClass();
            if (rendererClass.isAnonymousClass()) {
                rendererClass = rendererClass.getSuperclass();
            }
            if (!this.patchedLayers.containsKey(rendererClass)) continue;
            ((PatchedLayer)this.patchedLayers.get(rendererClass)).renderLayer(0, entitypatch, entityIn, layer, poseStack, buffer, packedLightIn, poses, bob, f2, f7, partialTicks);
        }
    }

    @Override
    public HumanoidMesh getMesh(LocalPlayerPatch entitypatch) {
        return ((LocalPlayer)entitypatch.getOriginal()).m_108564_().equals("slim") ? Meshes.ALEX : Meshes.BIPED;
    }

    @Override
    protected void prepareModel(HumanoidMesh mesh, LocalPlayer entity, LocalPlayerPatch entitypatch) {
        mesh.initialize();
        mesh.head.hidden = true;
        mesh.hat.hidden = true;
    }
}

