/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.config.Option;

@OnlyIn(value=Dist.CLIENT)
public class ColorSlider
extends AbstractSliderButton {
    private static final int[] COLOR_ARRAY = new int[]{-65536, -256, -16711936, -16711681, -16776961, -65281, -65536};
    private final Option.DoubleOption colorOption;

    public ColorSlider(int x, int y, int width, int height, Component message, double defaultValue, Option.DoubleOption option) {
        super(x, y, width, height, message, defaultValue);
        this.colorOption = option;
    }

    public void m_6303_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontrenderer = minecraft.f_91062_;
        RenderSystem.m_69478_();
        for (int i = 0; i < 6; ++i) {
            this.m_93179_(PoseStack2, this.f_93620_ + this.f_93618_ * i / 6, this.f_93621_, this.f_93620_ + this.f_93618_ * (i + 1) / 6, this.f_93621_ + this.f_93619_, COLOR_ARRAY[i], COLOR_ARRAY[i + 1]);
        }
        this.m_7906_(PoseStack2, minecraft, mouseX, mouseY);
        int j = this.getFGColor();
        ColorSlider.m_93215_((PoseStack)PoseStack2, (Font)fontrenderer, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
    }

    protected void m_7906_(PoseStack PoseStack2, Minecraft minecraft, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        int i = (this.m_198029_() ? 2 : 1) * 20;
        int minX = this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - 8));
        this.m_93228_(PoseStack2, minX, this.f_93621_, 0, 46 + i, 4, 20);
        this.m_93228_(PoseStack2, minX + 4, this.f_93621_, 196, 46 + i, 4, 20);
        ColorSlider.m_93172_((PoseStack)PoseStack2, (int)(minX + 1), (int)(this.f_93621_ + 1), (int)(minX + 7), (int)(this.f_93621_ + 19), (int)ColorSlider.toColorInteger(this.f_93577_));
    }

    protected void m_5697_() {
        this.colorOption.setValue(this.f_93577_);
    }

    protected void m_5695_() {
    }

    public static int toColorInteger(double value) {
        int packedColor = 0;
        for (int i = 0; i < 6; ++i) {
            double min = 0.16666666666666666 * (double)i;
            double max = 0.16666666666666666 * (double)(i + 1);
            if (!(value >= min) || !(value <= max)) continue;
            double lerpFactor = (value - min) / (max - min);
            int colorA = COLOR_ARRAY[i];
            int colorB = COLOR_ARRAY[i + 1];
            int f = colorA >> 24 & 0xFF;
            int f1 = colorA >> 16 & 0xFF;
            int f2 = colorA >> 8 & 0xFF;
            int f3 = colorA & 0xFF;
            int f4 = colorB >> 24 & 0xFF;
            int f5 = colorB >> 16 & 0xFF;
            int f6 = colorB >> 8 & 0xFF;
            int f7 = colorB & 0xFF;
            int r = (int)Mth.m_14139_((double)lerpFactor, (double)f, (double)f4);
            int g = (int)Mth.m_14139_((double)lerpFactor, (double)f1, (double)f5);
            int b = (int)Mth.m_14139_((double)lerpFactor, (double)f2, (double)f6);
            int a = (int)Mth.m_14139_((double)lerpFactor, (double)f3, (double)f7);
            packedColor = r << 24 | g << 16 | b << 8 | a;
        }
        return packedColor;
    }

    protected void m_93179_(PoseStack poseStack, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        poseStack.m_85836_();
        int width = x2 - x1;
        int height = y2 - y1;
        int newX = x1 + width / 2;
        int newY = y1 + height / 2;
        poseStack.m_85837_((double)newX, (double)newY, 0.0);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
        super.m_93179_(poseStack, -height / 2, -width / 2, height / 2, width / 2, colorA, colorB);
        poseStack.m_85849_();
    }
}

