/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

@OnlyIn(value=Dist.CLIENT)
public class SkillEditScreen
extends Screen {
    private static final ResourceLocation SKILL_EDIT_UI = new ResourceLocation("epicfight", "textures/gui/screen/skill_edit.png");
    private static final MutableComponent NO_SKILLS = Component.m_237113_((String)"gui.epicfight.no_skills");
    private static final int MAX_SHOWING_BUTTONS = 6;
    private final Player player;
    private final CapabilitySkill skills;
    private final Map<SkillSlot, SlotButton> slotButtons = Maps.newHashMap();
    private final List<LearnSkillButton> learnedSkillButtons = Lists.newArrayList();
    private int start;
    private SlotButton selectedSlotButton;

    public SkillEditScreen(Player player, CapabilitySkill skills) {
        super((Component)Component.m_237115_((String)"gui.epicfight.skill_edit"));
        this.player = player;
        this.skills = skills;
    }

    public void m_7856_() {
        int i = this.f_96543_ / 2 - 96;
        int j = this.f_96544_ / 2 - 82;
        this.slotButtons.clear();
        this.learnedSkillButtons.clear();
        for (SkillSlot skillSlot : SkillSlot.ENUM_MANAGER.universalValues()) {
            if (!this.skills.hasCategory(skillSlot.category()) || !skillSlot.category().learnable()) continue;
            SlotButton slotButton = new SlotButton(i, j, 18, 18, skillSlot, this.skills.skillContainers[skillSlot.universalOrdinal()].getSkill(), button -> {
                this.start = 0;
                for (Button button2 : this.learnedSkillButtons) {
                    this.m_6702_().remove(button2);
                }
                this.learnedSkillButtons.clear();
                int k = this.f_96543_ / 2 - 69;
                int n = this.f_96544_ / 2 - 78;
                Collection<Skill> learnedSkillCollection = this.skills.getLearnedSkills(skillSlot.category());
                for (Skill skill : learnedSkillCollection) {
                    void var4_7;
                    this.learnedSkillButtons.add(new LearnSkillButton(k, (int)var4_7, 147, 24, skill, (Component)Component.m_237115_((String)skill.getTranslationKey()), pressedButton -> {
                        if (this.f_96541_.f_91074_.f_36078_ >= learnedSkill.getRequiredXp() || this.f_96541_.f_91074_.m_7500_()) {
                            if (!this.canPress(pressedButton)) {
                                return;
                            }
                            this.skills.skillContainers[skillSlot.universalOrdinal()].setSkill(learnedSkill);
                            EpicFightNetworkManager.sendToServer(new CPChangeSkill(skillSlot.universalOrdinal(), -1, learnedSkill.toString(), !this.f_96541_.f_91074_.m_7500_()));
                            this.m_7379_();
                        }
                    }).setActive(this.skills.getSkillContainer(skill) == null));
                    var4_7 += 26;
                }
                for (Button button3 : this.learnedSkillButtons) {
                    this.m_7787_((GuiEventListener)button3);
                }
                this.selectedSlotButton = (SlotButton)button;
            }, (button, PoseStack2, x, y) -> this.m_96617_(PoseStack2, this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)SkillSlot.ENUM_MANAGER.toTranslated(skillSlot)), Math.max(this.f_96543_ / 2 - 43, 170)), x, y));
            this.slotButtons.put(skillSlot, slotButton);
            this.m_7787_((GuiEventListener)slotButton);
            j += 18;
        }
        if (this.selectedSlotButton != null) {
            this.selectedSlotButton = this.slotButtons.get(this.selectedSlotButton.slot);
            this.selectedSlotButton.m_5691_();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        if (this.canScroll()) {
            int scrollPosition = (int)(140.0f * ((float)this.start / (float)(this.learnedSkillButtons.size() - 6)));
            GuiComponent.m_93160_((PoseStack)poseStack, (int)(this.f_96543_ / 2 + 80), (int)(this.f_96544_ / 2 - 80 + scrollPosition), (int)12, (int)15, (float)231.0f, (float)2.0f, (int)12, (int)15, (int)256, (int)256);
        }
        int maxShowingButtons = Math.min(this.learnedSkillButtons.size(), 6);
        for (int i = this.start; i < maxShowingButtons + this.start; ++i) {
            this.learnedSkillButtons.get(i).m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        for (SlotButton sb : this.slotButtons.values()) {
            sb.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.slotButtons.isEmpty()) {
            int lineHeight = 0;
            for (FormattedCharSequence s : this.f_96547_.m_92923_((FormattedText)NO_SKILLS, 110)) {
                this.f_96547_.m_92877_(poseStack, s, (float)(this.f_96543_ / 2 - 50), (float)(this.f_96544_ / 2 - 72 + lineHeight), 0x303030);
                lineHeight += 10;
            }
        }
    }

    public void m_7333_(PoseStack PoseStack2) {
        super.m_7333_(PoseStack2);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_EDIT_UI);
        this.m_93228_(PoseStack2, this.f_96543_ / 2 - 104, this.f_96544_ / 2 - 100, 0, 0, 208, 200);
    }

    private boolean canScroll() {
        return this.learnedSkillButtons.size() > 6;
    }

    private boolean canPress(Button button) {
        int buttonOrder = this.learnedSkillButtons.indexOf(button);
        return buttonOrder >= this.start && buttonOrder <= this.start + 6;
    }

    public boolean m_6050_(double x, double y, double wheel) {
        if (!this.canScroll()) {
            return false;
        }
        if (wheel > 0.0) {
            if (this.start > 0) {
                --this.start;
                for (Button button : this.learnedSkillButtons) {
                    button.f_93621_ += 26;
                }
                return true;
            }
        } else if (this.start < this.learnedSkillButtons.size() - 6) {
            ++this.start;
            for (Button button : this.learnedSkillButtons) {
                button.f_93621_ -= 26;
            }
            return true;
        }
        return false;
    }

    class SlotButton
    extends Button {
        private final Skill iconSkill;
        private final SkillSlot slot;

        public SlotButton(int x, int y, int width, int height, SkillSlot slot, Skill skill, Button.OnPress pressedAction, Button.OnTooltip onTooltip) {
            super(x, y, width, height, (Component)Component.m_237119_(), pressedAction, onTooltip);
            this.iconSkill = skill;
            this.slot = slot;
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_EDIT_UI);
            this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            int y = this.f_93622_ || SkillEditScreen.this.selectedSlotButton == this ? 35 : 17;
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, 237, y, this.f_93618_, this.f_93619_);
            if (this.iconSkill != null) {
                RenderSystem.m_69478_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.iconSkill.getSkillTexture());
                GuiComponent.m_93160_((PoseStack)poseStack, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
            }
            if (this.m_198029_()) {
                this.m_7428_(poseStack, mouseX, mouseY);
            }
        }
    }

    class LearnSkillButton
    extends Button {
        private final Skill skill;

        public LearnSkillButton(int x, int y, int width, int height, Skill skill, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.f_93716_);
            this.skill = skill;
        }

        public void m_6305_(PoseStack PoseStack2, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_EDIT_UI);
            this.f_93622_ = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
            int texY = this.f_93622_ || !this.f_93623_ ? 224 : 200;
            this.m_93228_(PoseStack2, this.f_93620_, this.f_93621_, 0, texY, this.f_93618_, this.f_93619_);
            RenderSystem.m_69478_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.skill.getSkillTexture());
            GuiComponent.m_93160_((PoseStack)PoseStack2, (int)(this.f_93620_ + 5), (int)(this.f_93621_ + 4), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
            LearnSkillButton.m_93243_((PoseStack)PoseStack2, (Font)SkillEditScreen.this.f_96547_, (Component)this.m_6035_(), (int)(this.f_93620_ + 26), (int)(this.f_93621_ + 2), (int)-1);
            if (this.f_93623_) {
                int color = ((SkillEditScreen)SkillEditScreen.this).f_96541_.f_91074_.f_36078_ >= this.skill.getRequiredXp() || ((SkillEditScreen)SkillEditScreen.this).f_96541_.f_91074_.m_7500_() ? 8453920 : 0xFF6060;
                LearnSkillButton.m_93243_((PoseStack)PoseStack2, (Font)SkillEditScreen.this.f_96547_, (Component)Component.m_237110_((String)"gui.epicfight.changing_cost", (Object[])new Object[]{this.skill.getRequiredXp()}), (int)(this.f_93620_ + 70), (int)(this.f_93621_ + 12), (int)color);
            } else {
                LearnSkillButton.m_93243_((PoseStack)PoseStack2, (Font)SkillEditScreen.this.f_96547_, (Component)Component.m_237113_((String)SkillEditScreen.this.skills.getSkillContainer(this.skill).getSlot().toString().toLowerCase(Locale.ROOT)), (int)(this.f_93620_ + 26), (int)(this.f_93621_ + 12), (int)0xFF6060);
            }
        }

        public boolean m_6375_(double x, double y, int pressType) {
            boolean flag;
            if (this.f_93624_ && pressType == 1 && (flag = this.clickedNoCountActive(x, y))) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                SkillEditScreen.this.f_96541_.m_91152_((Screen)new SkillBookScreen(SkillEditScreen.this.player, this.skill, null, SkillEditScreen.this));
                return true;
            }
            return super.m_6375_(x, y, pressType);
        }

        protected boolean clickedNoCountActive(double x, double y) {
            return this.f_93624_ && x >= (double)this.f_93620_ && y >= (double)this.f_93621_ && x < (double)(this.f_93620_ + this.f_93618_) && y < (double)(this.f_93621_ + this.f_93619_);
        }

        public LearnSkillButton setActive(boolean active) {
            this.f_93623_ = active;
            return this;
        }
    }
}

