/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.screen.SlotSelectScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.item.SkillBookItem;

@OnlyIn(value=Dist.CLIENT)
public class SkillBookScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("epicfight", "textures/gui/screen/skillbook.png");
    protected final Player opener;
    protected final LocalPlayerPatch playerpatch;
    protected final Skill skill;
    protected final InteractionHand hand;
    protected final Screen lowerScreen;

    public SkillBookScreen(Player opener, ItemStack stack, InteractionHand hand) {
        super((Component)Component.m_237119_());
        this.opener = opener;
        this.playerpatch = EpicFightCapabilities.getEntityPatch((Entity)this.opener, LocalPlayerPatch.class);
        this.skill = SkillBookItem.getContainSkill(stack);
        this.hand = hand;
        this.lowerScreen = null;
    }

    public SkillBookScreen(Player opener, Skill skill, InteractionHand hand, Screen lowerScreen) {
        super((Component)Component.m_237119_());
        this.opener = opener;
        this.playerpatch = EpicFightCapabilities.getEntityPatch((Entity)this.opener, LocalPlayerPatch.class);
        this.skill = skill;
        this.hand = hand;
        this.lowerScreen = lowerScreen;
    }

    protected void m_7856_() {
        SkillContainer thisSkill = this.playerpatch.getSkill(this.skill);
        SkillContainer priorSkill = this.skill == null ? null : this.playerpatch.getSkill(this.skill.getPriorSkill());
        boolean isUsing = thisSkill != null;
        boolean condition = this.skill.getPriorSkill() == null || priorSkill != null;
        Button.OnTooltip tooltip = Button.f_93716_;
        if (!isUsing) {
            if (condition) {
                if (thisSkill != null) {
                    tooltip = (button, matrixStack, mouseX, mouseY) -> this.m_96617_(matrixStack, this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.epicfight.replace", (Object[])new Object[]{Component.m_237115_((String)this.skill.getTranslationKey()).getString()}), Math.max(this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                }
            } else {
                tooltip = (button, matrixStack, mouseX, mouseY) -> this.m_96617_(matrixStack, this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.epicfight.require_learning", (Object[])new Object[]{Component.m_237115_((String)this.skill.getPriorSkill().getTranslationKey()).getString()}), Math.max(this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
            }
        }
        Button changeButton = new Button((this.f_96543_ + 150) / 2, (this.f_96544_ + 110) / 2, 46, 20, (Component)Component.m_237115_((String)("gui.epicfight" + (isUsing ? ".applied" : (condition ? ".learn" : ".unusable")))), p_onPress_1_ -> {
            Set<SkillContainer> skillContainers = this.playerpatch.getSkillCapability().getSkillContainersFor(this.skill.getCategory());
            if (skillContainers.size() == 1) {
                this.learnSkill(skillContainers.iterator().next());
            } else {
                SlotSelectScreen slotSelectScreen = new SlotSelectScreen(skillContainers, this);
                this.f_96541_.m_91152_((Screen)slotSelectScreen);
            }
        }, tooltip);
        if (isUsing || !condition) {
            changeButton.f_93623_ = false;
        }
        if (this.hand == null) {
            changeButton.f_93624_ = false;
        }
        this.m_142416_((GuiEventListener)changeButton);
    }

    protected void learnSkill(SkillContainer skillContainer) {
        skillContainer.setSkill(this.skill);
        this.f_96541_.m_91152_(null);
        this.playerpatch.getSkillCapability().addLearnedSkill(this.skill);
        int i = this.hand == InteractionHand.MAIN_HAND ? this.opener.m_150109_().f_35977_ : 40;
        EpicFightNetworkManager.sendToServer(new CPChangeSkill(skillContainer.getSlot().universalOrdinal(), i, this.skill.toString(), false));
    }

    public void m_7379_() {
        if (this.lowerScreen != null) {
            this.f_96541_.m_91152_(this.lowerScreen);
        } else {
            super.m_7379_();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.render(poseStack, mouseX, mouseY, partialTicks, false);
    }

    public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTicks, boolean asBackground) {
        if (!asBackground) {
            this.m_7333_(poseStack);
        }
        int posX = (this.f_96543_ - 256) / 2;
        int posY = (this.f_96544_ - 200) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        poseStack.m_85836_();
        poseStack.m_85837_((double)(posX + 128), (double)(posY + 90), 0.0);
        poseStack.m_85841_(1.2f, 1.2f, 1.0f);
        this.m_93228_(poseStack, -128, -90, 0, 0, 256, 181);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)(posX + 5), (double)(posY + 12), 0.0);
        poseStack.m_85841_(1.2f, 1.2f, 1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.skill.getSkillTexture());
        RenderSystem.m_69478_();
        GuiComponent.m_93160_((PoseStack)poseStack, (int)0, (int)0, (int)50, (int)50, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        String translationName = this.skill.getTranslationKey();
        String skillName = Component.m_237115_((String)translationName).getString();
        int width = this.f_96547_.m_92895_(skillName);
        this.f_96547_.m_92883_(poseStack, skillName, (float)(posX + 36 - width / 2), (float)(posY + 85), 0);
        String skillCategory = String.format("(%s)", Component.m_237115_((String)("skill.epicfight." + this.skill.getCategory().toString().toLowerCase() + ".category")).getString());
        width = this.f_96547_.m_92895_(skillCategory);
        this.f_96547_.m_92883_(poseStack, skillCategory, (float)(posX + 36 - width / 2), (float)(posY + 100), 0);
        if (this.skill.getCategory() == SkillCategories.PASSIVE) {
            PassiveSkill passiveSkill = (PassiveSkill)this.skill;
            int i = 135;
            for (Map.Entry<Attribute, AttributeModifier> stat : passiveSkill.getModfierEntry()) {
                String attrName = Component.m_237115_((String)stat.getKey().m_22087_()).getString();
                Object amountString = "";
                double amount = stat.getValue().m_22218_();
                switch (stat.getValue().m_22217_()) {
                    case ADDITION: {
                        amountString = ItemStack.f_41584_.format(amount);
                        break;
                    }
                    case MULTIPLY_BASE: {
                        amountString = ItemStack.f_41584_.format(amount * 100.0) + "%";
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        amountString = ItemStack.f_41584_.format(amount * 100.0) + "%";
                    }
                }
                this.f_96547_.m_92883_(poseStack, "+" + (String)amountString + " " + attrName, (float)(posX + 23 - width / 2), (float)(posY + i), 0);
                i += 10;
            }
        }
        List list = this.f_96547_.m_92923_((FormattedText)Component.m_237110_((String)(translationName + ".tooltip"), (Object[])this.skill.getTooltipArgsOfScreen(Lists.newArrayList()).toArray(new Object[0])), 150);
        int height = posY + 20 - Math.min(Math.max(list.size() - 10, 0) * 4, 20);
        for (int l1 = 0; l1 < list.size(); ++l1) {
            FormattedCharSequence ireorderingprocessor1 = (FormattedCharSequence)list.get(l1);
            if (ireorderingprocessor1 != null) {
                this.f_96547_.m_92877_(poseStack, ireorderingprocessor1, (float)(posX + 105), (float)height, 0);
            }
            height += 10;
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (asBackground) {
            this.m_7333_(poseStack);
        }
    }
}

