/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.client.gui.screen.EditSwitchingItemScreen;

@OnlyIn(value=Dist.CLIENT)
public class EditItemListScreen
extends Screen {
    private final Screen parentScreen;
    private final EditSwitchingItemScreen.RegisteredItemList targetList;
    private final EditSwitchingItemScreen.RegisteredItemList opponentList;
    private final List<Item> registered;
    private final List<Item> opponentRegistered;
    private ButtonList itemButtonList;
    private ButtonList selectedItemList;

    protected EditItemListScreen(Screen parentScreen, EditSwitchingItemScreen.RegisteredItemList targetList, EditSwitchingItemScreen.RegisteredItemList opponentList) {
        super((Component)Component.m_237119_());
        this.parentScreen = parentScreen;
        this.targetList = targetList;
        this.opponentList = opponentList;
        this.registered = targetList.toList();
        this.opponentRegistered = opponentList.toList();
    }

    protected void m_7856_() {
        ArrayList itemList = Lists.newArrayList((Iterable)ForgeRegistries.ITEMS.getValues());
        ArrayList selectedItemList = this.selectedItemList == null ? Lists.newArrayList() : this.selectedItemList.toList();
        this.itemButtonList = new ButtonList(this.f_96541_, this.f_96543_ - 50, this.f_96544_, 24, this.f_96544_ - 120, itemList, Type.LIST);
        this.selectedItemList = new ButtonList(this.f_96541_, this.f_96543_ - 50, this.f_96544_, this.f_96544_ - 100, this.f_96544_ - 30, selectedItemList, Type.SELECTED);
        this.itemButtonList.m_93507_(25);
        this.selectedItemList.m_93507_(25);
        this.m_142416_((GuiEventListener)this.itemButtonList);
        this.m_142416_((GuiEventListener)this.selectedItemList);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 125, this.f_96544_ - 26, 60, 20, CommonComponents.f_130655_, button -> {
            for (Item item : this.selectedItemList.toList()) {
                this.targetList.addEntry(item);
                this.opponentList.removeIfPresent(item);
            }
            this.m_7379_();
        }));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        this.itemButtonList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.selectedItemList.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        EditItemListScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)"Item List").m_130940_(ChatFormatting.UNDERLINE), (int)28, (int)10, (int)0xFFFFFF);
        EditItemListScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)"Seleted Items").m_130940_(ChatFormatting.UNDERLINE), (int)28, (int)(this.f_96544_ - 114), (int)0xFFFFFF);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    class ButtonList
    extends ObjectSelectionList<ButtonEntry> {
        private final Type type;
        private final int itemsInColumn;

        public ButtonList(Minecraft mcIn, int width, int height, int top, int bottom, List<Item> items, Type type) {
            super(mcIn, width, height, top, bottom, 18);
            this.itemsInColumn = width / 17;
            this.type = type;
            this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry());
            for (Item item : items) {
                if (this.type == Type.LIST && EditItemListScreen.this.registered.contains(item)) continue;
                this.addItem(item);
            }
        }

        public boolean has(Item item) {
            for (ButtonEntry entry : this.m_6702_()) {
                for (ItemButton button : entry.buttonList) {
                    if (!button.item.equals(item)) continue;
                    return true;
                }
            }
            return false;
        }

        public void addItem(Item item) {
            ButtonEntry entry = (ButtonEntry)this.m_93500_(this.m_6702_().size() - 1);
            if (entry.buttonList.size() > this.itemsInColumn) {
                this.m_7085_((AbstractSelectionList.Entry)new ButtonEntry());
                entry = (ButtonEntry)this.m_93500_(this.m_6702_().size() - 1);
            }
            IPressableExtended pressAction = null;
            Button.OnTooltip onTooltip = null;
            if (this.type == Type.LIST) {
                pressAction = (screen, button, x, y) -> {
                    if (!screen.selectedItemList.has(item)) {
                        screen.selectedItemList.addItem(button.item);
                    }
                };
            } else if (this.type == Type.SELECTED) {
                pressAction = (screen, button, x, y) -> screen.selectedItemList.removeAndRearrange(x, y);
            }
            onTooltip = EditItemListScreen.this.opponentRegistered.contains(item) ? (button, matrixStack, mouseX, mouseY) -> {
                Component displayName = ((ItemButton)button).item.m_7626_(ItemStack.f_41583_);
                EditItemListScreen.this.m_96602_(matrixStack, (Component)Component.m_237110_((String)"epicfight.gui.warn_already_registered", (Object[])new Object[]{displayName.equals(Component.m_237119_()) ? Component.m_237113_((String)ForgeRegistries.ITEMS.getKey((Object)((ItemButton)button).item).toString()) : displayName}), mouseX, mouseY);
            } : (button, matrixStack, mouseX, mouseY) -> {
                Component displayName = ((ItemButton)button).item.m_7626_(ItemStack.f_41583_);
                EditItemListScreen.this.m_96602_(matrixStack, (Component)(displayName.equals(Component.m_237119_()) ? Component.m_237113_((String)ForgeRegistries.ITEMS.getKey((Object)((ItemButton)button).item).toString()) : displayName), mouseX, mouseY);
            };
            entry.buttonList.add(new ItemButton(0, 0, 16, 16, pressAction, onTooltip, EditItemListScreen.this, item));
        }

        public void removeAndRearrange(int x, int y) {
            ((ButtonEntry)this.m_93500_((int)y)).buttonList.remove(x);
        }

        public List<Item> toList() {
            ArrayList result = Lists.newArrayList();
            for (ButtonEntry entry : this.m_6702_()) {
                for (ItemButton button : entry.buttonList) {
                    result.add(button.item);
                }
            }
            return result;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            ButtonEntry listener = this.getEntry(mouseX, mouseY);
            if (listener != null) {
                return listener.m_6375_(mouseX, mouseY, button);
            }
            return false;
        }

        public ButtonEntry getEntry(double mouseX, double mouseY) {
            if (mouseX < (double)(this.f_93393_ + 2) || mouseX > (double)(this.f_93392_ - 8) || mouseY < (double)(this.f_93390_ + 2) || mouseY > (double)(this.f_93391_ - 2)) {
                return null;
            }
            int column = (int)((this.m_93517_() + mouseY - (double)this.f_93390_ - 4.0) / (double)this.f_93387_);
            if (this.m_6702_().size() > column) {
                return (ButtonEntry)this.m_93500_(column);
            }
            return null;
        }

        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.m_7733_(matrixStack);
            int i = this.m_5756_();
            int j = i + 6;
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_7421_((float)this.f_93393_ / 32.0f, (float)(this.f_93391_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_7421_((float)this.f_93392_ / 32.0f, (float)(this.f_93391_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_7421_((float)this.f_93392_ / 32.0f, (float)(this.f_93390_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_7421_((float)this.f_93393_ / 32.0f, (float)(this.f_93390_ + (int)this.m_93517_()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            tessellator.m_85914_();
            int j1 = this.m_5747_();
            int k = this.f_93390_ + 4 - (int)this.m_93517_();
            this.m_7154_(matrixStack, j1, k, tessellator);
            this.m_239227_(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
            RenderSystem.m_69482_();
            RenderSystem.m_69456_((int)519);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, -100.0).m_7421_(0.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93390_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93390_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93390_ - 16.0, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)(this.f_93390_ - 16) / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_ - 16.0, -100.0).m_7421_(0.0f, (float)(this.f_93390_ - 16) / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93389_, -100.0).m_7421_(0.0f, (float)this.f_93389_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93389_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93389_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93391_, -100.0).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, -100.0).m_7421_(0.0f, (float)this.f_93391_ / 32.0f).m_6122_(64, 64, 64, 255).m_5752_();
            tessellator.m_85914_();
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69465_();
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93392_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)this.f_93393_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            tessellator.m_85914_();
            int k1 = this.m_93518_();
            if (k1 > 0) {
                RenderSystem.m_69472_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                int l1 = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
                l1 = Mth.m_14045_((int)l1, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
                int i2 = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - l1) / k1 + this.f_93390_;
                if (i2 < this.f_93390_) {
                    i2 = this.f_93390_;
                }
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_5483_((double)i, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)(i2 + l1), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)(i2 + l1), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)j, (double)i2, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)i2, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)(i2 + l1 - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)(j - 1), (double)(i2 + l1 - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)(j - 1), (double)i2, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
                bufferbuilder.m_5483_((double)i, (double)i2, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
                tessellator.m_85914_();
            }
            this.m_7415_(matrixStack, mouseX, mouseY);
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
        }

        public int m_5747_() {
            return this.f_93393_ + 2;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        @OnlyIn(value=Dist.CLIENT)
        class ButtonEntry
        extends ObjectSelectionList.Entry<ButtonEntry> {
            private final List<ItemButton> buttonList = Lists.newArrayList();

            public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                int x = 0;
                for (ItemButton button : this.buttonList) {
                    button.f_93620_ = left + x;
                    button.f_93621_ = top;
                    button.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
                    x += 16;
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    int row = (int)((mouseX - (double)ButtonList.this.f_93393_ - 2.0) / 16.0);
                    int column = (int)((ButtonList.this.m_93517_() + mouseY - (double)ButtonList.this.f_93390_ - 4.0) / (double)ButtonList.this.f_93387_);
                    ItemButton itembutton = this.getButton(row);
                    if (itembutton != null) {
                        ItemButton itemButton = itembutton = itembutton.m_5953_(mouseX, mouseY) ? itembutton : null;
                        if (itembutton != null) {
                            itembutton.pressedAction.onPress(EditItemListScreen.this, itembutton, row, column);
                            itembutton.m_7435_(Minecraft.m_91087_().m_91106_());
                        }
                    }
                }
                return false;
            }

            public ItemButton getButton(int index) {
                return this.buttonList.size() > index ? this.buttonList.get(index) : null;
            }

            public Component m_142172_() {
                return Component.m_237119_();
            }
        }
    }

    private static enum Type {
        LIST,
        SELECTED;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressableExtended {
        public void onPress(EditItemListScreen var1, ItemButton var2, int var3, int var4);
    }

    class ItemButton
    extends Button {
        private final Item item;
        private final IPressableExtended pressedAction;

        public ItemButton(int x, int y, int width, int height, IPressableExtended pressedAction, Button.OnTooltip onTooltip, EditItemListScreen screen, Item item) {
            super(x, y, width, height, (Component)Component.m_237119_(), button -> {}, onTooltip);
            this.item = item;
            this.pressedAction = pressedAction;
        }

        public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.m_5953_(mouseX, mouseY)) {
                Tesselator tessellator = Tesselator.m_85913_();
                GlStateManager.m_84110_();
                BufferBuilder bufferbuilder = tessellator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bufferbuilder.m_5483_((double)this.f_93620_, (double)this.f_93621_ + (double)this.f_93619_, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)this.f_93620_ + (double)this.f_93618_, (double)this.f_93621_ + (double)this.f_93619_, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)this.f_93620_ + (double)this.f_93618_, (double)this.f_93621_, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)this.f_93620_, (double)this.f_93621_, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
                tessellator.m_85914_();
                this.f_93718_.m_93752_((Button)this, matrixStack, mouseX, mouseY);
            }
            try {
                EditItemListScreen.this.f_96542_.m_115123_(new ItemStack((ItemLike)this.item), this.f_93620_, this.f_93621_);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

