/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.epiccompat_parcool.forge.network.client;

import com.gitlab.srcmc.epiccompat_parcool.forge.client.capabilities.IParkourPlayerPatch;
import com.gitlab.srcmc.epiccompat_parcool.forge.network.NetworkManager;
import com.gitlab.srcmc.epiccompat_parcool.forge.network.server.SPSetParkourActive;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CPSetParkourActive {
    private final boolean parkourActive;

    public CPSetParkourActive() {
        this.parkourActive = false;
    }

    public CPSetParkourActive(boolean parkourActive) {
        this.parkourActive = parkourActive;
    }

    public static CPSetParkourActive fromBytes(FriendlyByteBuf buf) {
        return new CPSetParkourActive(buf.readBoolean());
    }

    public static void toBytes(CPSetParkourActive msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.parkourActive);
    }

    public static void handle(CPSetParkourActive msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IParkourPlayerPatch entitypatch;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (entitypatch = (IParkourPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class)) != null) {
                entitypatch.setParkourActive(msg.parkourActive);
                NetworkManager.sendToAllPlayerTrackingThisEntity(new SPSetParkourActive(msg.parkourActive, player.m_19879_()), (Entity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

