/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.mixin;

import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.common.util.DietRegeneration;
import com.illusivesoulworks.diet.common.util.PlayerSensitive;
import com.illusivesoulworks.diet.platform.Services;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public class DietMixinFoodData
implements PlayerSensitive {
    Player diet_player;

    @Inject(at={@At(value="TAIL")}, method={"eat(IF)V"})
    public void diet$eat(int healing, float saturationModifier, CallbackInfo ci) {
        if (this.diet_player == null) {
            DietConstants.LOG.error("Attempted to add food stats to a null player!");
            return;
        }
        Services.CAPABILITY.get(this.diet_player).ifPresent(tracker -> {
            ItemStack captured = tracker.getCapturedStack();
            if (!captured.m_41619_()) {
                tracker.consume(captured, healing, saturationModifier);
                tracker.captureStack(ItemStack.f_41583_);
            }
        });
    }

    @ModifyVariable(at=@At(value="INVOKE_ASSIGN", target="net/minecraft/world/level/GameRules.getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z"), method={"tick(Lnet/minecraft/world/entity/player/Player;)V"})
    public boolean diet$tick(boolean flag) {
        return this.diet_player != null ? DietRegeneration.hasRegen(this.diet_player, flag) : flag;
    }

    @Override
    public void setPlayer(Player playerIn) {
        this.diet_player = playerIn;
    }
}

