/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.integration.gamestages.GameStagesPlugin;

public class ChampionHelper {
    private static final Set<BlockPos> BEACON_POS = new HashSet<BlockPos>();
    private static MinecraftServer server = null;

    public static boolean isValidChampion(Entity entity) {
        return entity instanceof LivingEntity && entity instanceof Enemy;
    }

    public static boolean checkPotential(LivingEntity livingEntity) {
        return ChampionHelper.isValidEntity(livingEntity) && ChampionHelper.isValidDimension(livingEntity.f_19853_.m_46472_().m_135782_()) && !ChampionHelper.nearActiveBeacon(livingEntity) && (!Champions.gameStagesLoaded || GameStagesPlugin.hasEntityStage(livingEntity));
    }

    public static void addBeacon(BlockPos pos) {
        if (server != null) {
            BEACON_POS.add(pos);
        }
    }

    private static boolean isValidEntity(LivingEntity livingEntity) {
        ResourceLocation rl = livingEntity.m_6095_().m_20677_();
        if (rl == null) {
            return false;
        }
        String entity = rl.toString();
        if (ChampionsConfig.entitiesPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.entitiesList.contains(entity);
        }
        return ChampionsConfig.entitiesList.contains(entity);
    }

    private static boolean isValidDimension(ResourceLocation resourceLocation) {
        String dimension = resourceLocation.toString();
        if (ChampionsConfig.dimensionPermission == ConfigEnums.Permission.BLACKLIST) {
            return !ChampionsConfig.dimensionList.contains(dimension);
        }
        return ChampionsConfig.dimensionList.contains(dimension);
    }

    private static boolean nearActiveBeacon(LivingEntity livingEntity) {
        int range = ChampionsConfig.beaconProtectionRange;
        if (range <= 0) {
            return false;
        }
        HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
        Iterator<BlockPos> iterator = BEACON_POS.iterator();
        while (iterator.hasNext()) {
            Level level = livingEntity.f_19853_;
            BlockPos pos = iterator.next();
            if (!level.m_46749_(pos)) continue;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BeaconBlockEntity) {
                BeaconBlockEntity beaconBlockEntity = (BeaconBlockEntity)blockEntity;
                if (!blockEntity.m_58901_()) {
                    if (!(Math.sqrt(livingEntity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) <= (double)range) || beaconBlockEntity.f_58650_ <= 0) continue;
                    return true;
                }
            }
            toRemove.add(pos);
        }
        BEACON_POS.removeAll(toRemove);
        return false;
    }

    public static void clearBeacons() {
        BEACON_POS.clear();
    }

    public static void setServer(MinecraftServer serverIn) {
        server = serverIn;
    }
}

