/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.registry;

import com.mojang.serialization.Codec;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.champions.common.entity.ArcticBulletEntity;
import top.theillusivec4.champions.common.entity.EnkindlingBulletEntity;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.loot.ChampionLootModifier;
import top.theillusivec4.champions.common.potion.ParalysisEffect;
import top.theillusivec4.champions.common.potion.WoundEffect;
import top.theillusivec4.champions.server.command.AffixArgumentInfo;
import top.theillusivec4.champions.server.command.AffixArgumentType;

public class ChampionsRegistry {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"champions");
    private static final DeferredRegister<Item> EGG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"champions");
    private static final DeferredRegister<ParticleType<?>> PARTICLE_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"champions");
    private static final DeferredRegister<MobEffect> MOB_EFFECT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"champions");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"champions");
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> ARGUMENT_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)"champions");
    public static RegistryObject<Codec<ChampionLootModifier>> CHAMPION_LOOT;
    public static RegistryObject<EntityType<? extends EnkindlingBulletEntity>> ENKINDLING_BULLET;
    public static RegistryObject<EntityType<? extends ArcticBulletEntity>> ARCTIC_BULLET;
    public static RegistryObject<ChampionEggItem> CHAMPION_EGG_ITEM;
    public static RegistryObject<SimpleParticleType> RANK_PARTICLE_TYPE;
    public static RegistryObject<ParalysisEffect> PARALYSIS_EFFECT_TYPE;
    public static RegistryObject<WoundEffect> WOUND_EFFECT_TYPE;
    public static RegistryObject<AffixArgumentInfo> AFFIX_ARGUMENT_TYPE;

    public static void registerItems(IEventBus bus) {
        CHAMPION_EGG_ITEM = EGG.register("champion_egg", ChampionEggItem::new);
        EGG.register(bus);
    }

    public static void registerLootModifiers(IEventBus bus) {
        CHAMPION_LOOT = LOOT_MODIFIER_SERIALIZERS.register("champion_loot", () -> ChampionLootModifier.CODEC);
        LOOT_MODIFIER_SERIALIZERS.register(bus);
    }

    public static void registerArgumentType(IEventBus bus) {
        AFFIX_ARGUMENT_TYPE = ARGUMENT_TYPES.register("affixes", () -> (AffixArgumentInfo)ArgumentTypeInfos.registerByClass(AffixArgumentType.class, (ArgumentTypeInfo)new AffixArgumentInfo()));
        ARGUMENT_TYPES.register(bus);
    }

    public static void registerParticles(IEventBus bus) {
        RANK_PARTICLE_TYPE = PARTICLE_TYPE.register("rank", () -> new SimpleParticleType(true));
        PARTICLE_TYPE.register(bus);
    }

    public static void registerMobEffects(IEventBus bus) {
        PARALYSIS_EFFECT_TYPE = MOB_EFFECT.register("paralysis", ParalysisEffect::new);
        WOUND_EFFECT_TYPE = MOB_EFFECT.register("wound", WoundEffect::new);
        MOB_EFFECT.register(bus);
    }

    public static void registerEntityTypes(IEventBus bus) {
        ARCTIC_BULLET = ENTITY_TYPE.register("arctic_bullet", () -> EntityType.Builder.m_20704_(ArcticBulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).m_20712_("champions"));
        ENKINDLING_BULLET = ENTITY_TYPE.register("enkindling_bullet", () -> EntityType.Builder.m_20704_(EnkindlingBulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).m_20712_("champions"));
        ENTITY_TYPE.register(bus);
    }

    public static void register(IEventBus bus) {
        ChampionsRegistry.registerItems(bus);
        ChampionsRegistry.registerParticles(bus);
        ChampionsRegistry.registerMobEffects(bus);
        ChampionsRegistry.registerEntityTypes(bus);
        ChampionsRegistry.registerLootModifiers(bus);
        ChampionsRegistry.registerArgumentType(bus);
    }
}

